/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String attachmentsPattern;

    public AttachmentUtils(String attachmentsPattern) {
        this.attachmentsPattern = attachmentsPattern;
    }

    private List<MimeBodyPart> getAttachments(AbstractBuild<?, ?> build, BuildListener listener) throws MessagingException, InterruptedException, IOException {
        ArrayList<MimeBodyPart> attachments = null;
        FilePath ws = build.getWorkspace();
        long totalAttachmentSize = 0L;
        long maxAttachmentSize = ExtendedEmailPublisher.DESCRIPTOR.getMaxAttachmentSize();
        if (ws == null) {
            listener.error("Error: No workspace found!");
        } else if (!StringUtils.isBlank((String)this.attachmentsPattern)) {
            FilePath[] files;
            attachments = new ArrayList<MimeBodyPart>();
            for (FilePath file : files = ws.list(this.attachmentsPattern)) {
                if (maxAttachmentSize > 0L && totalAttachmentSize + file.length() >= maxAttachmentSize) {
                    listener.getLogger().println("Skipping `" + file.getName() + "' (" + file.length() + " bytes) - too large for maximum attachments size");
                    continue;
                }
                MimeBodyPart attachmentPart = new MimeBodyPart();
                FilePathDataSource fileDataSource = new FilePathDataSource(file);
                try {
                    attachmentPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                    attachmentPart.setFileName(file.getName());
                    attachments.add(attachmentPart);
                    totalAttachmentSize += file.length();
                }
                catch (MessagingException e) {
                    listener.getLogger().println("Error adding `" + file.getName() + "' as attachment - " + e.getMessage());
                }
            }
        }
        return attachments;
    }

    public void attach(Multipart multipart, AbstractBuild<?, ?> build, BuildListener listener) {
        try {
            List<MimeBodyPart> attachments = this.getAttachments(build, listener);
            if (attachments != null) {
                for (MimeBodyPart attachment : attachments) {
                    multipart.addBodyPart((BodyPart)attachment);
                }
            }
        }
        catch (IOException e) {
            listener.error("Error accessing files to attach: " + e.getMessage());
        }
        catch (MessagingException e) {
            listener.error("Error attaching items to message: " + e.getMessage());
        }
        catch (InterruptedException e) {
            listener.error("Interrupted in processing attachments: " + e.getMessage());
        }
    }

    public static void attachBuildLog(Multipart multipart, AbstractBuild<?, ?> build, BuildListener listener) {
        try {
            File logFile = build.getLogFile();
            long maxAttachmentSize = ExtendedEmailPublisher.DESCRIPTOR.getMaxAttachmentSize();
            if (maxAttachmentSize > 0L && logFile.length() >= maxAttachmentSize) {
                listener.getLogger().println("Skipping build log attachment -  too large for maximum attachments size");
                return;
            }
            FileDataSource fileSource = new FileDataSource(logFile);
            MimeBodyPart attachment = new MimeBodyPart();
            attachment.setDataHandler(new DataHandler((DataSource)fileSource));
            attachment.setFileName("build.log");
            multipart.addBodyPart((BodyPart)attachment);
        }
        catch (MessagingException e) {
            listener.error("Error attaching build log to message: " + e.getMessage());
        }
    }

    private static class FilePathDataSource
    implements DataSource {
        private FilePath file;

        public FilePathDataSource(FilePath file) {
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            return this.file.read();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Unsupported");
        }

        public String getContentType() {
            return MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(this.file.getName());
        }

        public String getName() {
            return this.file.getName();
        }
    }
}

