/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailedTestsContent
implements EmailContent {
    private static final String TOKEN = "FAILED_TESTS";
    private static final String SHOW_STACK_NAME = "showStack";
    private static final boolean SHOW_STACK_DEFAULT = true;
    public static final String MAX_TESTS_ARG_NAME = "maxTests";
    static final String ONLY_REGRESSIONS_NAME = "onlyRegressions";
    private static final boolean ONLY_REGRESSIONS_DEFAULT = false;

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public List<String> getArguments() {
        return Arrays.asList(SHOW_STACK_NAME, MAX_TESTS_ARG_NAME, ONLY_REGRESSIONS_NAME);
    }

    @Override
    public String getHelpText() {
        return "Displays failing unit test information, if any tests have failed.\n<ul>\n<li><i>showStack</i> - indicates that most recent builds should be at the top.<br>\nDefaults to true.\n<li><i>onlyRegressions</i> - indicates that only regressions compared to the previous builds should be shown.<br>\nDefaults to true.\n<li><i>maxTests</i> - display at most this many failing tests.<br>\nNo limit is set by default.\n</ul>\n";
    }

    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        StringBuffer buffer = new StringBuffer();
        AbstractTestResultAction testResult = build.getTestResultAction();
        if (null == testResult) {
            return "No tests ran.";
        }
        int failCount = testResult.getFailCount();
        if (failCount == 0) {
            buffer.append("All tests passed");
        } else {
            boolean showOldFailures;
            buffer.append(failCount);
            buffer.append(" tests failed.");
            buffer.append('\n');
            boolean showStacks = EmailContent.Args.get(args, SHOW_STACK_NAME, true);
            int maxTests = EmailContent.Args.get(args, MAX_TESTS_ARG_NAME, Integer.MAX_VALUE);
            boolean bl = showOldFailures = !EmailContent.Args.get(args, ONLY_REGRESSIONS_NAME, false);
            if (maxTests > 0) {
                int printedTests = 0;
                for (CaseResult failedTest : testResult.getFailedTests()) {
                    if (!showOldFailures && failedTest.getAge() != 1 || printedTests >= maxTests) continue;
                    this.outputTest(buffer, failedTest, showStacks);
                    ++printedTests;
                }
                if (failCount > printedTests) {
                    buffer.append("... and ");
                    buffer.append(failCount - printedTests);
                    buffer.append(" other failed tests.\n\n");
                }
            }
        }
        return buffer.toString();
    }

    private void outputTest(StringBuffer buffer, CaseResult failedTest, boolean showStack) {
        buffer.append(failedTest.getStatus().toString());
        buffer.append(":  ");
        buffer.append(failedTest.getClassName());
        buffer.append(".");
        buffer.append(failedTest.getDisplayName());
        buffer.append("\n\n");
        buffer.append("Error Message:\n");
        buffer.append(failedTest.getErrorDetails());
        if (showStack) {
            buffer.append("\n\nStack Trace:\n");
            buffer.append(failedTest.getErrorStackTrace());
        }
        buffer.append("\n\n");
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

