/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.Mailer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLogRegexContent
implements EmailContent {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    private static final String TOKEN = "BUILD_LOG_REGEX";
    private static final String REGEX_ARG_NAME = "regex";
    private static final String REGEX_DEFAULT_VALUE = "(?i)\\b(error|exception|fatal|fail(ed|ure)|un(defined|resolved))\\b";
    private static final String LINES_BEFORE_ARG_NAME = "linesBefore";
    private static final int LINES_BEFORE_DEFAULT_VALUE = 0;
    private static final String LINES_AFTER_ARG_NAME = "linesAfter";
    private static final int LINES_AFTER_DEFAULT_VALUE = 0;
    private static final String MAX_MATCHES_ARG_NAME = "maxMatches";
    private static final int MAX_MATCHES_DEFAULT_VALUE = 0;
    private static final String SHOW_TRUNCATED_LINES_ARG_NAME = "showTruncatedLines";
    private static final boolean SHOW_TRUNCATED_LINES_DEFAULT_VALUE = true;
    private static final String SUBST_TEXT_ARG_NAME = "substText";
    private static final String SUBST_TEXT_DEFAULT_VALUE = null;
    private static final String ESCAPE_HTML_ARG_NAME = "escapeHtml";
    private static final boolean ESCAPE_HTML_DEFAULT_VALUE = false;
    private static final String MATCHED_LINE_HTML_STYLE_ARG_NAME = "matchedLineHtmlStyle";
    private static final String MATCHED_LINE_HTML_STYLE_DEFAULT_VALUE = null;

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public List<String> getArguments() {
        return Arrays.asList(REGEX_ARG_NAME, LINES_BEFORE_ARG_NAME, LINES_AFTER_ARG_NAME, MAX_MATCHES_ARG_NAME, SHOW_TRUNCATED_LINES_ARG_NAME, SUBST_TEXT_ARG_NAME, ESCAPE_HTML_ARG_NAME, MATCHED_LINE_HTML_STYLE_ARG_NAME);
    }

    @Override
    public String getHelpText() {
        return "Displays lines from the build log that match the regular expression.\n<ul>\n<li><i>regex</i> - Lines that match this regular expression are included. See also <i>java.util.regex.Pattern</i><br>\nDefaults to \"(?i)\\b(error|exception|fatal|fail(ed|ure)|un(defined|resolved))\\b\".\n<li><i>linesBefore</i> - The number of lines to include before the matching line. Lines that overlap with another match or <i>linesAfter</i> are only included once.<br>\nDefaults to 0.\n<li><i>linesAfter</i> - The number of lines to include after the matching line. Lines that overlap with another match or <i>linesBefore</i> are only included once.<br>\nDefaults to 0.\n<li><i>maxMatches</i> - The maximum number of matches to include. If 0, all matches will be included.<br>\nDefaults to 0.\n<li><i>showTruncatedLines</i> - If <i>true</i>, include <tt>[...truncated ### lines...]</tt> lines.<br>\nDefaults to true.\n<li><i>substText</i> - If non-null, insert this text into the email rather than the entire line.<br>\nDefaults to null.\n<li><i>escapeHtml</i> - If true, escape HTML.<br>\nDefaults to false.\n<li><i>matchedLineHtmlStyle</i> - If non-null, output HTML. matched lines will become <code>&lt;b style=\"your-style-value\"&gt;html escaped matched line&lt;/b&gt;</code>.<br>\nDefaults to null.\n</ul>\n";
    }

    private boolean startPre(StringBuffer buffer, boolean insidePre) {
        if (!insidePre) {
            buffer.append("<pre>\n");
            insidePre = true;
        }
        return insidePre;
    }

    private boolean stopPre(StringBuffer buffer, boolean insidePre) {
        if (insidePre) {
            buffer.append("</pre>\n");
            insidePre = false;
        }
        return insidePre;
    }

    private void appendContextLine(StringBuffer buffer, String line, boolean escapeHtml) {
        if (escapeHtml) {
            line = StringEscapeUtils.escapeHtml((String)line);
        }
        buffer.append(line);
        buffer.append('\n');
    }

    private void appendMatchedLine(StringBuffer buffer, String line, boolean escapeHtml, String style) {
        if (escapeHtml) {
            line = StringEscapeUtils.escapeHtml((String)line);
        }
        if (style != null) {
            buffer.append("<b");
            if (style.length() > 0) {
                buffer.append(" style=\"");
                buffer.append(style);
                buffer.append("\"");
            }
            buffer.append(">");
        }
        buffer.append(line);
        if (style != null) {
            buffer.append("</b>");
        }
        buffer.append('\n');
    }

    private void appendLinesTruncated(StringBuffer buffer, int numLinesTruncated, boolean asHtml) {
        if (asHtml) {
            buffer.append("<p>");
        }
        buffer.append("[...truncated ");
        buffer.append(numLinesTruncated);
        buffer.append(" lines...]");
        if (asHtml) {
            buffer.append("</p>");
        }
        buffer.append('\n');
    }

    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(build.getLogFile()));
            String transformedContent = this.getContent(reader, args);
            reader.close();
            return transformedContent;
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return "";
        }
    }

    String getContent(BufferedReader reader, Map<String, ?> args) throws IOException {
        String regex = EmailContent.Args.get(args, REGEX_ARG_NAME, REGEX_DEFAULT_VALUE);
        int contextLinesBefore = EmailContent.Args.get(args, LINES_BEFORE_ARG_NAME, 0);
        int contextLinesAfter = EmailContent.Args.get(args, LINES_AFTER_ARG_NAME, 0);
        int maxMatches = EmailContent.Args.get(args, MAX_MATCHES_ARG_NAME, 0);
        boolean showTruncatedLines = EmailContent.Args.get(args, SHOW_TRUNCATED_LINES_ARG_NAME, true);
        String substText = EmailContent.Args.get(args, SUBST_TEXT_ARG_NAME, SUBST_TEXT_DEFAULT_VALUE);
        String matchedLineHtmlStyle = EmailContent.Args.get(args, MATCHED_LINE_HTML_STYLE_ARG_NAME, MATCHED_LINE_HTML_STYLE_DEFAULT_VALUE);
        boolean asHtml = matchedLineHtmlStyle != null;
        boolean escapeHtml = asHtml || EmailContent.Args.get(args, ESCAPE_HTML_ARG_NAME, false);
        Pattern pattern = Pattern.compile(regex);
        StringBuffer buffer = new StringBuffer();
        int numLinesTruncated = 0;
        int numMatches = 0;
        int numLinesStillNeeded = 0;
        boolean insidePre = false;
        LinkedList<String> linesBefore = new LinkedList<String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = ConsoleNote.removeNotes((String)line);
            while (linesBefore.size() > contextLinesBefore) {
                linesBefore.remove();
                ++numLinesTruncated;
            }
            Matcher matcher = pattern.matcher(line);
            StringBuffer sb = new StringBuffer();
            boolean matched = false;
            while (matcher.find()) {
                matched = true;
                if (substText == null) break;
                matcher.appendReplacement(sb, substText);
            }
            if (matched) {
                if (showTruncatedLines && numLinesTruncated > 0) {
                    insidePre = this.stopPre(buffer, insidePre);
                    this.appendLinesTruncated(buffer, numLinesTruncated, asHtml);
                    numLinesTruncated = 0;
                }
                if (asHtml) {
                    insidePre = this.startPre(buffer, insidePre);
                }
                while (!linesBefore.isEmpty()) {
                    this.appendContextLine(buffer, (String)linesBefore.remove(), escapeHtml);
                }
                if (substText != null) {
                    matcher.appendTail(sb);
                    line = sb.toString();
                }
                this.appendMatchedLine(buffer, line, escapeHtml, matchedLineHtmlStyle);
                ++numMatches;
                numLinesStillNeeded = contextLinesAfter;
            } else if (numLinesStillNeeded > 0) {
                this.appendContextLine(buffer, line, escapeHtml);
                --numLinesStillNeeded;
            } else {
                linesBefore.offer(line);
            }
            if (maxMatches == 0 || numMatches < maxMatches || numLinesStillNeeded != 0) continue;
            break;
        }
        if (showTruncatedLines) {
            while (linesBefore.size() > 0) {
                linesBefore.remove();
                ++numLinesTruncated;
            }
            if (line != null) {
                while ((line = reader.readLine()) != null) {
                    ++numLinesTruncated;
                }
            }
            if (numLinesTruncated > 0) {
                insidePre = this.stopPre(buffer, insidePre);
                this.appendLinesTruncated(buffer, numLinesTruncated, asHtml);
            }
        }
        insidePre = this.stopPre(buffer, insidePre);
        return buffer.toString();
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

