/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JellyScriptContent
implements EmailContent {
    private static final Logger LOGGER = Logger.getLogger(JellyScriptContent.class.getName());
    public static final String TEMPLATE_NAME_ARG = "template";
    private static final String DEFAULT_HTML_TEMPLATE_NAME = "html";
    private static final String DEFAULT_TEXT_TEMPLATE_NAME = "text";
    private static final String DEFAULT_TEMPLATE_NAME = "html";
    private static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";

    @Override
    public String getToken() {
        return "JELLY_SCRIPT";
    }

    @Override
    public String getHelpText() {
        return "Custom message content generated from a Jelly script template. There are two templates provided: \"html\" and \"text\". Custom Jelly templates should be placed in $JENKINS_HOME/email-templates. When using custom templates, the template filename without \".jelly\" should be used for the \"template\" argument.\n<ul>\n<li><i>template</i> - the template name.<br>\nDefaults to \"html\".\n</ul>\n";
    }

    @Override
    public List<String> getArguments() {
        return Collections.singletonList(TEMPLATE_NAME_ARG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType type, Map<String, ?> args) throws IOException, InterruptedException {
        InputStream inputStream = null;
        String templateName = EmailContent.Args.get(args, TEMPLATE_NAME_ARG, "html");
        try {
            inputStream = this.getTemplateInputStream(templateName);
            String string = this.renderContent(build, inputStream);
            return string;
        }
        catch (JellyException e) {
            LOGGER.log(Level.SEVERE, null, e);
            String string = "JellyException: " + e.getMessage();
            return string;
        }
        catch (FileNotFoundException e) {
            String missingTemplateError = this.generateMissingTemplate(templateName);
            LOGGER.log(Level.SEVERE, missingTemplateError);
            String string = missingTemplateError;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private String generateMissingTemplate(String template) {
        return "Jelly script [" + template + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    private InputStream getTemplateInputStream(String templateName) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + templateName + ".jelly");
        if (inputStream == null) {
            File templatesFolder = new File(Hudson.getInstance().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
            File templateFile = new File(templatesFolder, templateName + ".jelly");
            inputStream = new FileInputStream(templateFile);
        }
        return inputStream;
    }

    private String renderContent(AbstractBuild<?, ?> build, InputStream inputStream) throws JellyException, IOException {
        JellyContext context = this.createContext(new ScriptContentBuildWrapper(build), build);
        Script script = context.compileScript(new InputSource(inputStream));
        if (script != null) {
            return this.convert(context, script);
        }
        return null;
    }

    private String convert(JellyContext context, Script script) throws JellyTagException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(16384);
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)output);
        script.run(context, xmlOutput);
        xmlOutput.flush();
        xmlOutput.close();
        output.close();
        return output.toString();
    }

    private JellyContext createContext(Object it, AbstractBuild<?, ?> build) {
        JellyContext context = new JellyContext();
        context.setVariable("it", it);
        context.setVariable("build", build);
        context.setVariable("project", (Object)build.getParent());
        context.setVariable("rooturl", (Object)ExtendedEmailPublisher.DESCRIPTOR.getHudsonUrl());
        return context;
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

