/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.trigger.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StillUnstableTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Still Unstable";
    public static DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Override
    public boolean trigger(AbstractBuild<?, ?> build) {
        AbstractBuild prevBuild;
        Result buildResult = build.getResult();
        return buildResult == Result.UNSTABLE && (prevBuild = (AbstractBuild)build.getPreviousBuild()) != null && prevBuild.getResult() == Result.UNSTABLE;
    }

    @Override
    public EmailTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public boolean getDefaultSendToDevs() {
        return true;
    }

    @Override
    public boolean getDefaultSendToList() {
        return false;
    }

    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Unstable");
        }

        public String getTriggerName() {
            return StillUnstableTrigger.TRIGGER_NAME;
        }

        public EmailTrigger newInstance() {
            return new StillUnstableTrigger();
        }

        public String getHelpText() {
            return Messages.StillUnstableTrigger_HelpText();
        }
    }
}

