/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RecipientProviderUtilities;
import jakarta.mail.internet.InternetAddress;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.scm.RunWithSCM;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class CulpritsRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public CulpritsRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        final class Debug
        implements RecipientProviderUtilities.IDebug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            @Override
            public void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        Run run = context.getRun();
        if (run instanceof RunWithSCM) {
            Set culprits = ((RunWithSCM)run).getCulprits();
            RecipientProviderUtilities.addUsers((Set<User>)culprits, context, env, to, cc, bcc, (RecipientProviderUtilities.IDebug)debug);
        } else {
            ArrayList builds = new ArrayList();
            Run build = run;
            builds.add(build);
            for (build = build.getPreviousCompletedBuild(); build != null; build = build.getPreviousCompletedBuild()) {
                Result buildResult = build.getResult();
                if (buildResult == null) continue;
                if (!buildResult.isWorseThan(Result.SUCCESS)) break;
                debug.send("Including build %s with status %s", build.getId(), buildResult);
                builds.add(build);
            }
            Set<User> users = RecipientProviderUtilities.getChangeSetAuthors(builds, debug);
            RecipientProviderUtilities.addUsers(users, context, env, to, cc, bcc, (RecipientProviderUtilities.IDebug)debug);
        }
    }

    @Extension
    @Symbol(value={"culprits"})
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.CulpritsRecipientProvider_DisplayName();
        }
    }
}

