/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RecipientProviderUtilities;
import jakarta.mail.internet.InternetAddress;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class FirstFailingBuildSuspectsRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public FirstFailingBuildSuspectsRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        final class Debug
        implements RecipientProviderUtilities.IDebug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            @Override
            public void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        HashSet<User> users = null;
        Run currentRun = context.getRun();
        if (currentRun == null) {
            debug.send("currentRun was null", new Object[0]);
        } else if (!Objects.equals(currentRun.getResult(), Result.FAILURE)) {
            debug.send("currentBuild did not fail", new Object[0]);
        } else {
            Result candidateResult;
            users = new HashSet<User>();
            debug.send("Collecting builds with suspects...", new Object[0]);
            HashSet buildsWithSuspects = new HashSet();
            Run firstFailedBuild = currentRun;
            for (Run candidate = currentRun; candidate != null && (candidateResult = candidate.getResult()) != null && candidateResult.isWorseOrEqualTo(Result.FAILURE); candidate = candidate.getPreviousCompletedBuild()) {
                firstFailedBuild = candidate;
            }
            buildsWithSuspects.add(firstFailedBuild);
            debug.send("Collecting suspects...", new Object[0]);
            users.addAll(RecipientProviderUtilities.getChangeSetAuthors(buildsWithSuspects, debug));
            users.addAll(RecipientProviderUtilities.getUsersTriggeringTheBuilds(buildsWithSuspects, debug));
        }
        if (users != null) {
            RecipientProviderUtilities.addUsers(users, context, env, to, cc, bcc, (RecipientProviderUtilities.IDebug)debug);
        }
    }

    @Extension
    @Symbol(value={"brokenBuildSuspects"})
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.FirstFailingBuildSuspectsRecipientProvider_DisplayName();
        }
    }
}

