/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.emailext.Messages;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.stapler.DataBoundConstructor;

public class GroovyTemplateConfig
extends Config {
    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(GroovyTemplateConfigProvider.class);
    }

    @DataBoundConstructor
    public GroovyTemplateConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
        ScriptApproval.get().configuring(content, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    public Object readResolve() {
        ScriptApproval.get().configuring(this.content, GroovyLanguage.get(), ApprovalContext.create());
        return this;
    }

    @Extension(optional=true)
    public static final class GroovyTemplateConfigProvider
    extends AbstractConfigProviderImpl {
        public GroovyTemplateConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return ContentType.DefinedType.GROOVY;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.GroovyTemplateConfigProvider_DisplayName();
        }

        @NonNull
        public Config newConfig(@NonNull String id) {
            return new GroovyTemplateConfig(id, "Groovy Email Template", "", "");
        }

        @Deprecated
        protected String getXmlFileName() {
            return "email-ext-groovy-config-files.xml";
        }
    }
}

