/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.slaves.SlaveComputer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.shared.utils.io.DirectoryScanner;

public class FileHelper {
    public static String buildPath(String ... path) {
        StringBuilder result = new StringBuilder();
        for (String s : path) {
            if (s.equals("/")) {
                s = File.separator;
            }
            result.append(s);
        }
        return result.toString();
    }

    public static String cutTopLevelDir(String path) {
        return FileHelper.cutTopLevelDir(FileHelper.splitFileSystemPath(path));
    }

    public static String cutTopLevelDir(String[] path) {
        StringBuilder result = new StringBuilder();
        int len = path.length;
        --len;
        for (int i = 1; i < len; ++i) {
            result.append(path[i]).append(File.separator);
        }
        result.append(path[len]);
        return result.toString();
    }

    static void modifyFile(String filePath, String oldString, String newString) throws IOException {
        String line;
        StringBuilder oldContent = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        while ((line = reader.readLine()) != null) {
            oldContent.append(line).append(System.lineSeparator());
        }
        String newContent = oldContent.toString().replace(oldString, newString);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
        out.append(newContent);
        ((Writer)out).flush();
        reader.close();
        ((Writer)out).close();
    }

    static String[] splitFileSystemPath(String path) {
        return path.split(Pattern.quote(File.separator));
    }

    static String[] splitPath(String path) {
        return FileHelper.splitPath(",", path);
    }

    static String[] splitPath(String separator, String path) {
        String[] list = path.split(separator);
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].trim();
        }
        return list;
    }

    static List<File> getFilesFromDirectory(File folder) {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] list = folder.listFiles();
        if (list == null) {
            return fileList;
        }
        for (File fileEntry : list) {
            if (fileEntry.isDirectory()) continue;
            fileList.add(fileEntry);
        }
        return fileList;
    }

    static List<File> getFilesFromDirectoryWildcard(AbstractBuild build, BuildListener listener, String basePath, String path) throws IOException, InterruptedException {
        return FileHelper.getFilesFromDirectoryWildcard(build, listener, basePath, path, false);
    }

    static List<File> getFilesFromDirectoryWildcard(AbstractBuild build, BuildListener listener, String basePath, String path, boolean fullPath) throws IOException, InterruptedException {
        String[] files;
        PrintStream logger = listener.getLogger();
        String[] splitResult = FileHelper.splitPath(path);
        ArrayList<File> result = new ArrayList<File>();
        DirectoryScanner scanner = new DirectoryScanner();
        if (Computer.currentComputer() instanceof SlaveComputer) {
            File targetBuildDirectory = new File(build.getRootDir(), "cucumber-html-reports");
            logger.println("Detected this build is running on a slave ");
            FilePath projectWorkspaceOnSlave = build.getProject().getSomeWorkspace();
            if (projectWorkspaceOnSlave != null) {
                FilePath masterJsonReportDirectory = new FilePath(targetBuildDirectory);
                logger.println("Copying files from: " + projectWorkspaceOnSlave.toURI() + "to reports directory: " + masterJsonReportDirectory.toURI());
                projectWorkspaceOnSlave.copyRecursiveTo("**", "", masterJsonReportDirectory);
                scanner.setBasedir(masterJsonReportDirectory.getRemote());
                basePath = masterJsonReportDirectory.getRemote();
            }
        } else {
            scanner.setBasedir(basePath);
        }
        scanner.setIncludes(splitResult);
        scanner.setCaseSensitive(false);
        scanner.scan();
        for (String str : files = scanner.getIncludedFiles()) {
            if (fullPath) {
                result.add(new File(FileHelper.buildPath(basePath, "/", str)));
                continue;
            }
            result.add(new File(str));
        }
        if (result.isEmpty()) {
            throw new InterruptedException("Upload result:  No files were found in path \"" + basePath + File.separator + path + "\".");
        }
        return result;
    }

    public static boolean isTopLevelDirSame(List<File> files) {
        String buffer = "";
        boolean sameRoot = false;
        for (File f : files) {
            String[] newFilePathCut = FileHelper.splitFileSystemPath(f.getPath());
            if (buffer.isEmpty()) {
                sameRoot = true;
                buffer = newFilePathCut[0];
                continue;
            }
            if (buffer.equals(newFilePathCut[0])) continue;
            sameRoot = false;
        }
        return sameRoot;
    }
}

