/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.Configuration;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ElectricFlowUploadArtifactPublisher
extends Publisher {
    private static final Log log = LogFactory.getLog(ElectricFlowUploadArtifactPublisher.class);
    private final String configuration;
    private final String repositoryName;
    private String artifactName;
    private String artifactVersion;
    private String filePath;

    @DataBoundConstructor
    public ElectricFlowUploadArtifactPublisher(String repositoryName, String artifactName, String artifactVersion, String filePath, String configuration) {
        this.repositoryName = repositoryName;
        this.artifactName = artifactName;
        this.artifactVersion = artifactVersion;
        this.filePath = filePath;
        this.configuration = configuration;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        try {
            ElectricFlowClient efClient;
            String result;
            FilePath workspace;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Publishing artifact...");
            }
            if ((workspace = build.getWorkspace()) == null) {
                logger.println("WARNING: Workspace should not be null.");
                log.warn((Object)"Workspace should not be null");
                return false;
            }
            String workspaceDir = workspace.getRemote();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Workspace directory: " + workspaceDir));
            }
            EnvReplacer env = new EnvReplacer((Run)build, (TaskListener)listener);
            String newFilePath = env.expandEnv(this.filePath);
            String newArtifactVersion = env.expandEnv(this.artifactVersion);
            String newArtifactName = env.expandEnv(this.artifactName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Workspace directory: " + newFilePath));
            }
            if (!"Artifact-Published-OK".equals(result = (efClient = new ElectricFlowClient(this.configuration, workspaceDir)).uploadArtifact(build, listener, this.repositoryName, newArtifactName, newArtifactVersion, newFilePath, true))) {
                logger.println("Upload result: " + result);
                return false;
            }
            String summaryHtml = this.getSummaryHtml(newArtifactVersion, newArtifactName, efClient);
            SummaryTextAction action = new SummaryTextAction((Run<?, ?>)build, summaryHtml);
            build.addAction((Action)action);
            build.save();
            logger.println("Upload result: " + result);
        }
        catch (IOException | InterruptedException | KeyManagementException | NoSuchAlgorithmException e) {
            logger.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getSummaryHtml(String newArtifactVersion, String newArtifactName, ElectricFlowClient efClient) throws UnsupportedEncodingException {
        String url = efClient.getElectricFlowUrl() + "/commander/link/artifactVersionDetails/artifactVersions/" + Utils.encodeURL(newArtifactName + ":" + newArtifactVersion) + "?s=Artifacts&ss=Artifacts";
        String repository = this.repositoryName.isEmpty() ? "default" : this.repositoryName;
        return "<h3>ElectricFlow Publish Artifact</h3><table cellspacing=\"2\" cellpadding=\"4\">\n  <tr>\n    <td>Artifact URL:</td>\n    <td><a href ='" + url + "'>" + url + "</a></td> \n  </tr>\n  <tr>\n    <td>Artifact Name:</td>\n    <td><a href ='" + url + "'>" + this.artifactName + "</a></td> \n  </tr>\n  <tr>\n    <td>Artifact Version:</td>\n    <td>" + newArtifactVersion + "</td> \n  </tr>\n  <tr>\n    <td>Repository Name:</td>\n    <td>" + repository + "</td> \n  </tr>\n</table>";
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final Log log = LogFactory.getLog(DescriptorImpl.class);
        private String electricFlowUrl;
        private String electricFlowUser;
        private String electricFlowPassword;

        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.electricFlowUrl = formData.getString("electricFlowUrl");
            this.electricFlowUser = formData.getString("electricFlowUser");
            this.electricFlowPassword = formData.getString("electricFlowPassword");
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckArtifactName(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "Artifact name");
        }

        public FormValidation doCheckArtifactVersion(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "Artifact version");
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "Configuration");
        }

        public FormValidation doCheckFilePath(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "File path");
        }

        public FormValidation doCheckRepositoryName(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "Repository name");
        }

        public ListBoxModel doFillConfigurationItems() {
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillRepositoryNameItems(@QueryParameter String configuration) {
            ListBoxModel m = new ListBoxModel();
            m.add("Select repository", "");
            if (configuration.isEmpty()) {
                return m;
            }
            try {
                ElectricFlowClient efClient = new ElectricFlowClient(configuration);
                List<String> repositories = efClient.getArtifactRepositories();
                for (String repo : repositories) {
                    m.add(repo, repo);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Error retrieving repository list: " + e.getMessage()), (Throwable)e);
                return m;
            }
            return m;
        }

        public Configuration getConfigurationByName(String name) {
            return Utils.getConfigurationByName(name);
        }

        public String getDisplayName() {
            return "ElectricFlow - Publish Artifact";
        }

        public String getElectricFlowPassword() {
            return this.electricFlowPassword;
        }

        public String getElectricFlowUrl() {
            return this.electricFlowUrl;
        }

        public String getElectricFlowUser() {
            return this.electricFlowUser;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }
}

