/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.Release;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.ui.FieldValidationStatus;
import org.jenkinsci.plugins.electricflow.ui.SelectFieldUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectItemValidationWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElectricFlowTriggerRelease
extends Recorder
implements SimpleBuildStep {
    private static final Log log = LogFactory.getLog(ElectricFlowTriggerRelease.class);
    private String configuration;
    private String projectName;
    private String releaseName;
    private String startingStage;
    private String parameters;

    @DataBoundConstructor
    public ElectricFlowTriggerRelease() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        JSONObject release = JSONObject.fromObject((Object)this.parameters).getJSONObject("release");
        JSONArray stages = JSONArray.fromObject((Object)release.getString("stages"));
        JSONArray pipelineParameters = JSONArray.fromObject((Object)release.getString("parameters"));
        ArrayList<String> stagesToRun = new ArrayList<String>();
        if (this.startingStage.isEmpty()) {
            for (int i = 0; i < stages.size(); ++i) {
                JSONObject stage = stages.getJSONObject(i);
                if (!stage.getBoolean("stageValue")) continue;
                stagesToRun.add(stage.getString("stageName"));
            }
        }
        PrintStream logger = taskListener.getLogger();
        try {
            logger.println("Preparing to triggerRelease...");
            EnvReplacer env = new EnvReplacer(run, taskListener);
            ElectricFlowClient efClient = new ElectricFlowClient(this.configuration, env);
            Utils.expandParameters(pipelineParameters, env);
            String releaseResult = efClient.runRelease(this.projectName, this.releaseName, stagesToRun, this.startingStage, pipelineParameters);
            String summaryHtml = this.getSummaryHtml(efClient, releaseResult, pipelineParameters, stagesToRun);
            SummaryTextAction action = new SummaryTextAction(run, summaryHtml);
            run.addAction((Action)action);
            run.save();
            logger.println("TriggerRelease  result: " + Utils.formatJsonOutput(releaseResult));
        }
        catch (Exception e) {
            logger.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getStoredConfiguration() {
        return this.configuration;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getStoredParameters() {
        return this.parameters;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getStoredProjectName() {
        return this.projectName;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public String getStoredReleaseName() {
        return this.releaseName;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getStartingStage() {
        return this.startingStage;
    }

    public String getStoredStartingStage() {
        return this.startingStage;
    }

    public boolean getValidationTrigger() {
        return true;
    }

    private String getSummaryHtml(ElectricFlowClient efClient, String releaseResult, JSONArray parameters, List<String> stagesToRun) {
        JSONObject flowRuntime = JSONObject.fromObject((Object)releaseResult).getJSONObject("flowRuntime");
        String pipelineId = flowRuntime.getString("pipelineId");
        String flowRuntimeId = flowRuntime.getString("flowRuntimeId");
        String pipelineName = flowRuntime.getString("pipelineName");
        String urlPipeline = efClient.getElectricFlowUrl() + "/flow/#pipeline-run/" + pipelineId + "/" + flowRuntimeId;
        String urlRelease = efClient.getElectricFlowUrl() + "/flow/#releases";
        String summaryText = "<h3>ElectricFlow Trigger Release</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td>Release Name:</td>\n    <td><a href='" + urlRelease + "'>" + this.releaseName + "</a></td>   \n  </tr>\n  <tr>\n    <td>Pipeline URL:</td>\n    <td><a href='" + urlPipeline + "'>" + urlPipeline + "</a></td>   \n  </tr>\n  <tr>\n    <td>Pipeline Name:</td>\n    <td><a href='" + urlPipeline + "'>" + pipelineName + "</a></td>   \n  </tr>\n  <tr>\n    <td>Project Name:</td>\n    <td>" + this.projectName + "</td>    \n  </tr>";
        if (!this.startingStage.isEmpty()) {
            summaryText = summaryText + "  <tr>\n    <td>Starting stage:</td>\n    <td>" + this.startingStage + "</td>    \n  </tr>";
        }
        if (!stagesToRun.isEmpty()) {
            summaryText = Utils.getParametersHTML(stagesToRun, summaryText);
        }
        summaryText = Utils.getParametersHTML(parameters, summaryText, "parameterName", "parameterValue");
        summaryText = summaryText + "</table>";
        return summaryText;
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @DataBoundSetter
    public void setParameters(String parameters) {
        this.parameters = SelectFieldUtils.getSelectItemValue(parameters);
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = SelectFieldUtils.getSelectItemValue(projectName);
    }

    @DataBoundSetter
    public void setReleaseName(String releaseName) {
        this.releaseName = SelectFieldUtils.getSelectItemValue(releaseName);
    }

    @DataBoundSetter
    public void setStartingStage(String startingStage) {
        this.startingStage = SelectFieldUtils.getSelectItemValue(startingStage);
    }

    @DataBoundSetter
    public void setValidationTrigger(String validationTrigger) {
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @QueryParameter boolean validationTrigger) {
            return Utils.validateConfiguration(value);
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter boolean validationTrigger) {
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Project name");
        }

        public FormValidation doCheckReleaseName(@QueryParameter String value, @QueryParameter boolean validationTrigger) {
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Release name");
        }

        public FormValidation doCheckStartingStage(@QueryParameter String value, @QueryParameter boolean validationTrigger) {
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckParameters(@QueryParameter String value, @QueryParameter boolean validationTrigger) {
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillConfigurationItems() {
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillParametersItems(@QueryParameter String configuration, @QueryParameter String projectName, @QueryParameter String releaseName, @QueryParameter String parameters) {
            try {
                JSONObject json;
                JSONObject jsonArray;
                ListBoxModel m = new ListBoxModel();
                if (projectName.isEmpty() || releaseName.isEmpty() || configuration.isEmpty() || SelectFieldUtils.checkAnySelectItemsIsValidationWrappers(projectName, releaseName)) {
                    m.add("{}");
                    return m;
                }
                HashMap<String, String> storedStagesToRun = new HashMap();
                HashMap<String, String> storedPipelineParams = new HashMap();
                String parametersValue = SelectFieldUtils.getSelectItemValue(parameters);
                if (!parametersValue.isEmpty() && !"{}".equals(parametersValue) && releaseName.equals((jsonArray = (json = JSONObject.fromObject((Object)parametersValue)).getJSONObject("release")).getString("releaseName"))) {
                    storedStagesToRun = DescriptorImpl.getStagesToRunMapFromParams(parametersValue);
                    storedPipelineParams = DescriptorImpl.getPipelineParamsMapFromParams(parametersValue);
                }
                if (!configuration.isEmpty() && !releaseName.isEmpty()) {
                    ElectricFlowClient client = new ElectricFlowClient(configuration);
                    Release release = client.getRelease(configuration, projectName, releaseName);
                    List<String> stages = release.getStartStages();
                    List<String> pipelineParameters = release.getPipelineParameters();
                    JSONObject main = JSONObject.fromObject((Object)("{'release':{'releaseName':'" + releaseName + "','stages':[], pipelineName:'" + release.getPipelineName() + "', 'parameters':[]}}"));
                    JSONArray stagesArray = main.getJSONObject("release").getJSONArray("stages");
                    Utils.addParametersToJsonAndPreserveStored(stages, stagesArray, "stageName", "stageValue", storedStagesToRun);
                    JSONArray parametersArray = main.getJSONObject("release").getJSONArray("parameters");
                    Utils.addParametersToJsonAndPreserveStored(pipelineParameters, parametersArray, "parameterName", "parameterValue", storedPipelineParams);
                    m.add(main.toString());
                }
                if (m.isEmpty()) {
                    m.add("{}");
                }
                return m;
            }
            catch (Exception e) {
                SelectItemValidationWrapper selectItemValidationWrapper;
                ListBoxModel m = new ListBoxModel();
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching set of parameters. Error message: " + e.getMessage()), (Throwable)e);
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of parameters. Check the Jenkins logs for more details.", "{}");
                } else {
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of deploy parameters. Connection to Electric Flow Server Failed. Please fix connection information and reload this page.", "{}");
                }
                m.add(selectItemValidationWrapper.getJsonStr());
                return m;
            }
        }

        public ListBoxModel doFillProjectNameItems(@QueryParameter String configuration) {
            return Utils.getProjects(configuration);
        }

        public ListBoxModel doFillReleaseNameItems(@QueryParameter String projectName, @QueryParameter String configuration) {
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select release", "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName)) {
                    ElectricFlowClient client = new ElectricFlowClient(configuration);
                    List<String> releasesList = client.getReleases(configuration, projectName);
                    for (String release : releasesList) {
                        m.add(release);
                    }
                }
                return m;
            }
            catch (Exception e) {
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching values for this parameter - release. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select release");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select release");
            }
        }

        public ListBoxModel doFillStartingStageItems(@QueryParameter String configuration, @QueryParameter String projectName, @QueryParameter String releaseName) throws Exception {
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select starting stage", "");
                if (projectName.isEmpty() || releaseName.isEmpty() || configuration.isEmpty() || SelectFieldUtils.checkAnySelectItemsIsValidationWrappers(projectName, releaseName)) {
                    return m;
                }
                ElectricFlowClient client = new ElectricFlowClient(configuration);
                Release release = client.getRelease(configuration, projectName, releaseName);
                if (release == null) {
                    return m;
                }
                List<String> startStages = release.getStartStages();
                for (String state : startStages) {
                    m.add(state);
                }
                return m;
            }
            catch (Exception e) {
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching values for this parameter - starting stage. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select starting stage");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select starting stage");
            }
        }

        public String getDisplayName() {
            return "ElectricFlow - Trigger Release";
        }

        public String getId() {
            return "electricFlowTriggerRelease";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doShowOldValues(@QueryParameter(value="configuration") String configuration, @QueryParameter(value="projectName") String projectName, @QueryParameter(value="releaseName") String releaseName, @QueryParameter(value="startingStage") String startingStage, @QueryParameter(value="parameters") String parameters, @QueryParameter(value="storedConfiguration") String storedConfiguration, @QueryParameter(value="storedProjectName") String storedProjectName, @QueryParameter(value="storedReleaseName") String storedReleaseName, @QueryParameter(value="storedStartingStage") String storedStartingStage, @QueryParameter(value="storedParameters") String storedParameters) {
            String configurationValue = configuration;
            String projectNameValue = SelectFieldUtils.getSelectItemValue(projectName);
            String releaseNameValue = SelectFieldUtils.getSelectItemValue(releaseName);
            String startingStageValue = SelectFieldUtils.getSelectItemValue(startingStage);
            String parametersValue = SelectFieldUtils.getSelectItemValue(parameters);
            Map<String, String> stagesToRunMap = DescriptorImpl.getStagesToRunMapFromParams(parametersValue);
            Map<String, String> storedStagesToRunMap = DescriptorImpl.getStagesToRunMapFromParams(storedParameters);
            Map<String, String> pipelineParamsMap = DescriptorImpl.getPipelineParamsMapFromParams(parametersValue);
            Map<String, String> storedPipelineParamsMap = DescriptorImpl.getPipelineParamsMapFromParams(storedParameters);
            String comparisonTable = "<table>" + Utils.getValidationComparisonHeaderRow() + Utils.getValidationComparisonRow("Configuration", storedConfiguration, configurationValue) + Utils.getValidationComparisonRow("Project Name", storedProjectName, projectNameValue) + Utils.getValidationComparisonRow("Release Name", storedReleaseName, releaseNameValue) + Utils.getValidationComparisonRow("Starting Stage", storedStartingStage, startingStageValue) + Utils.getValidationComparisonRowsForExtraParameters("Stages to run", storedStagesToRunMap, stagesToRunMap) + Utils.getValidationComparisonRowsForExtraParameters("Pipeline parameters", storedPipelineParamsMap, pipelineParamsMap) + "</table>";
            if (configurationValue.equals(storedConfiguration) && projectNameValue.equals(storedProjectName) && releaseNameValue.equals(storedReleaseName) && startingStageValue.equals(storedStartingStage) && pipelineParamsMap.equals(storedPipelineParamsMap)) {
                return FormValidation.okWithMarkup((String)("No changes detected:<br>" + comparisonTable));
            }
            return FormValidation.warningWithMarkup((String)("Changes detected:<br>" + comparisonTable));
        }

        static Map<String, String> getStagesToRunMapFromParams(String deployParameters) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (deployParameters == null || deployParameters.isEmpty() || deployParameters.equals("{}")) {
                return paramsMap;
            }
            JSONObject json = JSONObject.fromObject((Object)deployParameters);
            if (!json.containsKey((Object)"release") || !json.getJSONObject("release").containsKey((Object)"stages")) {
                return paramsMap;
            }
            return Utils.getParamsMap(JSONArray.fromObject((Object)json.getJSONObject("release").getString("stages")), "stageName", "stageValue");
        }

        static Map<String, String> getPipelineParamsMapFromParams(String deployParameters) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (deployParameters == null || deployParameters.isEmpty() || deployParameters.equals("{}")) {
                return paramsMap;
            }
            JSONObject json = JSONObject.fromObject((Object)deployParameters);
            if (!json.containsKey((Object)"release") || !json.getJSONObject("release").containsKey((Object)"parameters")) {
                return paramsMap;
            }
            return Utils.getParamsMap(JSONArray.fromObject((Object)json.getJSONObject("release").getString("parameters")), "parameterName", "parameterValue");
        }
    }
}

