/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.Configuration;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.ui.FieldValidationStatus;
import org.jenkinsci.plugins.electricflow.ui.SelectFieldUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectItemValidationWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ElectricFlowPipelinePublisher
extends Recorder
implements SimpleBuildStep {
    private static final Log log = LogFactory.getLog(ElectricFlowPipelinePublisher.class);
    private String projectName;
    private String pipelineName;
    private String configuration;
    private String addParam;
    private JSONArray additionalOption;

    @DataBoundConstructor
    public ElectricFlowPipelinePublisher() {
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        return this.runPipeline((Run)build, listener, null);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        boolean result = this.runPipeline(run, null, taskListener);
        if (!result) {
            run.setResult(Result.FAILURE);
        }
    }

    private void logListener(BuildListener buildListener, TaskListener taskListener, String log) {
        if (buildListener != null) {
            buildListener.getLogger().println(log);
        } else if (taskListener != null) {
            taskListener.getLogger().println(log);
        }
    }

    private boolean runPipeline(Run run, BuildListener buildListener, TaskListener taskListener) {
        this.logListener(buildListener, taskListener, "Project name: " + this.projectName + ", Pipeline name: " + this.pipelineName);
        ElectricFlowClient efClient = new ElectricFlowClient(this.configuration);
        try {
            List<String> paramsResponse = efClient.getPipelineFormalParameters(this.pipelineName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("FormalParameters are: " + paramsResponse.toString()));
            }
        }
        catch (Exception e) {
            taskListener.getLogger().println("Error occurred during formal parameters fetch: " + e.getMessage());
            log.error((Object)("Error occurred during formal parameters fetch: " + e.getMessage()), (Throwable)e);
            return false;
        }
        try {
            String pipelineResult;
            this.logListener(buildListener, taskListener, "Preparing to run pipeline...");
            JSONArray parameters = this.getPipelineParameters();
            if (parameters.isEmpty()) {
                pipelineResult = efClient.runPipeline(this.projectName, this.pipelineName);
            } else {
                EnvReplacer env = new EnvReplacer(run, taskListener);
                Utils.expandParameters(parameters, env);
                pipelineResult = efClient.runPipeline(this.projectName, this.pipelineName, parameters);
            }
            String summaryHtml = this.getSummaryHtml(efClient, pipelineResult, parameters);
            SummaryTextAction action = new SummaryTextAction(run, summaryHtml);
            run.addAction((Action)action);
            run.save();
            this.logListener(buildListener, taskListener, "Pipeline result: " + Utils.formatJsonOutput(pipelineResult));
        }
        catch (Exception e) {
            this.logListener(buildListener, taskListener, e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public JSONArray getAdditionalOption() {
        return this.additionalOption;
    }

    public String getAddParam() {
        return this.addParam;
    }

    public String getStoredAddParam() {
        return this.addParam;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getStoredConfiguration() {
        return this.configuration;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public String getStoredPipelineName() {
        return this.pipelineName;
    }

    private JSONArray getPipelineParameters() {
        JSONObject pipelineJsonObject;
        JSONArray pipelineParameters;
        if (this.addParam != null && !(pipelineParameters = JSONArray.fromObject((Object)(pipelineJsonObject = JSONObject.fromObject((Object)this.addParam).getJSONObject("pipeline")).getString("parameters"))).isEmpty()) {
            return pipelineParameters;
        }
        return new JSONArray();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getStoredProjectName() {
        return this.projectName;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getSummaryHtml(ElectricFlowClient efClient, String pipelineResult, JSONArray parameters) {
        JSONObject flowRuntime = JSONObject.fromObject((Object)pipelineResult).getJSONObject("flowRuntime");
        String pipelineId = (String)flowRuntime.get("pipelineId");
        String flowRuntimeId = (String)flowRuntime.get("flowRuntimeId");
        String url = efClient.getElectricFlowUrl() + "/flow/#pipeline-run/" + pipelineId + "/" + flowRuntimeId;
        String summaryText = "<h3>ElectricFlow Run Pipeline</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td>Pipeline URL:</td>\n    <td><a href='" + url + "'>" + url + "</a></td>   \n  </tr>\n  <tr>\n    <td>Pipeline Name:</td>\n    <td><a href='" + url + "'>" + this.pipelineName + "</a></td>   \n  </tr>\n  <tr>\n    <td>Project Name:</td>\n    <td>" + this.projectName + "</td>    \n  </tr>";
        summaryText = Utils.getParametersHTML(parameters, summaryText, "parameterName", "parameterValue");
        summaryText = summaryText + "</table>";
        return summaryText;
    }

    @DataBoundSetter
    public void setAdditionalOption(JSONArray additionalOption) {
        this.additionalOption = additionalOption;
    }

    @DataBoundSetter
    public void setAddParam(String addParam) {
        this.addParam = SelectFieldUtils.getSelectItemValue(addParam);
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @DataBoundSetter
    public void setPipelineName(String pipelineName) {
        this.pipelineName = SelectFieldUtils.getSelectItemValue(pipelineName);
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = SelectFieldUtils.getSelectItemValue(projectName);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @QueryParameter boolean validationTrigger) {
            return Utils.validateConfiguration(value);
        }

        public FormValidation doCheckPipelineName(@QueryParameter String value, @QueryParameter boolean validationTrigger) {
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Pipeline name");
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter boolean validationTrigger) {
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Project name");
        }

        public FormValidation doCheckAddParam(@QueryParameter String value, @QueryParameter boolean validationTrigger) {
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillAddParamItems(@QueryParameter String configuration, @QueryParameter String pipelineName, @QueryParameter String addParam) {
            try {
                JSONObject json;
                JSONObject jsonArray;
                ListBoxModel m = new ListBoxModel();
                if (configuration.isEmpty() || pipelineName.isEmpty() || SelectFieldUtils.checkAnySelectItemsIsValidationWrappers(pipelineName)) {
                    m.add("{}");
                    return m;
                }
                HashMap<String, String> storedParams = new HashMap();
                String addParamValue = SelectFieldUtils.getSelectItemValue(addParam);
                if (!addParamValue.isEmpty() && !"{}".equals(addParamValue) && pipelineName.equals((jsonArray = (json = JSONObject.fromObject((Object)addParamValue)).getJSONObject("pipeline")).get("pipelineName"))) {
                    storedParams = DescriptorImpl.getParamsMapFromAddParam(addParamValue);
                }
                ElectricFlowClient efClient = new ElectricFlowClient(configuration);
                List<String> parameters = efClient.getPipelineFormalParameters(pipelineName);
                JSONObject main = JSONObject.fromObject((Object)("{'pipeline':{'pipelineName':'" + pipelineName + "','parameters':[]}}"));
                JSONArray ja = main.getJSONObject("pipeline").getJSONArray("parameters");
                Utils.addParametersToJsonAndPreserveStored(parameters, ja, "parameterName", "parameterValue", storedParams);
                m.add(main.toString());
                if (m.isEmpty()) {
                    m.add("{}");
                }
                return m;
            }
            catch (Exception e) {
                SelectItemValidationWrapper selectItemValidationWrapper;
                ListBoxModel m = new ListBoxModel();
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching set of pipeline parameters. Error message: " + e.getMessage()), (Throwable)e);
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of pipeline parameters. Check the Jenkins logs for more details.", "{}");
                } else {
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of pipeline parameters. Connection to Electric Flow Server Failed. Please fix connection information and reload this page.", "{}");
                }
                m.add(selectItemValidationWrapper.getJsonStr());
                return m;
            }
        }

        public ListBoxModel doFillConfigurationItems() {
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillPipelineNameItems(@QueryParameter String projectName, @QueryParameter String configuration) {
            return Utils.getPipelines(configuration, projectName);
        }

        public ListBoxModel doFillProjectNameItems(@QueryParameter String configuration) {
            return Utils.getProjects(configuration);
        }

        public void doHelp(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            super.doHelp(req, rsp);
        }

        public FormValidation doTestConnection() {
            return FormValidation.ok((String)"Success");
        }

        public Configuration getConfigurationByName(String name) {
            return Utils.getConfigurationByName(name);
        }

        public List<Configuration> getConfigurations() {
            return Utils.getConfigurations();
        }

        public String getDisplayName() {
            return "ElectricFlow - Run Pipeline";
        }

        public String getId() {
            return "electricFlowSettings";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doShowOldValues(@QueryParameter(value="configuration") String configuration, @QueryParameter(value="projectName") String projectName, @QueryParameter(value="pipelineName") String pipelineName, @QueryParameter(value="addParam") String addParam, @QueryParameter(value="storedConfiguration") String storedConfiguration, @QueryParameter(value="storedProjectName") String storedProjectName, @QueryParameter(value="storedPipelineName") String storedPipelineName, @QueryParameter(value="storedAddParam") String storedAddParam) {
            String configurationValue = configuration;
            String projectNameValue = SelectFieldUtils.getSelectItemValue(projectName);
            String pipelineNameValue = SelectFieldUtils.getSelectItemValue(pipelineName);
            String addParamValue = SelectFieldUtils.getSelectItemValue(addParam);
            Map<String, String> pipelineParamsMap = DescriptorImpl.getParamsMapFromAddParam(addParamValue);
            Map<String, String> storedPipelineParamsMap = DescriptorImpl.getParamsMapFromAddParam(storedAddParam);
            String comparisonTable = "<table>" + Utils.getValidationComparisonHeaderRow() + Utils.getValidationComparisonRow("Configuration", storedConfiguration, configurationValue) + Utils.getValidationComparisonRow("Project Name", storedProjectName, projectNameValue) + Utils.getValidationComparisonRow("Pipeline Name", storedPipelineName, pipelineNameValue) + Utils.getValidationComparisonRowsForExtraParameters("Pipeline Parameters", storedPipelineParamsMap, pipelineParamsMap) + "</table>";
            if (configurationValue.equals(storedConfiguration) && projectNameValue.equals(storedProjectName) && pipelineNameValue.equals(storedPipelineName) && pipelineParamsMap.equals(storedPipelineParamsMap)) {
                return FormValidation.okWithMarkup((String)("No changes detected:<br>" + comparisonTable));
            }
            return FormValidation.warningWithMarkup((String)("Changes detected:<br>" + comparisonTable));
        }

        static Map<String, String> getParamsMapFromAddParam(String addParam) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (addParam == null || addParam.isEmpty() || addParam.equals("{}")) {
                return paramsMap;
            }
            JSONObject json = JSONObject.fromObject((Object)addParam);
            if (!json.containsKey((Object)"pipeline") || !json.getJSONObject("pipeline").containsKey((Object)"parameters")) {
                return paramsMap;
            }
            return Utils.getParamsMap(JSONArray.fromObject((Object)json.getJSONObject("pipeline").getString("parameters")), "parameterName", "parameterValue");
        }
    }
}

