/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Configuration
extends AbstractDescribableImpl<Configuration> {
    private static final Log log = LogFactory.getLog(Configuration.class);
    private final String configurationName;
    private final String electricFlowUser;
    private final String electricFlowPassword;
    private final String electricFlowUrl;
    private final String electricFlowApiVersion;
    private final boolean ignoreSslConnectionErrors;

    @DataBoundConstructor
    public Configuration(String configurationName, String electricFlowUrl, String electricFlowUser, String electricFlowPassword, String electricFlowApiVersion, boolean ignoreSslConnectionErrors) {
        this.configurationName = configurationName;
        this.electricFlowUrl = electricFlowUrl;
        this.electricFlowUser = electricFlowUser;
        if (!electricFlowPassword.equals(this.getElectricFlowPassword())) {
            Secret secret = Secret.fromString((String)electricFlowPassword);
            this.electricFlowPassword = secret.getEncryptedValue();
        } else {
            this.electricFlowPassword = electricFlowPassword;
        }
        this.electricFlowApiVersion = electricFlowApiVersion;
        this.ignoreSslConnectionErrors = ignoreSslConnectionErrors;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getElectricFlowApiVersion() {
        return this.electricFlowApiVersion;
    }

    public boolean getIgnoreSslConnectionErrors() {
        return this.ignoreSslConnectionErrors;
    }

    public String getElectricFlowPassword() {
        return this.electricFlowPassword;
    }

    public String getElectricFlowUrl() {
        return this.electricFlowUrl;
    }

    public String getElectricFlowUser() {
        return this.electricFlowUser;
    }

    @Extension
    public static final class ConfigurationDescriptor
    extends Descriptor<Configuration> {
        public FormValidation doCheckConfigurationName(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "Configuration name");
        }

        public FormValidation doCheckElectricFlowApiVersion(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "ElectricFlow api version");
        }

        public FormValidation doCheckElectricFlowPassword(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "ElectricFlow password");
        }

        public FormValidation doCheckElectricFlowUrl(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "ElectricFlow Url");
        }

        public FormValidation doCheckElectricFlowUser(@QueryParameter String value) {
            return Utils.validateValueOnEmpty(value, "ElectricFlow user");
        }

        public ListBoxModel doFillElectricFlowApiVersionItems() {
            ListBoxModel m = new ListBoxModel();
            m.add("Select api version", "");
            m.add("v1.0", "/rest/v1.0");
            return m;
        }

        public FormValidation doTestConnection(@QueryParameter(value="electricFlowUrl") String electricFlowUrl, @QueryParameter(value="electricFlowUser") String electricFlowUser, @QueryParameter(value="electricFlowPassword") String electricFlowPassword, @QueryParameter(value="electricFlowApiVersion") String electricFlowApiVersion, @QueryParameter(value="ignoreSslConnectionErrors") boolean ignoreSslConnectionErrors) throws IOException {
            if (electricFlowUrl.isEmpty() || electricFlowUser.isEmpty() || electricFlowPassword.isEmpty() || electricFlowApiVersion.isEmpty()) {
                return FormValidation.error((String)"Please fill required fields");
            }
            try {
                String decryptedPassword = Secret.fromString((String)electricFlowPassword).getPlainText();
                ElectricFlowClient efClient = new ElectricFlowClient(electricFlowUrl, electricFlowUser, decryptedPassword, electricFlowApiVersion, ignoreSslConnectionErrors);
                efClient.testConnection();
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                log.warn((Object)"Wrong configuration - connection to Electric Flow server failed", (Throwable)e);
                return FormValidation.error((String)("Wrong configuration - connection to Electric Flow server failed. Error message: " + e.getMessage()));
            }
        }

        public String getDisplayName() {
            return "Configuration";
        }
    }
}

