/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.rest;

import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.StringParameterValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.electricflow.causes.EFCause;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class ElectricFlowEFRunAPIAction<T extends Job<?, ?>>
implements Action {
    private static final String URL_NAME = "efrun";
    private final T project;

    public ElectricFlowEFRunAPIAction(T project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    @POST
    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        rsp.setStatus(201);
        String responseString = "Hello World";
        byte[] responseBytes = responseString.getBytes("UTF-8");
        rsp.setContentLength(responseBytes.length);
        ServletOutputStream out = rsp.getOutputStream();
        out.write(responseBytes);
        out.flush();
    }

    @POST
    public void doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String strCurrentLine;
        rsp.setStatus(201);
        BufferedReader br = req.getReader();
        StringBuilder sb = new StringBuilder();
        while ((strCurrentLine = br.readLine()) != null) {
            sb.append(strCurrentLine);
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)sb.toString());
        String flowRuntimeId = "";
        String projectName = "";
        String releaseName = "";
        String flowRuntimeStateId = "";
        String stageName = "";
        boolean hasBuildParams = false;
        JSONObject buildParams = new JSONObject();
        ArrayList<StringParameterValue> parameterValues = new ArrayList<StringParameterValue>();
        try {
            flowRuntimeId = jsonObject.getString("flowRuntimeId");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            projectName = jsonObject.getString("projectName");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            releaseName = jsonObject.getString("releaseName");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            flowRuntimeStateId = jsonObject.getString("flowRuntimeStateId");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            stageName = jsonObject.getString("stageName");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            buildParams = jsonObject.getJSONObject("buildParams");
            if (buildParams.keySet().size() > 0) {
                hasBuildParams = true;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JSONObject responseObject = new JSONObject();
        EFCause efcause = new EFCause();
        Cause.UserIdCause userIdCause = new Cause.UserIdCause();
        if (flowRuntimeId != null) {
            efcause.setFlowRuntimeId(flowRuntimeId);
        }
        if (projectName != null) {
            efcause.setProjectName(projectName);
        }
        if (releaseName != null) {
            efcause.setReleaseName(releaseName);
        }
        if (flowRuntimeStateId != null) {
            efcause.setFlowRuntimeStateId(flowRuntimeStateId);
        }
        if (stageName != null) {
            efcause.setStageName(stageName);
        }
        CauseAction ca = new CauseAction(new Cause[]{efcause, userIdCause});
        Queue.WaitingItem schedule = null;
        ServletOutputStream out = rsp.getOutputStream();
        if (hasBuildParams) {
            for (ParameterDefinition parameterDefinition : this.getParameterDefinitions()) {
                String parameterName = parameterDefinition.getName();
                try {
                    String formValue = buildParams.getString(parameterName);
                    StringParameterValue spv = new StringParameterValue(parameterName, formValue);
                    parameterValues.add(spv);
                }
                catch (JSONException jSONException) {}
            }
            schedule = Jenkins.get().getQueue().schedule((Queue.Task)this.project, 0, new Action[]{new ParametersAction(parameterValues), ca});
        } else {
            schedule = Jenkins.get().getQueue().schedule((Queue.Task)this.project, 0, new Action[]{ca});
        }
        if (schedule == null) {
            responseObject.put("status", (Object)"fail");
            byte[] responseFailed = responseObject.toString().getBytes("UTF-8");
            rsp.setContentLength(responseFailed.length);
            out.write(responseFailed);
            return;
        }
        responseObject.put("status", (Object)"ok");
        rsp.setHeader("location", "queue/" + Long.toString(schedule.getId()));
        responseObject.put("queueId", (Object)schedule.getId());
        String responseString = responseObject.toString();
        byte[] responseBytes = responseString.getBytes("UTF-8");
        rsp.setContentLength(responseBytes.length);
        out.write(responseBytes);
        out.flush();
    }

    private List<ParameterDefinition> getParameterDefinitions() {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
        if (property != null && property.getParameterDefinitions() != null) {
            return property.getParameterDefinitions();
        }
        return new ArrayList<ParameterDefinition>();
    }
}

