/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.CdPipelineStatus;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.FlowRuntimeResponseData;
import org.jenkinsci.plugins.electricflow.utils.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GetPipelineRuntimeDetailsResponseData
implements FlowRuntimeResponseData {
    @JsonProperty
    private String flowRuntimeId;
    @JsonProperty
    @JsonSerialize(using=JsonUtils.NumericBooleanSerializer.class)
    @JsonDeserialize(using=JsonUtils.NumericBooleanDeserializer.class)
    private Boolean completed;
    @JsonProperty
    private CdPipelineStatus status = CdPipelineStatus.unknown;
    private String content;

    public String getFlowRuntimeId() {
        return this.flowRuntimeId;
    }

    public void setFlowRuntimeId(String flowRuntimeId) {
        this.flowRuntimeId = flowRuntimeId;
    }

    @Override
    public Boolean isCompleted() {
        return this.completed;
    }

    @Override
    public String getRuntimeOutcome() {
        return this.status.toString();
    }

    @Override
    public String getRuntimeStatus() {
        return this.status.toString();
    }

    @Override
    public String getRuntimeId() {
        return this.flowRuntimeId;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public CdPipelineStatus getStatus() {
        return this.status;
    }

    public void setStatus(CdPipelineStatus status) {
        this.status = status;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        if (this.getStatus() == CdPipelineStatus.unknown && this.getContent() != null) {
            try {
                return "CD Pipeline Runtime Details Response (unexpected json): " + Utils.formatJsonOutput(this.getContent());
            }
            catch (IOException e) {
                return "CD Pipeline Runtime Details Response (unexpected content): " + this.getContent();
            }
        }
        return "CD Pipeline Runtime Details Response Data: {flowRuntimeId=" + this.flowRuntimeId + ", completed=" + this.completed + ", status=" + (Object)((Object)this.status) + '}';
    }
}

