/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.models;

import java.util.List;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.electricflow.Credential;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.Pair;

public interface CallRestApiModel {
    public String getConfiguration();

    public Credential getOverrideCredential();

    public String getUrlPath();

    public String getHttpMethod();

    public List<Pair> getParameters();

    default public List<Pair> getParameters(EnvReplacer envReplacer) {
        return this.getParameters().stream().map(it -> new Pair(it.getKey(), envReplacer.expandEnv(it.getValue()))).collect(Collectors.toList());
    }

    public String getBody();

    default public String getEnvVarNameForResult() {
        return "";
    }

    default public boolean isEnvVarNameForResultSet() {
        return this.getEnvVarNameForResult() != null && !this.getEnvVarNameForResult().isEmpty();
    }

    default public String getSummary() {
        return "Configuration: " + this.getConfiguration() + "; URL Path: " + this.getUrlPath() + "; HTTP Method: " + this.getHttpMethod() + "; Parameters: [" + this.getParameters().stream().map(it -> it.getKey() + ": " + it.getValue()).collect(Collectors.joining(";")) + "]; Body: " + this.getBody() + "; " + (this.isEnvVarNameForResultSet() ? "" : "Environment variable name for storing result: " + this.getEnvVarNameForResult());
    }
}

