/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.models;

import net.sf.json.JSONObject;
import org.jenkinsci.plugins.electricflow.data.CloudBeesFlowBuildData;

public class CIBuildDetail {
    private String buildName;
    private String projectName;
    private String releaseName;
    private String flowRuntimeId;
    private String stageName;
    private String flowRuntimeStateId;
    private CloudBeesFlowBuildData buildData;
    private BuildTriggerSource buildTriggerSource = BuildTriggerSource.CI;
    private BuildAssociationType associationType = BuildAssociationType.ATTACHED;

    public CIBuildDetail(CloudBeesFlowBuildData buildData, String projectName) {
        this.setBuildData(buildData);
        this.setBuildName(buildData.getDisplayName());
        this.setProjectName(projectName);
    }

    public JSONObject toJsonObject() {
        this.validate();
        JSONObject jsonObject = new JSONObject();
        if (this.buildName == null) {
            this.setBuildName(this.buildData.getDisplayName());
        }
        jsonObject.put("ciBuildDetailName", (Object)this.getBuildName());
        jsonObject.put("projectName", (Object)this.getProjectName());
        jsonObject.put("buildData", (Object)this.getBuildData().toJsonObject().toString());
        jsonObject.put("buildTriggerSource", (Object)this.getBuildTriggerSource());
        jsonObject.put("ciBuildAssociationType", (Object)this.getAssociationType());
        if (this.flowRuntimeId != null) {
            jsonObject.put("flowRuntimeId", (Object)this.getFlowRuntimeId());
            if (this.getStageName() != null && this.getFlowRuntimeStateId() != null) {
                jsonObject.put("stageName", (Object)this.getStageName());
                jsonObject.put("flowRuntimeStateId", (Object)this.getFlowRuntimeStateId());
            }
        } else if (this.getProjectName() != null && this.getReleaseName() != null) {
            jsonObject.put("releaseName", (Object)this.getReleaseName());
        }
        return jsonObject;
    }

    public void validate() throws RuntimeException {
        boolean hasValuesForPipelineAttach;
        if (this.getBuildData() == null) {
            throw new RuntimeException("Field 'CloudBeesFlowData buildData' is not set up.");
        }
        boolean hasValuesForReleaseAttach = this.getProjectName() != null && this.getReleaseName() != null;
        boolean bl = hasValuesForPipelineAttach = this.getFlowRuntimeId() != null;
        if (hasValuesForPipelineAttach && hasValuesForReleaseAttach) {
            throw new RuntimeException("Only one of 'flowRuntimeId' or 'projectName and releaseName' can be specified.");
        }
        if (!hasValuesForPipelineAttach && !hasValuesForReleaseAttach) {
            throw new RuntimeException("One of 'flowRuntimeId' or 'projectName and releaseName' should be specified.");
        }
    }

    public String getBuildName() {
        return this.buildName;
    }

    public CIBuildDetail setBuildName(String buildName) {
        this.buildName = buildName;
        return this;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public CIBuildDetail setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public CIBuildDetail setReleaseName(String releaseName) {
        this.releaseName = releaseName;
        return this;
    }

    public CloudBeesFlowBuildData getBuildData() {
        return this.buildData;
    }

    public CIBuildDetail setBuildData(CloudBeesFlowBuildData buildData) {
        this.buildData = buildData;
        return this;
    }

    public String getBuildTriggerSource() {
        switch (this.buildTriggerSource) {
            case FLOW: {
                return "CD";
            }
            case CI: {
                return "CI";
            }
        }
        return null;
    }

    public CIBuildDetail setBuildTriggerSource(BuildTriggerSource buildTriggerSource) {
        this.buildTriggerSource = buildTriggerSource;
        return this;
    }

    public String getAssociationType() {
        switch (this.associationType) {
            case ATTACHED: {
                return "attached";
            }
            case TRIGGERED_BY_FLOW: {
                return "triggeredByCD";
            }
            case TRIGGERED_BY_CI: {
                return "triggeredByCI";
            }
        }
        return null;
    }

    public CIBuildDetail setAssociationType(BuildAssociationType associationType) {
        this.associationType = associationType;
        return this;
    }

    public String getFlowRuntimeId() {
        return this.flowRuntimeId;
    }

    public CIBuildDetail setFlowRuntimeId(String flowRuntimeId) {
        this.flowRuntimeId = flowRuntimeId;
        return this;
    }

    public String getStageName() {
        return this.stageName;
    }

    public CIBuildDetail setStageName(String stageName) {
        this.stageName = stageName;
        return this;
    }

    public String getFlowRuntimeStateId() {
        return this.flowRuntimeStateId;
    }

    public CIBuildDetail setFlowRuntimeStateId(String flowRuntimeStateId) {
        this.flowRuntimeStateId = flowRuntimeStateId;
        return this;
    }

    public static enum BuildAssociationType {
        ATTACHED,
        TRIGGERED_BY_FLOW,
        TRIGGERED_BY_CI;

    }

    public static enum BuildTriggerSource {
        CI,
        FLOW;

    }
}

