/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.factories;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.model.Run;
import org.jenkinsci.plugins.electricflow.Configuration;
import org.jenkinsci.plugins.electricflow.Credential;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.Utils;

public class ElectricFlowClientFactory {
    public static ElectricFlowClient getElectricFlowClient(String configurationName, Credential overrideCredential, EnvReplacer envReplacer) {
        return ElectricFlowClientFactory.getElectricFlowClient(configurationName, overrideCredential, envReplacer, false);
    }

    public static ElectricFlowClient getElectricFlowClient(String configurationName, Credential overrideCredential, EnvReplacer envReplacer, boolean ignoreUnresolvedOverrideCredential) {
        return ElectricFlowClientFactory.getElectricFlowClient(configurationName, overrideCredential, null, envReplacer, ignoreUnresolvedOverrideCredential);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ElectricFlowClient getElectricFlowClient(String configurationName, Credential overrideCredential, Run run, EnvReplacer envReplacer, boolean ignoreUnresolvedOverrideCredential) {
        String password;
        String username;
        String apiVersion;
        Configuration cred = Utils.getConfigurationByName(configurationName);
        if (cred == null) {
            throw new RuntimeException("Cannot find CloudBees CD configuration " + configurationName);
        }
        String electricFlowUrl = cred.getElectricFlowUrl();
        boolean ignoreSslConnectionErrors = cred.getIgnoreSslConnectionErrors();
        String electricFlowApiVersion = cred.getElectricFlowApiVersion();
        String string = apiVersion = electricFlowApiVersion != null ? electricFlowApiVersion : "";
        if (overrideCredential == null) {
            username = cred.getElectricFlowUser();
            password = cred.getElectricFlowPassword().getPlainText();
            return new ElectricFlowClient(electricFlowUrl, username, password, apiVersion, ignoreSslConnectionErrors);
        } else {
            StandardUsernamePasswordCredentials creds = overrideCredential.getUsernamePasswordBasedOnCredentialId(envReplacer, run);
            if (creds == null) {
                if (!ignoreUnresolvedOverrideCredential) throw new RuntimeException("Override credentials are not found by provided credential id");
                username = cred.getElectricFlowUser();
                password = cred.getElectricFlowPassword().getPlainText();
                return new ElectricFlowClient(electricFlowUrl, username, password, apiVersion, ignoreSslConnectionErrors);
            } else {
                username = creds.getUsername();
                password = creds.getPassword().getPlainText();
            }
        }
        return new ElectricFlowClient(electricFlowUrl, username, password, apiVersion, ignoreSslConnectionErrors);
    }
}

