/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.causes;

import hudson.model.Cause;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class EFCause
extends Cause {
    @Exported
    public String flowRuntimeId = "";
    @Exported
    public String projectName = "";
    @Exported
    public String releaseName = "";
    @Exported
    public String flowRuntimeStateId = "";
    @Exported
    public String stageName = "";
    final String LAUNCHED_BY_CD_TEXT = "Launched by CloudBees CD";

    public String getFlowRuntimeId() {
        return this.flowRuntimeId;
    }

    public void setFlowRuntimeId(String flowRuntimeId) {
        this.flowRuntimeId = flowRuntimeId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public String getFlowRuntimeStateId() {
        return this.flowRuntimeStateId;
    }

    public void setFlowRuntimeStateId(String flowRuntimeStateId) {
        this.flowRuntimeStateId = flowRuntimeStateId;
    }

    public String getStageName() {
        return this.stageName;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public String getShortDescription() {
        StringBuilder shortDescription = new StringBuilder();
        shortDescription.append("CloudBees CD Triggered this build:");
        String flowRuntimeId = this.getFlowRuntimeId();
        String projectName = this.getProjectName();
        String releaseName = this.getReleaseName();
        String flowRuntimeStateId = this.getFlowRuntimeStateId();
        String stageName = this.getStageName();
        if (!EFCause.isEmptyOrNullString(flowRuntimeId)) {
            shortDescription.append("<br/>");
            shortDescription.append("Flow Runtime ID: ").append(flowRuntimeId);
        }
        if (!EFCause.isEmptyOrNullString(projectName)) {
            shortDescription.append("<br/>");
            shortDescription.append("Project Name: ").append(projectName);
        }
        if (!EFCause.isEmptyOrNullString(releaseName)) {
            shortDescription.append("<br/>");
            shortDescription.append("Release Name: ").append(releaseName);
        }
        if (!EFCause.isEmptyOrNullString(flowRuntimeStateId)) {
            shortDescription.append("<br/>");
            shortDescription.append("Flow Runtime State ID: ").append(flowRuntimeStateId);
        }
        if (!EFCause.isEmptyOrNullString(stageName)) {
            shortDescription.append("<br/>");
            shortDescription.append("Stage Name: ").append(stageName);
        }
        return shortDescription.toString();
    }

    public String getLaunchedByText() {
        return this.LAUNCHED_BY_CD_TEXT;
    }

    private static boolean isEmptyOrNullString(String str) {
        if (str == null) {
            return true;
        }
        return str.equals("");
    }
}

