/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.EnvVars;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.Configuration;
import org.jenkinsci.plugins.electricflow.Credential;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.ElectricFlowGlobalConfiguration;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.factories.ElectricFlowClientFactory;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.CdJobOutcome;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.CdPipelineStatus;
import org.jenkinsci.plugins.electricflow.ui.FieldValidationStatus;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectFieldUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectItemValidationWrapper;

public class Utils {
    public static final String CONFIG_SKIP_CHECK_CONNECTION = "__SKIP_CHECK_CONNECTION__";
    private static final Log log = LogFactory.getLog(Utils.class);

    public static void addParametersToJson(List<String> pipelineParameters, JSONArray parametersArray, String parameterName, String parameterValue) {
        for (String param : pipelineParameters) {
            JSONObject mainJson = new JSONObject();
            mainJson.put(parameterName, (Object)param);
            mainJson.put(parameterValue, (Object)"");
            parametersArray.add((Object)mainJson);
        }
    }

    public static LinkedHashMap<String, String> getParamsMap(JSONArray paramsJsonArray, String parameterName, String parameterValue) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < paramsJsonArray.size(); ++i) {
            JSONObject param = paramsJsonArray.getJSONObject(i);
            paramsMap.put(param.getString(parameterName), param.getString(parameterValue));
        }
        return paramsMap;
    }

    public static void addParametersToJsonAndPreserveStored(List<String> pipelineParameters, JSONArray parametersArray, String parameterName, String parameterValue, Map<String, String> storedParamsMap) {
        for (String param : pipelineParameters) {
            JSONObject mainJson = new JSONObject();
            mainJson.put(parameterName, (Object)param);
            mainJson.put(parameterValue, (Object)storedParamsMap.getOrDefault(param, ""));
            parametersArray.add((Object)mainJson);
        }
    }

    public static String encodeURL(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, "UTF-8").replaceAll("\\+", "%20");
    }

    public static void expandParameters(JSONArray parameters, EnvReplacer env) {
        for (Object jsonObject : parameters) {
            JSONObject json = (JSONObject)jsonObject;
            String parameterValue = (String)json.get("parameterValue");
            String expandValue = env.expandEnv(parameterValue);
            json.put("parameterValue", (Object)expandValue);
        }
    }

    public static void expandParameters(JSONArray parameters, EnvReplacer env, String propertyName) {
        for (Object jsonObject : parameters) {
            JSONObject json = (JSONObject)jsonObject;
            String parameterValue = (String)json.get(propertyName);
            String expandValue = env.expandEnv(parameterValue);
            json.put(propertyName, (Object)expandValue);
        }
    }

    public static ListBoxModel fillConfigurationItems() {
        ListBoxModel m = new ListBoxModel();
        m.add("Select configuration", "");
        for (Configuration cred : Utils.getConfigurations()) {
            m.add(cred.getConfigurationName(), cred.getConfigurationName());
        }
        return m;
    }

    public static String formatJsonOutput(String result) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object json = mapper.readValue(result, Object.class);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
    }

    public static FormValidation validateValueOnEmpty(String value, String fieldName) {
        if (!value.isEmpty()) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)(fieldName + " field should not be empty."));
    }

    public static FormValidation validateConfiguration(String configuration) {
        if (configuration == null || configuration.isEmpty()) {
            return FormValidation.warning((String)"Configuration field should not be empty.");
        }
        if (configuration.equals(CONFIG_SKIP_CHECK_CONNECTION)) {
            return FormValidation.ok();
        }
        try {
            new ElectricFlowClient(configuration).testConnection();
        }
        catch (Exception e) {
            log.error((Object)("Connection to CloudBees CD Server Failed. Please fix connection information and reload this page. Error message: " + e.getMessage()), (Throwable)e);
            return FormValidation.error((String)("Connection to CloudBees CD Server Failed. Please fix connection information and reload this page. Error message: " + e.getMessage()));
        }
        return FormValidation.ok();
    }

    public static Configuration getConfigurationByName(String name) {
        for (Configuration cred : Utils.getConfigurations()) {
            if (!cred.getConfigurationName().equals(name)) continue;
            return cred;
        }
        return null;
    }

    public static List<Configuration> getConfigurations() {
        ElectricFlowGlobalConfiguration cred = (ElectricFlowGlobalConfiguration)((Object)GlobalConfiguration.all().get(ElectricFlowGlobalConfiguration.class));
        if (cred != null && cred.configurations != null) {
            return cred.configurations;
        }
        return new ArrayList<Configuration>();
    }

    public static String getParametersHTML(List<String> parameters, String summaryText) {
        if (!parameters.isEmpty()) {
            StringBuilder strBuilder = new StringBuilder(summaryText);
            strBuilder.append("  <tr>\n    <td>&nbsp;<b>Stages to run</b></td>\n").append("    <td></td>    \n").append("  </tr>\n");
            for (String param : parameters) {
                strBuilder.append("  <tr>\n    <td>&nbsp;&nbsp;&nbsp;&nbsp;").append(HtmlUtils.encodeForHtml(param)).append("</td>\n").append("  </tr>\n");
            }
            summaryText = strBuilder.toString();
        }
        return summaryText;
    }

    public static String getParametersHTML(JSONArray parameters, String summaryText, String parameterName, String parameterValue) {
        if (!parameters.isEmpty()) {
            StringBuilder strBuilder = new StringBuilder(summaryText);
            strBuilder.append("  <tr>\n    <td>&nbsp;<b>Parameters</b></td>\n    <td></td>    \n  </tr>\n");
            for (int i = 0; i < parameters.size(); ++i) {
                JSONObject json = parameters.getJSONObject(i);
                String name = json.getString(parameterName);
                String value = json.getString(parameterValue);
                strBuilder.append("  <tr>\n    <td>&nbsp;&nbsp;&nbsp;&nbsp;").append(HtmlUtils.encodeForHtml(name)).append(":</td>\n    <td>").append(HtmlUtils.encodeForHtml(value)).append("</td>    \n  </tr>\n");
            }
            summaryText = strBuilder.toString();
        }
        return summaryText;
    }

    public static ListBoxModel getPipelines(String configuration, Credential overrideCredential, String projectName) {
        try {
            ListBoxModel m = new ListBoxModel();
            m.add("Select pipeline", "");
            if (!projectName.isEmpty() && !configuration.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName)) {
                ElectricFlowClient efClient = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredential, null, true);
                String pipelinesString = efClient.getPipelines(projectName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got pipelines: " + pipelinesString));
                }
                JSONObject jsonObject = JSONObject.fromObject((Object)pipelinesString);
                JSONArray pipelines = new JSONArray();
                if (!jsonObject.isEmpty()) {
                    pipelines = jsonObject.getJSONArray("pipeline");
                }
                for (int i = 0; i < pipelines.size(); ++i) {
                    String gotPipelineName = pipelines.getJSONObject(i).getString("pipelineName");
                    m.add(gotPipelineName, gotPipelineName);
                }
            }
            return m;
        }
        catch (Exception e) {
            if (Utils.isEflowAvailable(configuration, overrideCredential)) {
                log.error((Object)("Error when fetching values for this parameter - pipeline. Error message: " + e.getMessage()), (Throwable)e);
                return SelectFieldUtils.getListBoxModelOnException("Select pipeline");
            }
            return SelectFieldUtils.getListBoxModelOnWrongConf("Select pipeline");
        }
    }

    public static boolean isEflowAvailable(String configuration, Credential overrideCredential) {
        try {
            ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredential, null, true).testConnection();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ListBoxModel getProjects(String configuration, Credential overrideCredential) {
        try {
            ListBoxModel m = new ListBoxModel();
            m.add("Select project", new SelectItemValidationWrapper(FieldValidationStatus.WARN, "Project name field should not be empty.", "").getJsonStr());
            if (!configuration.isEmpty()) {
                ElectricFlowClient efClient = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredential, null, true);
                String projectsString = efClient.getProjects();
                JSONObject jsonObject = JSONObject.fromObject((Object)projectsString);
                JSONArray projects = jsonObject.getJSONArray("project");
                for (int i = 0; i < projects.size(); ++i) {
                    if (projects.getJSONObject(i).has("pluginKey")) continue;
                    String gotProjectName = projects.getJSONObject(i).getString("projectName");
                    m.add(gotProjectName, gotProjectName);
                }
            }
            return m;
        }
        catch (Exception e) {
            if (Utils.isEflowAvailable(configuration, overrideCredential)) {
                log.error((Object)("Error when fetching values for this parameter - project. Error message: " + e.getMessage()), (Throwable)e);
                return SelectFieldUtils.getListBoxModelOnException("Select project");
            }
            return SelectFieldUtils.getListBoxModelOnWrongConf("Select project");
        }
    }

    public static String getValidationComparisonHeaderRow() {
        return "<thead style=\"background-color: #e0e0e0;\"><td>Parameter Name</td><td>Old Value</td><td>New Value</td></thead>";
    }

    public static String getValidationComparisonRow(String parameterName, Object oldValue, Object newValue) {
        String rowStyleAttr = "";
        if (!newValue.equals(oldValue)) {
            rowStyleAttr = "style=\"background-color: #e2db0c;\"";
        }
        return "<tr " + rowStyleAttr + "><td>" + HtmlUtils.encodeForHtml(parameterName) + "</td><td>" + HtmlUtils.encodeForHtml(String.valueOf(oldValue)) + "</td><td>" + HtmlUtils.encodeForHtml(String.valueOf(newValue)) + "</td></tr>";
    }

    public static String getValidationComparisonRowOldParam(String parameterName, Object oldValue) {
        String rowStyleAttr = "style=\"background-color: #fa9a76;\"";
        return "<tr " + rowStyleAttr + "><td>" + HtmlUtils.encodeForHtml(parameterName) + "</td><td>" + HtmlUtils.encodeForHtml(String.valueOf(oldValue)) + "</td><td></td></tr>";
    }

    public static String getValidationComparisonRowNewParam(String parameterName, Object newValue) {
        String rowStyleAttr = "style=\"background-color: #82dc84;\"";
        return "<tr " + rowStyleAttr + "><td>" + HtmlUtils.encodeForHtml(parameterName) + "</td><td></td><td>" + HtmlUtils.encodeForHtml(String.valueOf(newValue)) + "</td></tr>";
    }

    public static String getValidationComparisonRowsForExtraParameters(String sectionName, Map<String, String> oldParamsMap, Map<String, String> newParamsMap) {
        if (oldParamsMap.isEmpty() && newParamsMap.isEmpty()) {
            return "";
        }
        StringBuilder rows = new StringBuilder();
        rows.append("<tr><td></td><td></td><td></td></tr>");
        rows.append("<tr><td>" + HtmlUtils.encodeForHtml(sectionName) + "</td><td></td><td></td></tr>");
        HashSet<String> oldKeysSet = new HashSet<String>(oldParamsMap.keySet());
        oldKeysSet.removeAll(newParamsMap.keySet());
        HashSet<String> matchingKeysSet = new HashSet<String>(oldParamsMap.keySet());
        matchingKeysSet.retainAll(newParamsMap.keySet());
        for (String string : oldKeysSet) {
            rows.append(Utils.getValidationComparisonRowOldParam(string, oldParamsMap.get(string)));
        }
        for (Map.Entry entry : newParamsMap.entrySet()) {
            if (matchingKeysSet.contains(entry.getKey())) {
                rows.append(Utils.getValidationComparisonRow((String)entry.getKey(), oldParamsMap.get(entry.getKey()), entry.getValue()));
                continue;
            }
            rows.append(Utils.getValidationComparisonRowNewParam((String)entry.getKey(), entry.getValue()));
        }
        return rows.toString();
    }

    public static EnvVars getNodeEnvVars() {
        DescribableList globalNodeProperties = Jenkins.get().getGlobalNodeProperties();
        List envVarsNodePropertyList = globalNodeProperties.getAll(EnvironmentVariablesNodeProperty.class);
        if (envVarsNodePropertyList == null || envVarsNodePropertyList.isEmpty()) {
            EnvironmentVariablesNodeProperty newEnvVarsNodeProperty = new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[0]);
            globalNodeProperties.add((Object)newEnvVarsNodeProperty);
            return newEnvVarsNodeProperty.getEnvVars();
        }
        return ((EnvironmentVariablesNodeProperty)envVarsNodePropertyList.get(0)).getEnvVars();
    }

    public static PrintStream getLogger(BuildListener bl, TaskListener tl) {
        PrintStream logger = null;
        if (bl != null) {
            logger = bl.getLogger();
            return logger;
        }
        if (tl != null) {
            logger = tl.getLogger();
            return logger;
        }
        return logger;
    }

    public static Result getCorrespondedCiBuildResult(CdPipelineStatus cdPipelineStatus) {
        switch (cdPipelineStatus) {
            case success: {
                return Result.SUCCESS;
            }
            case warning: {
                return Result.UNSTABLE;
            }
        }
        return Result.FAILURE;
    }

    public static Result getCorrespondedCiBuildResult(CdJobOutcome cdJobOutcome) {
        switch (cdJobOutcome) {
            case success: {
                return Result.SUCCESS;
            }
            case warning: {
                return Result.UNSTABLE;
            }
        }
        return Result.FAILURE;
    }
}

