/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.electricflow.ArtifactUploadSummaryTextAction;
import org.jenkinsci.plugins.electricflow.Configuration;
import org.jenkinsci.plugins.electricflow.Credential;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.extension.ArtifactUploadData;
import org.jenkinsci.plugins.electricflow.factories.ElectricFlowClientFactory;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElectricFlowUploadArtifactPublisher
extends Recorder
implements SimpleBuildStep {
    public static final String FLOW_ARTIFACT_REPOSITORY = "Flow Artifact Repository";
    private static final Log log = LogFactory.getLog(ElectricFlowUploadArtifactPublisher.class);
    private final String configuration;
    private final String repositoryName;
    private Credential overrideCredential;
    private String artifactName;
    private String artifactVersion;
    private String filePath;
    private String relativeWorkspace;

    @DataBoundConstructor
    public ElectricFlowUploadArtifactPublisher(String repositoryName, String artifactName, String artifactVersion, String filePath, String configuration) {
        this.repositoryName = repositoryName;
        this.artifactName = artifactName;
        this.artifactVersion = artifactVersion;
        this.filePath = filePath;
        this.configuration = configuration;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        boolean isSuccess = this.runProcess(run, taskListener, workspace);
        if (!isSuccess) {
            run.setResult(Result.FAILURE);
        }
    }

    private boolean runProcess(@Nonnull Run<?, ?> run, @Nonnull TaskListener taskListener, @Nonnull FilePath workspace) {
        PrintStream logger = Utils.getLogger(null, taskListener);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Publishing artifact...");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Workspace directory: " + workspace));
            }
            EnvReplacer env = new EnvReplacer(run, taskListener);
            String newRelativeWorkspace = env.expandEnv(this.relativeWorkspace);
            String newFilePath = env.expandEnv(this.filePath);
            String newArtifactVersion = env.expandEnv(this.artifactVersion);
            String newArtifactName = env.expandEnv(this.artifactName);
            String artifactVersionName = newArtifactName + ":" + newArtifactVersion;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Workspace directory: " + newFilePath));
            }
            FilePath actualWorkspace = newRelativeWorkspace == null ? workspace : new FilePath(workspace, newRelativeWorkspace);
            ElectricFlowClient efClient = ElectricFlowClientFactory.getElectricFlowClient(this.configuration, this.overrideCredential, run, env, false);
            String result = efClient.uploadArtifact(run, taskListener, this.repositoryName, newArtifactName, newArtifactVersion, newFilePath, true, actualWorkspace);
            if (!"Artifact-Published-OK".equals(result)) {
                logger.println("Upload result: " + result);
                return false;
            }
            String efArtifactUrl = efClient.getElectricFlowUrl() + "/commander/link/artifactVersionDetails/artifactVersions/" + Utils.encodeURL(newArtifactName + ":" + newArtifactVersion) + "?s=Artifacts&ss=Artifacts";
            String efArtifactAllVersionsUrl = efClient.getElectricFlowUrl() + "/commander/link/artifactDetails/artifacts/" + Utils.encodeURL(newArtifactName) + "?s=Artifacts&ss=Artifacts";
            String repository = this.repositoryName.isEmpty() ? "default" : this.repositoryName;
            String summaryHtml = this.getSummaryHtml(newArtifactVersion, repository, efArtifactUrl, efArtifactAllVersionsUrl);
            ArtifactUploadSummaryTextAction action = new ArtifactUploadSummaryTextAction(run, summaryHtml);
            ArtifactUploadData artifactUploadData = new ArtifactUploadData();
            artifactUploadData.setArtifactName(newArtifactName);
            artifactUploadData.setArtifactUrl(efArtifactUrl);
            artifactUploadData.setArtifactVersion(newArtifactVersion);
            artifactUploadData.setArtifactVersionName(artifactVersionName);
            artifactUploadData.setRepositoryName(repository);
            artifactUploadData.setRepositoryType(FLOW_ARTIFACT_REPOSITORY);
            artifactUploadData.setFilePath(newFilePath);
            action.setArtifactUploadData(artifactUploadData);
            logger.println("Artifact Name: " + artifactUploadData.getArtifactName());
            logger.println("Artifact Version: " + artifactUploadData.getArtifactVersion());
            logger.println("Artifact Version Name: " + artifactUploadData.getArtifactVersionName());
            logger.println("Artifact Url: " + artifactUploadData.getArtifactUrl());
            logger.println("Repository Name: " + artifactUploadData.getRepositoryName());
            logger.println("Repository Type: " + artifactUploadData.getRepositoryType());
            logger.println("File path: " + artifactUploadData.getFilePath());
            run.addAction((Action)action);
            run.save();
            logger.println("Upload result: " + result);
        }
        catch (IOException | InterruptedException | KeyManagementException | NoSuchAlgorithmException e) {
            logger.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public Credential getOverrideCredential() {
        return this.overrideCredential;
    }

    @DataBoundSetter
    public void setOverrideCredential(Credential overrideCredential) {
        this.overrideCredential = overrideCredential;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRelativeWorkspace() {
        return this.relativeWorkspace;
    }

    @DataBoundSetter
    public void setRelativeWorkspace(String relativeWorkspace) {
        this.relativeWorkspace = relativeWorkspace;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getSummaryHtml(String newArtifactVersion, String repository, String efUrl, String efArtifactAllVersionsUrl) {
        return "<h3>CloudBees CD Publish Artifact</h3><table cellspacing=\"2\" cellpadding=\"4\">\n  <tr>\n    <td>Artifact URL:</td>\n    <td><a href ='" + HtmlUtils.encodeForHtml(efUrl) + "'>" + HtmlUtils.encodeForHtml(efUrl) + "</a></td> \n  </tr>\n  <tr>\n    <td>Artifact Name:</td>\n    <td><a href ='" + HtmlUtils.encodeForHtml(efArtifactAllVersionsUrl) + "'>" + HtmlUtils.encodeForHtml(this.artifactName) + "</a></td> \n  </tr>\n  <tr>\n    <td>Artifact Version:</td>\n    <td>" + HtmlUtils.encodeForHtml(newArtifactVersion) + "</td> \n  </tr>\n  <tr>\n    <td>Repository Name:</td>\n    <td>" + HtmlUtils.encodeForHtml(repository) + "</td> \n  </tr>\n</table>";
    }

    @Symbol(value={"cloudBeesFlowPublishArtifact"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final Log log = LogFactory.getLog(DescriptorImpl.class);

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckArtifactName(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateValueOnEmpty(value, "Artifact name");
        }

        public FormValidation doCheckArtifactVersion(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateValueOnEmpty(value, "Artifact version");
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateValueOnEmpty(value, "Configuration");
        }

        public FormValidation doCheckFilePath(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateValueOnEmpty(value, "File path");
        }

        public FormValidation doCheckRepositoryName(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateValueOnEmpty(value, "Repository name");
        }

        public ListBoxModel doFillConfigurationItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
            return Credential.DescriptorImpl.doFillCredentialIdItems(item);
        }

        public ListBoxModel doFillRepositoryNameItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel m = new ListBoxModel();
            m.add("Select repository", "");
            if (configuration.isEmpty()) {
                return m;
            }
            try {
                Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                ElectricFlowClient efClient = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                List<String> repositories = efClient.getArtifactRepositories();
                for (String repo : repositories) {
                    m.add(repo, repo);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Error retrieving repository list: " + e.getMessage()), (Throwable)e);
                return m;
            }
            return m;
        }

        public Configuration getConfigurationByName(String name) {
            return Utils.getConfigurationByName(name);
        }

        public String getDisplayName() {
            return "CloudBees CD - Publish Artifact";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }
}

