/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.electricflow.Credential;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.Release;
import org.jenkinsci.plugins.electricflow.RunAndWaitOption;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.action.CloudBeesCDPBABuildDetails;
import org.jenkinsci.plugins.electricflow.data.CloudBeesFlowBuildData;
import org.jenkinsci.plugins.electricflow.exceptions.FlowRuntimeException;
import org.jenkinsci.plugins.electricflow.factories.ElectricFlowClientFactory;
import org.jenkinsci.plugins.electricflow.models.CIBuildDetail;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.GetPipelineRuntimeDetailsResponseData;
import org.jenkinsci.plugins.electricflow.ui.FieldValidationStatus;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectFieldUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectItemValidationWrapper;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElectricFlowTriggerRelease
extends Recorder
implements SimpleBuildStep {
    private static final Log log = LogFactory.getLog(ElectricFlowTriggerRelease.class);
    private String configuration;
    private Credential overrideCredential;
    private RunAndWaitOption runAndWaitOption;
    private String projectName;
    private String releaseName;
    private String startingStage;
    private String parameters;

    @DataBoundConstructor
    public ElectricFlowTriggerRelease() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) {
        JSONObject release = JSONObject.fromObject((Object)this.parameters).getJSONObject("release");
        JSONArray stages = JSONArray.fromObject((Object)release.getString("stages"));
        JSONArray pipelineParameters = JSONArray.fromObject((Object)release.getString("parameters"));
        ArrayList<String> stagesToRun = new ArrayList<String>();
        if (this.startingStage.isEmpty()) {
            for (int i = 0; i < stages.size(); ++i) {
                JSONObject stage = stages.getJSONObject(i);
                if (!stage.getBoolean("stageValue")) continue;
                stagesToRun.add(stage.getString("stageName"));
            }
        }
        PrintStream logger = taskListener.getLogger();
        try {
            logger.println("Preparing to triggerRelease...");
            EnvReplacer env = new EnvReplacer(run, taskListener);
            ElectricFlowClient efClient = ElectricFlowClientFactory.getElectricFlowClient(this.configuration, this.overrideCredential, run, env, false);
            Utils.expandParameters(pipelineParameters, env);
            String releaseResult = efClient.runRelease(this.projectName, this.releaseName, stagesToRun, this.startingStage, pipelineParameters);
            JSONObject flowRuntime = JSONObject.fromObject((Object)releaseResult).getJSONObject("flowRuntime");
            String flowRuntimeId = flowRuntime.getString("flowRuntimeId");
            String summaryHtml = this.getSummaryHtml(efClient, flowRuntime, pipelineParameters, stagesToRun, null);
            SummaryTextAction action = new SummaryTextAction(run, summaryHtml);
            try {
                CloudBeesFlowBuildData cbfdb = new CloudBeesFlowBuildData(run);
                if (log.isDebugEnabled()) {
                    logger.println("CBF Data: " + cbfdb.toJsonObject().toString());
                }
                logger.println("About to call setJenkinsBuildDetails after triggering a Flow Release");
                JSONObject associateResult = efClient.attachCIBuildDetails(new CIBuildDetail(cbfdb, this.projectName).setFlowRuntimeId(flowRuntime.getString("flowRuntimeId")).setAssociationType(CIBuildDetail.BuildAssociationType.TRIGGERED_BY_CI).setBuildTriggerSource(CIBuildDetail.BuildTriggerSource.CI));
                if (log.isDebugEnabled()) {
                    logger.println("Return from efClient: " + associateResult.toString());
                }
                CloudBeesCDPBABuildDetails.applyToRuntime(run, this.configuration, this.overrideCredential, flowRuntimeId, null, this.projectName, this.releaseName, null, CIBuildDetail.BuildTriggerSource.CI, CIBuildDetail.BuildAssociationType.TRIGGERED_BY_CI);
            }
            catch (RuntimeException ex) {
                log.info((Object)("Can't attach CIBuildData to the pipeline run: " + ex.getMessage()));
            }
            run.addAction((Action)action);
            run.save();
            logger.println("TriggerRelease  result: " + Utils.formatJsonOutput(releaseResult));
            if (this.runAndWaitOption != null) {
                Result result;
                GetPipelineRuntimeDetailsResponseData responseData;
                int checkInterval = this.runAndWaitOption.getCheckInterval();
                logger.println("Waiting till CloudBees CD pipeline is completed, checking every " + checkInterval + " seconds");
                do {
                    TimeUnit.SECONDS.sleep(checkInterval);
                    responseData = efClient.getCdPipelineRuntimeDetails(flowRuntimeId);
                    logger.println(responseData.toString());
                    summaryHtml = this.getSummaryHtml(efClient, flowRuntime, pipelineParameters, stagesToRun, responseData);
                    action = new SummaryTextAction(run, summaryHtml);
                    run.addOrReplaceAction((Action)action);
                    run.save();
                } while (!responseData.isCompleted().booleanValue());
                logger.println("CD pipeline completed with " + (Object)((Object)responseData.getStatus()) + " status");
                if (this.runAndWaitOption.isDependOnCdJobOutcome() && !(result = Utils.getCorrespondedCiBuildResult(responseData.getStatus())).equals(Result.SUCCESS)) {
                    if (this.runAndWaitOption.isThrowExceptionIfFailed()) {
                        throw new FlowRuntimeException(responseData);
                    }
                    run.setResult(result);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            logger.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            run.setResult(Result.FAILURE);
        }
    }

    private String getReleaseNameFromResponse(String releaseResult) {
        JSONObject releaseJSON = JSONObject.fromObject((Object)releaseResult).getJSONObject("release");
        return (String)releaseJSON.get("releaseName");
    }

    private String getProjectNameFromResponse(String releaseResult) {
        JSONObject releaseJSON = JSONObject.fromObject((Object)releaseResult).getJSONObject("release");
        return (String)releaseJSON.get("projectName");
    }

    private String getSetJenkinsBuildDetailsUrlBase(String releaseResult) {
        JSONObject releaseJSON = JSONObject.fromObject((Object)releaseResult).getJSONObject("release");
        String retval = "/flowRuntimes/" + releaseJSON.get("releaseName") + "/jenkinsBuildDetails";
        return retval;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getStoredConfiguration() {
        return this.configuration;
    }

    public Credential getOverrideCredential() {
        return this.overrideCredential;
    }

    @DataBoundSetter
    public void setOverrideCredential(Credential overrideCredential) {
        this.overrideCredential = overrideCredential;
    }

    public RunAndWaitOption getRunAndWaitOption() {
        return this.runAndWaitOption;
    }

    @DataBoundSetter
    public void setRunAndWaitOption(RunAndWaitOption runAndWaitOption) {
        this.runAndWaitOption = runAndWaitOption;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getParameters() {
        return this.parameters;
    }

    @DataBoundSetter
    public void setParameters(String parameters) {
        this.parameters = SelectFieldUtils.getSelectItemValue(parameters);
    }

    public String getStoredParameters() {
        return this.parameters;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = SelectFieldUtils.getSelectItemValue(projectName);
    }

    public String getStoredProjectName() {
        return this.projectName;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    @DataBoundSetter
    public void setReleaseName(String releaseName) {
        this.releaseName = SelectFieldUtils.getSelectItemValue(releaseName);
    }

    public String getStoredReleaseName() {
        return this.releaseName;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getStartingStage() {
        return this.startingStage;
    }

    @DataBoundSetter
    public void setStartingStage(String startingStage) {
        this.startingStage = SelectFieldUtils.getSelectItemValue(startingStage);
    }

    public String getStoredStartingStage() {
        return this.startingStage;
    }

    public boolean getValidationTrigger() {
        return true;
    }

    @DataBoundSetter
    public void setValidationTrigger(String validationTrigger) {
    }

    private String getSummaryHtml(ElectricFlowClient efClient, JSONObject flowRuntime, JSONArray parameters, List<String> stagesToRun, GetPipelineRuntimeDetailsResponseData getPipelineRuntimeDetailsResponseData) {
        String pipelineId = flowRuntime.getString("pipelineId");
        String flowRuntimeId = flowRuntime.getString("flowRuntimeId");
        String pipelineName = flowRuntime.getString("pipelineName");
        String releaseId = flowRuntime.getString("releaseId");
        String pipelineUrl = efClient.getElectricFlowUrl() + "/flow/#pipeline-kanban/" + pipelineId;
        String releasePipelineRunUrl = efClient.getElectricFlowUrl() + "/flow/#pipeline-run/" + pipelineId + "/" + flowRuntimeId + "/release/" + releaseId;
        String releaseUrl = efClient.getElectricFlowUrl() + "/flow/#release-kanban/" + releaseId;
        String summaryText = "<h3>CloudBees CD Trigger Release</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td>Release Name:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(releaseUrl) + "'>" + HtmlUtils.encodeForHtml(this.releaseName) + "</a></td>   \n  </tr>\n  <tr>\n    <td>Release Pipeline Run URL:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(releasePipelineRunUrl) + "'>" + HtmlUtils.encodeForHtml(releasePipelineRunUrl) + "</a></td>   \n  </tr>\n  <tr>\n    <td>Pipeline Name:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(pipelineUrl) + "'>" + HtmlUtils.encodeForHtml(pipelineName) + "</a></td>   \n  </tr>\n  <tr>\n    <td>Project Name:</td>\n    <td>" + HtmlUtils.encodeForHtml(this.projectName) + "</td>    \n  </tr>";
        if (!this.startingStage.isEmpty()) {
            summaryText = summaryText + "  <tr>\n    <td>Starting stage:</td>\n    <td>" + HtmlUtils.encodeForHtml(this.startingStage) + "</td>    \n  </tr>";
        }
        if (!stagesToRun.isEmpty()) {
            summaryText = Utils.getParametersHTML(stagesToRun, summaryText);
        }
        summaryText = Utils.getParametersHTML(parameters, summaryText, "parameterName", "parameterValue");
        if (getPipelineRuntimeDetailsResponseData != null) {
            summaryText = summaryText + "  <tr>\n    <td>CD Pipeline Completed:</td>\n    <td>\n" + getPipelineRuntimeDetailsResponseData.isCompleted() + "    </td>\n  </tr>\n";
            summaryText = summaryText + "  <tr>\n    <td>CD Pipeline Status:</td>\n    <td>\n" + HtmlUtils.encodeForHtml(getPipelineRuntimeDetailsResponseData.getStatus().name()) + "    </td>\n  </tr>\n";
        }
        summaryText = summaryText + "</table>";
        return summaryText;
    }

    @Symbol(value={"cloudBeesFlowTriggerRelease"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        static Map<String, String> getStagesToRunMapFromParams(String deployParameters) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (deployParameters == null || deployParameters.isEmpty() || deployParameters.equals("{}")) {
                return paramsMap;
            }
            JSONObject json = JSONObject.fromObject((Object)deployParameters);
            if (!json.containsKey((Object)"release") || !json.getJSONObject("release").containsKey((Object)"stages")) {
                return paramsMap;
            }
            return Utils.getParamsMap(JSONArray.fromObject((Object)json.getJSONObject("release").getString("stages")), "stageName", "stageValue");
        }

        static Map<String, String> getPipelineParamsMapFromParams(String deployParameters) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (deployParameters == null || deployParameters.isEmpty() || deployParameters.equals("{}")) {
                return paramsMap;
            }
            JSONObject json = JSONObject.fromObject((Object)deployParameters);
            if (!json.containsKey((Object)"release") || !json.getJSONObject("release").containsKey((Object)"parameters")) {
                return paramsMap;
            }
            return Utils.getParamsMap(JSONArray.fromObject((Object)json.getJSONObject("release").getString("parameters")), "parameterName", "parameterValue");
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateConfiguration(value);
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Project name");
        }

        public FormValidation doCheckReleaseName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Release name");
        }

        public FormValidation doCheckStartingStage(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckParameters(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillConfigurationItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
            return Credential.DescriptorImpl.doFillCredentialIdItems(item);
        }

        public ListBoxModel doFillParametersItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @QueryParameter String projectName, @QueryParameter String releaseName, @QueryParameter String parameters, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                JSONObject json;
                JSONObject jsonArray;
                ListBoxModel m = new ListBoxModel();
                if (projectName.isEmpty() || releaseName.isEmpty() || configuration.isEmpty() || SelectFieldUtils.checkAnySelectItemsIsValidationWrappers(projectName, releaseName)) {
                    m.add("{}");
                    return m;
                }
                HashMap<String, String> storedStagesToRun = new HashMap();
                HashMap<String, String> storedPipelineParams = new HashMap();
                String parametersValue = SelectFieldUtils.getSelectItemValue(parameters);
                if (!parametersValue.isEmpty() && !"{}".equals(parametersValue) && releaseName.equals((jsonArray = (json = JSONObject.fromObject((Object)parametersValue)).getJSONObject("release")).getString("releaseName"))) {
                    storedStagesToRun = DescriptorImpl.getStagesToRunMapFromParams(parametersValue);
                    storedPipelineParams = DescriptorImpl.getPipelineParamsMapFromParams(parametersValue);
                }
                if (!configuration.isEmpty() && !releaseName.isEmpty()) {
                    Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                    ElectricFlowClient client = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                    Release release = client.getRelease(configuration, projectName, releaseName);
                    List<String> stages = release.getStartStages();
                    List<String> pipelineParameters = release.getPipelineParameters();
                    JSONObject main = JSONObject.fromObject((Object)("{'release':{'releaseName':'" + releaseName + "','stages':[], pipelineName:'" + release.getPipelineName() + "', 'parameters':[]}}"));
                    JSONArray stagesArray = main.getJSONObject("release").getJSONArray("stages");
                    Utils.addParametersToJsonAndPreserveStored(stages, stagesArray, "stageName", "stageValue", storedStagesToRun);
                    JSONArray parametersArray = main.getJSONObject("release").getJSONArray("parameters");
                    Utils.addParametersToJsonAndPreserveStored(pipelineParameters, parametersArray, "parameterName", "parameterValue", storedPipelineParams);
                    m.add(main.toString());
                }
                if (m.isEmpty()) {
                    m.add("{}");
                }
                return m;
            }
            catch (Exception e) {
                SelectItemValidationWrapper selectItemValidationWrapper;
                Credential overrideCredentialObj;
                ListBoxModel m = new ListBoxModel();
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching set of parameters. Error message: " + e.getMessage()), (Throwable)e);
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of parameters. Check the Jenkins logs for more details.", "{}");
                } else {
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of deploy parameters. Connection to CloudBees CD Server Failed. Please fix connection information and reload this page.", "{}");
                }
                m.add(selectItemValidationWrapper.getJsonStr());
                return m;
            }
        }

        public ListBoxModel doFillProjectNameItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
            return Utils.getProjects(configuration, overrideCredentialObj);
        }

        public ListBoxModel doFillReleaseNameItems(@QueryParameter String projectName, @QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select release", "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName)) {
                    Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                    ElectricFlowClient client = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                    List<String> releasesList = client.getReleaseNames(configuration, projectName);
                    for (String release : releasesList) {
                        m.add(release);
                    }
                }
                return m;
            }
            catch (Exception e) {
                Credential overrideCredentialObj;
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching values for this parameter - release. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select release");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select release");
            }
        }

        public ListBoxModel doFillStartingStageItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @QueryParameter String projectName, @QueryParameter String releaseName, @AncestorInPath Item item) throws Exception {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select starting stage", "");
                if (projectName.isEmpty() || releaseName.isEmpty() || configuration.isEmpty() || SelectFieldUtils.checkAnySelectItemsIsValidationWrappers(projectName, releaseName)) {
                    return m;
                }
                Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                ElectricFlowClient client = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                Release release = client.getRelease(configuration, projectName, releaseName);
                if (release == null) {
                    return m;
                }
                List<String> startStages = release.getStartStages();
                for (String state : startStages) {
                    m.add(state);
                }
                return m;
            }
            catch (Exception e) {
                Credential overrideCredentialObj;
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching values for this parameter - starting stage. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select starting stage");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select starting stage");
            }
        }

        public String getDisplayName() {
            return "CloudBees CD - Trigger Release";
        }

        public String getId() {
            return "electricFlowTriggerRelease";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doShowOldValues(@QueryParameter(value="configuration") String configuration, @QueryParameter(value="projectName") String projectName, @QueryParameter(value="releaseName") String releaseName, @QueryParameter(value="startingStage") String startingStage, @QueryParameter(value="parameters") String parameters, @QueryParameter(value="storedConfiguration") String storedConfiguration, @QueryParameter(value="storedProjectName") String storedProjectName, @QueryParameter(value="storedReleaseName") String storedReleaseName, @QueryParameter(value="storedStartingStage") String storedStartingStage, @QueryParameter(value="storedParameters") String storedParameters, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            String configurationValue = configuration;
            String projectNameValue = SelectFieldUtils.getSelectItemValue(projectName);
            String releaseNameValue = SelectFieldUtils.getSelectItemValue(releaseName);
            String startingStageValue = SelectFieldUtils.getSelectItemValue(startingStage);
            String parametersValue = SelectFieldUtils.getSelectItemValue(parameters);
            Map<String, String> stagesToRunMap = DescriptorImpl.getStagesToRunMapFromParams(parametersValue);
            Map<String, String> storedStagesToRunMap = DescriptorImpl.getStagesToRunMapFromParams(storedParameters);
            Map<String, String> pipelineParamsMap = DescriptorImpl.getPipelineParamsMapFromParams(parametersValue);
            Map<String, String> storedPipelineParamsMap = DescriptorImpl.getPipelineParamsMapFromParams(storedParameters);
            String comparisonTable = "<table>" + Utils.getValidationComparisonHeaderRow() + Utils.getValidationComparisonRow("Configuration", storedConfiguration, configurationValue) + Utils.getValidationComparisonRow("Project Name", storedProjectName, projectNameValue) + Utils.getValidationComparisonRow("Release Name", storedReleaseName, releaseNameValue) + Utils.getValidationComparisonRow("Starting Stage", storedStartingStage, startingStageValue) + Utils.getValidationComparisonRowsForExtraParameters("Stages to run", storedStagesToRunMap, stagesToRunMap) + Utils.getValidationComparisonRowsForExtraParameters("Release pipeline parameters", storedPipelineParamsMap, pipelineParamsMap) + "</table>";
            if (configurationValue.equals(storedConfiguration) && projectNameValue.equals(storedProjectName) && releaseNameValue.equals(storedReleaseName) && startingStageValue.equals(storedStartingStage) && pipelineParamsMap.equals(storedPipelineParamsMap)) {
                return FormValidation.okWithMarkup((String)("No changes detected:<br>" + comparisonTable));
            }
            return FormValidation.warningWithMarkup((String)("Changes detected:<br>" + comparisonTable));
        }
    }
}

