/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.electricflow.Configuration;
import org.jenkinsci.plugins.electricflow.Credential;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.RunAndWaitOption;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.action.CloudBeesCDPBABuildDetails;
import org.jenkinsci.plugins.electricflow.data.CloudBeesFlowBuildData;
import org.jenkinsci.plugins.electricflow.exceptions.FlowRuntimeException;
import org.jenkinsci.plugins.electricflow.factories.ElectricFlowClientFactory;
import org.jenkinsci.plugins.electricflow.models.CIBuildDetail;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.GetPipelineRuntimeDetailsResponseData;
import org.jenkinsci.plugins.electricflow.ui.FieldValidationStatus;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectFieldUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectItemValidationWrapper;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ElectricFlowPipelinePublisher
extends Recorder
implements SimpleBuildStep {
    private static final Log log = LogFactory.getLog(ElectricFlowPipelinePublisher.class);
    private String projectName;
    private String pipelineName;
    private String configuration;
    private Credential overrideCredential;
    private RunAndWaitOption runAndWaitOption;
    private String addParam;
    private JSONArray additionalOption;

    @DataBoundConstructor
    public ElectricFlowPipelinePublisher() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) {
        Result result = this.runPipeline(run, null, taskListener);
        if (result != Result.SUCCESS) {
            run.setResult(result);
        }
    }

    private Result runPipeline(Run<?, ?> run, BuildListener buildListener, TaskListener taskListener) {
        String pipelineId;
        ElectricFlowClient efClient;
        PrintStream logger = Utils.getLogger(buildListener, taskListener);
        logger.println("Project name: " + this.projectName + ", Pipeline name: " + this.pipelineName);
        EnvReplacer env = null;
        try {
            env = new EnvReplacer(run, taskListener);
            efClient = ElectricFlowClientFactory.getElectricFlowClient(this.configuration, this.overrideCredential, run, env, false);
        }
        catch (Exception e) {
            logger.println("Cannot create CloudBees CD client. Error: " + e.getMessage());
            log.error((Object)("Cannot create CloudBees CD client. Error: " + e.getMessage()), (Throwable)e);
            return Result.FAILURE;
        }
        try {
            pipelineId = efClient.getPipelineId(this.projectName, this.pipelineName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to retrieve Id for the pipeline: " + e.getMessage());
        }
        if (pipelineId == null || pipelineId.isEmpty()) {
            throw new RuntimeException("Failed to retrieve Id for pipeline '" + this.pipelineName + "' in project '" + this.projectName + "'. Please check that pipeline/project exists and the user with the specified credentials has access to the pipeline/project.");
        }
        try {
            List<String> paramsResponse = efClient.getPipelineFormalParameters(pipelineId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("FormalParameters are: " + paramsResponse.toString()));
            }
        }
        catch (Exception e) {
            logger.println("Error occurred during formal parameters fetch: " + e.getMessage());
            log.error((Object)("Error occurred during formal parameters fetch: " + e.getMessage()), (Throwable)e);
            return Result.FAILURE;
        }
        try {
            String pipelineResult;
            logger.println("Preparing to run pipeline...");
            JSONArray parameters = this.getPipelineParameters();
            if (parameters.isEmpty()) {
                pipelineResult = efClient.runPipeline(this.projectName, this.pipelineName);
            } else {
                Utils.expandParameters(parameters, env);
                pipelineResult = efClient.runPipeline(this.projectName, this.pipelineName, parameters);
            }
            String summaryHtml = this.getSummaryHtml(efClient, pipelineResult, parameters, null);
            SummaryTextAction action = new SummaryTextAction(run, summaryHtml);
            String flowRuntimeId = this.getFlowRuntimeIdFromResponse(pipelineResult);
            String projectName = this.getProjectNameFromResponse(pipelineResult);
            CloudBeesFlowBuildData cbfdb = new CloudBeesFlowBuildData(run);
            if (log.isDebugEnabled()) {
                logger.println("CBF Data: " + cbfdb.toJsonObject().toString());
            }
            try {
                logger.println("About to call setCIBuildDetails after running a Pipeline");
                JSONObject associateResult = efClient.attachCIBuildDetails(new CIBuildDetail(cbfdb, projectName).setFlowRuntimeId(flowRuntimeId).setAssociationType(CIBuildDetail.BuildAssociationType.TRIGGERED_BY_CI));
                if (log.isDebugEnabled()) {
                    logger.println("setCIBuildDetails response: " + associateResult.toString());
                }
                CloudBeesCDPBABuildDetails.applyToRuntime(run, this.configuration, this.overrideCredential, flowRuntimeId, null, projectName, null, null, null, CIBuildDetail.BuildAssociationType.TRIGGERED_BY_CI);
            }
            catch (RuntimeException exception) {
                log.info((Object)("Can't attach CIBuildData to the pipeline run: " + exception.getMessage()));
            }
            run.addAction((Action)action);
            run.save();
            logger.println("Pipeline triggered. Response JSON: " + Utils.formatJsonOutput(pipelineResult));
            if (this.runAndWaitOption != null) {
                GetPipelineRuntimeDetailsResponseData responseData;
                int checkInterval = this.runAndWaitOption.getCheckInterval();
                logger.println("Waiting till CloudBees CD pipeline is completed, checking every " + checkInterval + " seconds");
                do {
                    TimeUnit.SECONDS.sleep(checkInterval);
                    responseData = efClient.getCdPipelineRuntimeDetails(flowRuntimeId);
                    logger.println(responseData);
                    summaryHtml = this.getSummaryHtml(efClient, pipelineResult, parameters, responseData);
                    action = new SummaryTextAction(run, summaryHtml);
                    run.addOrReplaceAction((Action)action);
                    run.save();
                } while (!responseData.isCompleted().booleanValue());
                logger.println("CD pipeline completed with " + (Object)((Object)responseData.getStatus()) + " status");
                if (this.runAndWaitOption.isDependOnCdJobOutcome()) {
                    Result ciBuildResult = Utils.getCorrespondedCiBuildResult(responseData.getStatus());
                    if (!ciBuildResult.equals(Result.SUCCESS) && this.runAndWaitOption.isThrowExceptionIfFailed()) {
                        throw new FlowRuntimeException(responseData);
                    }
                    return ciBuildResult;
                }
            }
        }
        catch (IOException | InterruptedException e) {
            logger.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.FAILURE;
        }
        return Result.SUCCESS;
    }

    public JSONArray getAdditionalOption() {
        return this.additionalOption;
    }

    @DataBoundSetter
    public void setAdditionalOption(JSONArray additionalOption) {
        this.additionalOption = additionalOption;
    }

    public String getAddParam() {
        return this.addParam;
    }

    @DataBoundSetter
    public void setAddParam(String addParam) {
        this.addParam = SelectFieldUtils.getSelectItemValue(addParam);
    }

    public String getStoredAddParam() {
        return this.addParam;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public Credential getOverrideCredential() {
        return this.overrideCredential;
    }

    @DataBoundSetter
    public void setOverrideCredential(Credential overrideCredential) {
        this.overrideCredential = overrideCredential;
    }

    public RunAndWaitOption getRunAndWaitOption() {
        return this.runAndWaitOption;
    }

    @DataBoundSetter
    public void setRunAndWaitOption(RunAndWaitOption runAndWaitOption) {
        this.runAndWaitOption = runAndWaitOption;
    }

    public String getStoredConfiguration() {
        return this.configuration;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    @DataBoundSetter
    public void setPipelineName(String pipelineName) {
        this.pipelineName = SelectFieldUtils.getSelectItemValue(pipelineName);
    }

    public String getStoredPipelineName() {
        return this.pipelineName;
    }

    private JSONArray getPipelineParameters() {
        JSONObject pipelineJsonObject;
        JSONArray pipelineParameters;
        if (!(this.addParam == null || this.addParam.isEmpty() || "{}".equals(this.addParam) || (pipelineParameters = JSONArray.fromObject((Object)(pipelineJsonObject = JSONObject.fromObject((Object)this.addParam).getJSONObject("pipeline")).getString("parameters"))).isEmpty())) {
            return pipelineParameters;
        }
        return new JSONArray();
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = SelectFieldUtils.getSelectItemValue(projectName);
    }

    public String getStoredProjectName() {
        return this.projectName;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getFlowRuntimeIdFromResponse(String pipelineResult) {
        JSONObject flowRuntime = JSONObject.fromObject((Object)pipelineResult).getJSONObject("flowRuntime");
        String flowRuntimeId = (String)flowRuntime.get("flowRuntimeId");
        return flowRuntimeId;
    }

    private String getProjectNameFromResponse(String pipelineResult) {
        JSONObject flowRuntime = JSONObject.fromObject((Object)pipelineResult).getJSONObject("flowRuntime");
        String projectName = (String)flowRuntime.get("projectName");
        return projectName;
    }

    private String getSummaryHtml(ElectricFlowClient efClient, String pipelineResult, JSONArray parameters, GetPipelineRuntimeDetailsResponseData getPipelineRuntimeDetailsResponseData) {
        JSONObject flowRuntime = JSONObject.fromObject((Object)pipelineResult).getJSONObject("flowRuntime");
        String pipelineId = (String)flowRuntime.get("pipelineId");
        String flowRuntimeId = (String)flowRuntime.get("flowRuntimeId");
        String pipelineRunUrl = efClient.getElectricFlowUrl() + "/flow/#pipeline-run/" + pipelineId + "/" + flowRuntimeId;
        String pipelineUrl = efClient.getElectricFlowUrl() + "/flow/#pipeline-kanban/" + pipelineId;
        String summaryText = "<h3>CloudBees CD Run Pipeline</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td>Pipeline URL:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(pipelineRunUrl) + "'>" + HtmlUtils.encodeForHtml(pipelineRunUrl) + "</a></td>   \n  </tr>\n  <tr>\n    <td>Pipeline Name:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(pipelineUrl) + "'>" + HtmlUtils.encodeForHtml(this.pipelineName) + "</a></td>   \n  </tr>\n  <tr>\n    <td>Project Name:</td>\n    <td>" + HtmlUtils.encodeForHtml(this.projectName) + "</td>    \n  </tr>";
        summaryText = Utils.getParametersHTML(parameters, summaryText, "parameterName", "parameterValue");
        if (getPipelineRuntimeDetailsResponseData != null) {
            summaryText = summaryText + "  <tr>\n    <td>CD Pipeline Completed:</td>\n    <td>\n" + getPipelineRuntimeDetailsResponseData.isCompleted() + "    </td>\n  </tr>\n";
            summaryText = summaryText + "  <tr>\n    <td>CD Pipeline Status:</td>\n    <td>\n" + HtmlUtils.encodeForHtml(getPipelineRuntimeDetailsResponseData.getStatus().name()) + "    </td>\n  </tr>\n";
        }
        summaryText = summaryText + "</table>";
        return summaryText;
    }

    @Symbol(value={"cloudBeesFlowRunPipeline"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        static Map<String, String> getParamsMapFromAddParam(String addParam) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (addParam == null || addParam.isEmpty() || addParam.equals("{}")) {
                return paramsMap;
            }
            JSONObject json = JSONObject.fromObject((Object)addParam);
            if (!json.containsKey((Object)"pipeline") || !json.getJSONObject("pipeline").containsKey((Object)"parameters")) {
                return paramsMap;
            }
            return Utils.getParamsMap(JSONArray.fromObject((Object)json.getJSONObject("pipeline").getString("parameters")), "parameterName", "parameterValue");
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateConfiguration(value);
        }

        public FormValidation doCheckPipelineName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Pipeline name");
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Project name");
        }

        public FormValidation doCheckAddParam(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillAddParamItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @QueryParameter String projectName, @QueryParameter String pipelineName, @QueryParameter String addParam, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                JSONObject json;
                JSONObject jsonArray;
                ListBoxModel m = new ListBoxModel();
                if (configuration.isEmpty() || pipelineName.isEmpty() || SelectFieldUtils.checkAnySelectItemsIsValidationWrappers(pipelineName)) {
                    m.add("{}");
                    return m;
                }
                HashMap<String, String> storedParams = new HashMap();
                String addParamValue = SelectFieldUtils.getSelectItemValue(addParam);
                if (!addParamValue.isEmpty() && !"{}".equals(addParamValue) && pipelineName.equals((jsonArray = (json = JSONObject.fromObject((Object)addParamValue)).getJSONObject("pipeline")).get("pipelineName"))) {
                    storedParams = DescriptorImpl.getParamsMapFromAddParam(addParamValue);
                }
                Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                ElectricFlowClient efClient = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                List<String> parameters = efClient.getPipelineFormalParameters(projectName, pipelineName);
                JSONObject main = JSONObject.fromObject((Object)("{'pipeline':{'pipelineName':'" + pipelineName + "','parameters':[]}}"));
                JSONArray ja = main.getJSONObject("pipeline").getJSONArray("parameters");
                Utils.addParametersToJsonAndPreserveStored(parameters, ja, "parameterName", "parameterValue", storedParams);
                m.add(main.toString());
                if (m.isEmpty()) {
                    m.add("{}");
                }
                return m;
            }
            catch (Exception e) {
                SelectItemValidationWrapper selectItemValidationWrapper;
                Credential overrideCredentialObj;
                ListBoxModel m = new ListBoxModel();
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching set of pipeline parameters. Error message: " + e.getMessage()), (Throwable)e);
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of pipeline parameters. Check the Jenkins logs for more details.", "{}");
                } else {
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of pipeline parameters. Connection to CloudBees CD Server Failed. Please fix connection information and reload this page.", "{}");
                }
                m.add(selectItemValidationWrapper.getJsonStr());
                return m;
            }
        }

        public ListBoxModel doFillConfigurationItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
            return Credential.DescriptorImpl.doFillCredentialIdItems(item);
        }

        public ListBoxModel doFillPipelineNameItems(@QueryParameter String projectName, @QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
            return Utils.getPipelines(configuration, overrideCredentialObj, projectName);
        }

        public ListBoxModel doFillProjectNameItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
            return Utils.getProjects(configuration, overrideCredentialObj);
        }

        public void doHelp(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            super.doHelp(req, rsp);
        }

        public FormValidation doTestConnection() {
            return FormValidation.ok((String)"Success");
        }

        public Configuration getConfigurationByName(String name) {
            return Utils.getConfigurationByName(name);
        }

        public List<Configuration> getConfigurations() {
            return Utils.getConfigurations();
        }

        public String getDisplayName() {
            return "CloudBees CD - Run Pipeline";
        }

        public String getId() {
            return "electricFlowSettings";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doShowOldValues(@QueryParameter(value="configuration") String configuration, @QueryParameter(value="projectName") String projectName, @QueryParameter(value="pipelineName") String pipelineName, @QueryParameter(value="addParam") String addParam, @QueryParameter(value="storedConfiguration") String storedConfiguration, @QueryParameter(value="storedProjectName") String storedProjectName, @QueryParameter(value="storedPipelineName") String storedPipelineName, @QueryParameter(value="storedAddParam") String storedAddParam, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            String configurationValue = configuration;
            String projectNameValue = SelectFieldUtils.getSelectItemValue(projectName);
            String pipelineNameValue = SelectFieldUtils.getSelectItemValue(pipelineName);
            String addParamValue = SelectFieldUtils.getSelectItemValue(addParam);
            Map<String, String> pipelineParamsMap = DescriptorImpl.getParamsMapFromAddParam(addParamValue);
            Map<String, String> storedPipelineParamsMap = DescriptorImpl.getParamsMapFromAddParam(storedAddParam);
            String comparisonTable = "<table>" + Utils.getValidationComparisonHeaderRow() + Utils.getValidationComparisonRow("Configuration", storedConfiguration, configurationValue) + Utils.getValidationComparisonRow("Project Name", storedProjectName, projectNameValue) + Utils.getValidationComparisonRow("Pipeline Name", storedPipelineName, pipelineNameValue) + Utils.getValidationComparisonRowsForExtraParameters("Pipeline Parameters", storedPipelineParamsMap, pipelineParamsMap) + "</table>";
            if (configurationValue.equals(storedConfiguration) && projectNameValue.equals(storedProjectName) && pipelineNameValue.equals(storedPipelineName) && pipelineParamsMap.equals(storedPipelineParamsMap)) {
                return FormValidation.okWithMarkup((String)("No changes detected:<br>" + comparisonTable));
            }
            return FormValidation.warningWithMarkup((String)("Changes detected:<br>" + comparisonTable));
        }
    }
}

