/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.electricflow.Credential;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.RunAndWaitOption;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.exceptions.FlowRuntimeException;
import org.jenkinsci.plugins.electricflow.exceptions.PluginException;
import org.jenkinsci.plugins.electricflow.factories.ElectricFlowClientFactory;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.CdJobStatus;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.GetJobStatusResponseData;
import org.jenkinsci.plugins.electricflow.ui.FieldValidationStatus;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectFieldUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectItemValidationWrapper;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElectricFlowDeployApplication
extends Recorder
implements SimpleBuildStep {
    private static final Log log = LogFactory.getLog(ElectricFlowDeployApplication.class);
    private String configuration;
    private Credential overrideCredential;
    private RunAndWaitOption runAndWaitOption;
    private String projectName;
    private String applicationName;
    private String applicationProcessName;
    private String environmentProjectName;
    private String environmentName;
    private String deployParameters;

    @DataBoundConstructor
    public ElectricFlowDeployApplication() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        Result result = this.runProcess(run, taskListener);
        if (result != Result.SUCCESS) {
            run.setResult(result);
        }
    }

    private Result runProcess(@Nonnull Run<?, ?> run, @Nonnull TaskListener taskListener) {
        PrintStream logger = taskListener.getLogger();
        logger.println("Application project name: " + this.projectName + ", Application name: " + this.applicationName + ", Application process name: " + this.applicationProcessName + ", Environment project name: " + this.environmentProjectName + ", Environment name: " + this.environmentName);
        JSONObject runProcess = JSONObject.fromObject((Object)this.deployParameters).getJSONObject("runProcess");
        JSONArray parameter = JSONArray.fromObject((Object)runProcess.getString("parameter"));
        try {
            logger.println("Preparing to run process...");
            EnvReplacer env = new EnvReplacer(run, taskListener);
            ElectricFlowClient efClient = ElectricFlowClientFactory.getElectricFlowClient(this.configuration, this.overrideCredential, run, env, false);
            Utils.expandParameters(parameter, env, "value");
            String result = efClient.runProcess(this.projectName, this.applicationName, this.applicationProcessName, this.environmentProjectName, this.environmentName, parameter);
            JSONObject process = efClient.getProcess(this.projectName, this.applicationName, this.applicationProcessName);
            if (process == null || process.isEmpty()) {
                throw new PluginException("Cannot find triggered deploy process");
            }
            String processId = process.getJSONObject("process").getString("processId");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("applicationName", this.applicationName);
            args.put("processName", this.applicationProcessName);
            args.put("processId", processId);
            args.put("result", result);
            args.put("applicationId", process.getJSONObject("process").getString("applicationId"));
            String summaryHtml = this.getSummaryHtml(efClient, parameter, args, null);
            SummaryTextAction action = new SummaryTextAction(run, summaryHtml);
            run.addAction((Action)action);
            run.save();
            logger.println("Deploy application result: " + Utils.formatJsonOutput(result));
            if (this.runAndWaitOption != null) {
                GetJobStatusResponseData responseData;
                int checkInterval = this.runAndWaitOption.getCheckInterval();
                logger.println("Waiting till CloudBees CD job is completed, checking every " + checkInterval + " seconds");
                String jobId = JSONObject.fromObject((Object)result).getString("jobId");
                do {
                    TimeUnit.SECONDS.sleep(checkInterval);
                    responseData = efClient.getCdJobStatus(jobId);
                    logger.println(responseData);
                    summaryHtml = this.getSummaryHtml(efClient, parameter, args, responseData);
                    action = new SummaryTextAction(run, summaryHtml);
                    run.addOrReplaceAction((Action)action);
                    run.save();
                    if (responseData.getStatus() != CdJobStatus.unknown) continue;
                    throw new PluginException("Unexpected format of CD job status response");
                } while (responseData.getStatus() != CdJobStatus.completed);
                logger.println("CD job completed with " + (Object)((Object)responseData.getOutcome()) + " outcome");
                if (this.runAndWaitOption.isDependOnCdJobOutcome()) {
                    Result ciBuildResult = Utils.getCorrespondedCiBuildResult(responseData.getOutcome());
                    if (!ciBuildResult.equals(Result.SUCCESS) && this.runAndWaitOption.isThrowExceptionIfFailed()) {
                        throw new FlowRuntimeException(responseData);
                    }
                    return ciBuildResult;
                }
            }
        }
        catch (IOException | InterruptedException | PluginException e) {
            logger.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.FAILURE;
        }
        return Result.SUCCESS;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @DataBoundSetter
    public void setApplicationName(String applicationName) {
        this.applicationName = SelectFieldUtils.getSelectItemValue(applicationName);
    }

    public String getStoredApplicationName() {
        return this.applicationName;
    }

    public String getApplicationProcessName() {
        return this.applicationProcessName;
    }

    @DataBoundSetter
    public void setApplicationProcessName(String applicationProcessName) {
        this.applicationProcessName = SelectFieldUtils.getSelectItemValue(applicationProcessName);
    }

    public String getStoredApplicationProcessName() {
        return this.applicationProcessName;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getStoredConfiguration() {
        return this.configuration;
    }

    public Credential getOverrideCredential() {
        return this.overrideCredential;
    }

    @DataBoundSetter
    public void setOverrideCredential(Credential overrideCredential) {
        this.overrideCredential = overrideCredential;
    }

    public RunAndWaitOption getRunAndWaitOption() {
        return this.runAndWaitOption;
    }

    @DataBoundSetter
    public void setRunAndWaitOption(RunAndWaitOption runAndWaitOption) {
        this.runAndWaitOption = runAndWaitOption;
    }

    public String getDeployParameters() {
        return this.deployParameters;
    }

    @DataBoundSetter
    public void setDeployParameters(String deployParameters) {
        this.deployParameters = SelectFieldUtils.getSelectItemValue(deployParameters);
    }

    public String getStoredDeployParameters() {
        return this.deployParameters;
    }

    public String getEnvironmentProjectName() {
        return this.environmentProjectName;
    }

    @DataBoundSetter
    public void setEnvironmentProjectName(String environmentProjectName) {
        this.environmentProjectName = SelectFieldUtils.getSelectItemValue(environmentProjectName);
    }

    public String getStoredEnvironmentProjectName() {
        return this.environmentProjectName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    @DataBoundSetter
    public void setEnvironmentName(String environmentName) {
        this.environmentName = SelectFieldUtils.getSelectItemValue(environmentName);
    }

    public String getStoredEnvironmentName() {
        return this.environmentName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = SelectFieldUtils.getSelectItemValue(projectName);
    }

    public String getStoredProjectName() {
        return this.projectName;
    }

    public boolean getValidationTrigger() {
        return true;
    }

    @DataBoundSetter
    public void setValidationTrigger(String validationTrigger) {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getSummaryHtml(ElectricFlowClient configuration, JSONArray parameters, Map<String, String> args, GetJobStatusResponseData getJobStatusResponseData) {
        String result = args.get("result");
        String applicationName = args.get("applicationName");
        String processId = args.get("processId");
        String jobId = JSONObject.fromObject((Object)result).getString("jobId");
        String applicationId = args.get("applicationId");
        String applicationUrl = configuration.getElectricFlowUrl() + "/flow/#applications/" + applicationId;
        String deployRunUrl = configuration.getElectricFlowUrl() + "/flow/#applications/" + processId + "/" + jobId + "/runningProcess";
        String summaryText = "<h3>CloudBees CD Deploy Application</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td>Application Name:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(applicationUrl) + "'>" + HtmlUtils.encodeForHtml(applicationName) + "</a></td>   \n  </tr>\n  <tr>\n    <td>Deploy run URL:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(deployRunUrl) + "'>" + HtmlUtils.encodeForHtml(deployRunUrl) + "</a></td>   \n  </tr>";
        summaryText = Utils.getParametersHTML(parameters, summaryText, "actualParameterName", "value");
        if (getJobStatusResponseData != null) {
            summaryText = summaryText + "  <tr>\n    <td>CD Job Status:</td>\n    <td>\n" + HtmlUtils.encodeForHtml(getJobStatusResponseData.getStatus().name()) + "    </td>\n  </tr>\n";
            summaryText = summaryText + "  <tr>\n    <td>CD Job Outcome:</td>\n    <td>\n" + HtmlUtils.encodeForHtml(getJobStatusResponseData.getOutcome().name()) + "    </td>\n  </tr>\n";
        }
        summaryText = summaryText + "</table>";
        return summaryText;
    }

    @Symbol(value={"cloudBeesFlowDeployApplication"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        static Map<String, String> getParamsMapFromDeployParams(String deployParameters) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (deployParameters == null || deployParameters.isEmpty() || deployParameters.equals("{}")) {
                return paramsMap;
            }
            JSONObject json = JSONObject.fromObject((Object)deployParameters);
            if (!json.containsKey((Object)"runProcess") || !json.getJSONObject("runProcess").containsKey((Object)"parameter")) {
                return paramsMap;
            }
            return Utils.getParamsMap(JSONArray.fromObject((Object)json.getJSONObject("runProcess").getString("parameter")), "actualParameterName", "value");
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateConfiguration(value);
        }

        public FormValidation doCheckDeployParameters(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Project name");
        }

        public FormValidation doCheckApplicationName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Application name");
        }

        public FormValidation doCheckApplicationProcessName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Application process name");
        }

        public FormValidation doCheckEnvironmentProjectName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvironmentName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Environment name");
        }

        public ListBoxModel doFillApplicationNameItems(@QueryParameter String projectName, @QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select application", "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName)) {
                    Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                    ElectricFlowClient client = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                    List<String> applications = client.getApplications(projectName);
                    for (String application : applications) {
                        m.add(application);
                    }
                }
                return m;
            }
            catch (Exception e) {
                Credential overrideCredentialObj;
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching values for this parameter - application. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select application");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select application");
            }
        }

        public ListBoxModel doFillApplicationProcessNameItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @QueryParameter String projectName, @QueryParameter String applicationName, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select application process", "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && !applicationName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName, applicationName)) {
                    Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                    ElectricFlowClient client = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                    List<String> processes = client.getProcesses(projectName, applicationName);
                    for (String process : processes) {
                        m.add(process);
                    }
                }
                return m;
            }
            catch (Exception e) {
                Credential overrideCredentialObj;
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching values for this parameter - application process. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select application process");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select application process");
            }
        }

        public ListBoxModel doFillConfigurationItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
            return Credential.DescriptorImpl.doFillCredentialIdItems(item);
        }

        public ListBoxModel doFillDeployParametersItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @QueryParameter String projectName, @QueryParameter String applicationName, @QueryParameter String applicationProcessName, @QueryParameter String deployParameters, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                JSONObject json;
                JSONObject jsonArray;
                ListBoxModel m = new ListBoxModel();
                if (configuration.isEmpty() || projectName.isEmpty() || applicationName.isEmpty() || applicationProcessName.isEmpty() || !SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName, applicationName, applicationProcessName)) {
                    m.add("{}");
                    return m;
                }
                Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                ElectricFlowClient client = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                HashMap<String, String> storedParams = new HashMap();
                String deployParametersValue = SelectFieldUtils.getSelectItemValue(deployParameters);
                if (!deployParametersValue.isEmpty() && !"{}".equals(deployParametersValue) && applicationName.equals((jsonArray = (json = JSONObject.fromObject((Object)deployParametersValue)).getJSONObject("runProcess")).get("applicationName")) && applicationProcessName.equals(jsonArray.get("applicationProcessName"))) {
                    storedParams = DescriptorImpl.getParamsMapFromDeployParams(deployParametersValue);
                }
                List<String> parameters = client.getFormalParameters(projectName, applicationName, applicationProcessName);
                JSONObject main = JSONObject.fromObject((Object)("{'runProcess':{'applicationName':'" + applicationName + "', 'applicationProcessName':'" + applicationProcessName + "',   'parameter':[]}}"));
                JSONArray ja = main.getJSONObject("runProcess").getJSONArray("parameter");
                Utils.addParametersToJsonAndPreserveStored(parameters, ja, "actualParameterName", "value", storedParams);
                m.add(main.toString());
                if (m.isEmpty()) {
                    m.add("{}");
                }
                return m;
            }
            catch (Exception e) {
                SelectItemValidationWrapper selectItemValidationWrapper;
                Credential overrideCredentialObj;
                ListBoxModel m = new ListBoxModel();
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching set of deploy parameters. Error message: " + e.getMessage()), (Throwable)e);
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of deploy parameters. Check the Jenkins logs for more details.", "{}");
                } else {
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of deploy parameters. Connection to CloudBees CD Server Failed. Please fix connection information and reload this page.", "{}");
                }
                m.add(selectItemValidationWrapper.getJsonStr());
                return m;
            }
        }

        public ListBoxModel doFillEnvironmentProjectNameItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
            return Utils.getProjects(configuration, overrideCredentialObj);
        }

        public ListBoxModel doFillEnvironmentNameItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @QueryParameter String projectName, @QueryParameter String environmentProjectName, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                String actualEnvironmentProjectName;
                ListBoxModel m = new ListBoxModel();
                m.add("Select environment", "");
                String string = actualEnvironmentProjectName = environmentProjectName != null && !environmentProjectName.isEmpty() && !SelectFieldUtils.isSelectItemValidationWrapper(environmentProjectName) ? environmentProjectName : projectName;
                if (!configuration.isEmpty() && !actualEnvironmentProjectName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(actualEnvironmentProjectName)) {
                    Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                    ElectricFlowClient client = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                    List<String> environments = client.getEnvironments(actualEnvironmentProjectName);
                    for (String environment : environments) {
                        m.add(environment);
                    }
                }
                return m;
            }
            catch (Exception e) {
                Credential overrideCredentialObj;
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching values for this parameter - environment. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select environment");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select environment");
            }
        }

        public ListBoxModel doFillProjectNameItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
            return Utils.getProjects(configuration, overrideCredentialObj);
        }

        public String getDisplayName() {
            return "CloudBees CD - Deploy Application";
        }

        public String getId() {
            return "electricFlowDeployApplication";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doShowOldValues(@QueryParameter(value="configuration") String configuration, @QueryParameter(value="projectName") String projectName, @QueryParameter(value="applicationName") String applicationName, @QueryParameter(value="applicationProcessName") String applicationProcessName, @QueryParameter(value="environmentProjectName") String environmentProjectName, @QueryParameter(value="environmentName") String environmentName, @QueryParameter(value="deployParameters") String deployParameters, @QueryParameter(value="storedConfiguration") String storedConfiguration, @QueryParameter(value="storedProjectName") String storedProjectName, @QueryParameter(value="storedApplicationName") String storedApplicationName, @QueryParameter(value="storedApplicationProcessName") String storedApplicationProcessName, @QueryParameter(value="storedEnvironmentProjectName") String storedEnvironmentProjectName, @QueryParameter(value="storedEnvironmentName") String storedEnvironmentName, @QueryParameter(value="storedDeployParameters") String storedDeployParameters, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            String configurationValue = configuration;
            String projectNameValue = SelectFieldUtils.getSelectItemValue(projectName);
            String applicationNameValue = SelectFieldUtils.getSelectItemValue(applicationName);
            String applicationProcessNameValue = SelectFieldUtils.getSelectItemValue(applicationProcessName);
            String environmentProjectNameValue = SelectFieldUtils.getSelectItemValue(environmentProjectName);
            String environmentNameValue = SelectFieldUtils.getSelectItemValue(environmentName);
            String deployParametersValue = SelectFieldUtils.getSelectItemValue(deployParameters);
            Map<String, String> deployParamsMap = DescriptorImpl.getParamsMapFromDeployParams(deployParametersValue);
            Map<String, String> storedDeployParamsMap = DescriptorImpl.getParamsMapFromDeployParams(storedDeployParameters);
            String comparisonTable = "<table>" + Utils.getValidationComparisonHeaderRow() + Utils.getValidationComparisonRow("Configuration", storedConfiguration, configurationValue) + Utils.getValidationComparisonRow("Application Project Name", storedProjectName, projectNameValue) + Utils.getValidationComparisonRow("Application Name", storedApplicationName, applicationNameValue) + Utils.getValidationComparisonRow("Application Process Name", storedApplicationProcessName, applicationProcessNameValue) + Utils.getValidationComparisonRow("Environment Project Name", storedEnvironmentProjectName, environmentProjectNameValue) + Utils.getValidationComparisonRow("Environment Name", storedEnvironmentName, environmentNameValue) + Utils.getValidationComparisonRowsForExtraParameters("Deploy Parameters", storedDeployParamsMap, deployParamsMap) + "</table>";
            if (configurationValue.equals(storedConfiguration) && projectNameValue.equals(storedProjectName) && applicationNameValue.equals(storedApplicationName) && applicationProcessNameValue.equals(storedApplicationProcessName) && environmentProjectNameValue.equals(storedEnvironmentProjectName) && environmentNameValue.equals(storedEnvironmentName) && deployParamsMap.equals(storedDeployParamsMap)) {
                return FormValidation.okWithMarkup((String)("No changes detected:<br>" + comparisonTable));
            }
            return FormValidation.warningWithMarkup((String)("Changes detected:<br>" + comparisonTable));
        }
    }
}

