/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.Configuration;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.FileHelper;
import org.jenkinsci.plugins.electricflow.HttpMethod;
import org.jenkinsci.plugins.electricflow.MultipartUtility;
import org.jenkinsci.plugins.electricflow.Pair;
import org.jenkinsci.plugins.electricflow.Release;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.models.CIBuildDetail;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.GetJobStatusResponseData;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.GetPipelineRuntimeDetailsResponseData;

public class ElectricFlowClient {
    private static final Log log = LogFactory.getLog(ElectricFlowClient.class);
    private static final String CHARSET = "UTF-8";
    private String electricFlowUrl;
    private String userName;
    private String password;
    private String apiVersion;
    private boolean ignoreSslConnectionErrors;
    private List<Release> releasesList = new ArrayList<Release>();
    private EnvReplacer envReplacer;

    public ElectricFlowClient(String configurationName, EnvReplacer envReplacer) {
        this(configurationName);
        this.envReplacer = envReplacer;
    }

    @Deprecated
    public ElectricFlowClient(String configurationName, String workspaceDir) {
        this(configurationName);
    }

    public ElectricFlowClient(String configurationName) {
        Configuration cred = Utils.getConfigurationByName(configurationName);
        if (cred != null) {
            this.electricFlowUrl = cred.getElectricFlowUrl();
            this.userName = cred.getElectricFlowUser();
            this.password = cred.getElectricFlowPassword().getPlainText();
            this.ignoreSslConnectionErrors = cred.getIgnoreSslConnectionErrors();
            String electricFlowApiVersion = cred.getElectricFlowApiVersion();
            this.apiVersion = electricFlowApiVersion != null ? electricFlowApiVersion : "";
        }
    }

    public ElectricFlowClient(String url, String name, String password, String apiVersion, boolean ignoreSslConnectionErrors) {
        this.electricFlowUrl = url;
        this.userName = name;
        this.password = password;
        this.apiVersion = apiVersion;
        this.ignoreSslConnectionErrors = ignoreSslConnectionErrors;
        if (this.userName.isEmpty() || password.isEmpty()) {
            log.warn((Object)"User name and password should not be empty.");
        }
    }

    public String deployApplicationPackage(String group, String key, String version, String file) throws IOException {
        String requestEndpoint = "/createApplicationFromDeploymentPackage?request=createApplicationFromDeploymentPackage";
        JSONObject obj = new JSONObject();
        obj.put("artifactFileName", (Object)file);
        obj.put("artifactVersion", (Object)version);
        obj.put("artifactKey", (Object)key);
        obj.put("artifactGroup", (Object)group);
        return this.runRestAPI(requestEndpoint, HttpMethod.POST, obj.toString());
    }

    public String runPipeline(String projectName, String pipelineName) throws IOException {
        String requestEndpoint = "/pipelines?pipelineName=" + Utils.encodeURL(pipelineName) + "&projectName=" + Utils.encodeURL(projectName);
        return this.runRestAPI(requestEndpoint, HttpMethod.POST);
    }

    public String runPipeline(String projectName, String pipelineName, JSONArray additionalOptions) throws IOException {
        JSONObject obj = new JSONObject();
        JSONArray parameters = this.getParameters(additionalOptions, "actualParameterName", "parameterName", "parameterValue");
        obj.put("actualParameter", (Object)parameters);
        obj.put("pipelineName", (Object)pipelineName);
        obj.put("projectName", (Object)projectName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed JSON is: " + obj.toString()));
        }
        String requestEndpoint = "/pipelines";
        return this.runRestAPI(requestEndpoint, HttpMethod.POST, obj.toString());
    }

    public String runProcess(String projectName, String applicationName, String processName, String environmentProjectName, String environmentName, JSONArray actualParameters) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("projectName", (Object)projectName);
        obj.put("applicationName", (Object)applicationName);
        obj.put("processName", (Object)processName);
        if (environmentProjectName != null && !environmentProjectName.isEmpty()) {
            obj.put("environmentProjectName", (Object)environmentProjectName);
        }
        obj.put("environmentName", (Object)environmentName);
        obj.put("actualParameter", (Object)this.getParameters(actualParameters, "actualParameterName", "actualParameterName", "value"));
        String requestEndpoint = "/jobs?request=runProcess";
        return this.runRestAPI(requestEndpoint, HttpMethod.POST, obj.toString());
    }

    public String runProcedure(String projectName, String procedureName, JSONArray actualParameters) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("projectName", (Object)projectName);
        obj.put("procedureName", (Object)procedureName);
        obj.put("actualParameter", (Object)this.getParameters(actualParameters, "actualParameterName", "actualParameterName", "value"));
        String requestEndpoint = "/jobs?request=runProcedure";
        return this.runRestAPI(requestEndpoint, HttpMethod.POST, obj.toString());
    }

    public String runRelease(String projectName, String releaseName, List stagesToRun, String startingStage, JSONArray pipelineParameters) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("releaseName", (Object)releaseName);
        obj.put("projectName", (Object)projectName);
        if (!startingStage.isEmpty()) {
            obj.put("startingStage", (Object)startingStage);
        } else {
            obj.put("stagesToRun", (Object)stagesToRun);
        }
        obj.put("pipelineParameter", (Object)this.getParameters(pipelineParameters, "pipelineParameterName", "parameterName", "parameterValue"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed JSON is: " + obj.toString()));
        }
        String requestEndpoint = "/releases";
        return this.runRestAPI(requestEndpoint, HttpMethod.POST, obj.toString());
    }

    public String runRestAPI(String urlPath, HttpMethod httpMethod) throws IOException {
        return this.runRestAPI(urlPath, httpMethod, "", new ArrayList<Pair>(0));
    }

    public String runRestAPI(String urlPath, HttpMethod httpMethod, String body) throws IOException {
        return this.runRestAPI(urlPath, httpMethod, body, new ArrayList<Pair>(0));
    }

    /*
     * Exception decompiling
     */
    public String runRestAPI(String urlPath, HttpMethod httpMethod, String body, List<Pair> parameters) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JSONObject attachCIBuildDetails(CIBuildDetail details) throws IOException {
        String endpoint = "/ciBuildDetails?request=setCiBuildDetail";
        String result = this.runRestAPI(endpoint, HttpMethod.POST, details.toJsonObject().toString());
        return JSONObject.fromObject((Object)result);
    }

    public String uploadArtifact(Run<?, ?> build, TaskListener listener, String repo, String name, String version, String path, boolean uploadDirectory, FilePath workspace) throws IOException, KeyManagementException, NoSuchAlgorithmException, InterruptedException {
        PrintStream logger = listener.getLogger();
        List<File> fileList = FileHelper.getFilesFromDirectoryWildcard(build, listener, workspace, path, true, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("File path: " + path));
        }
        String uploadWorkspace = FileHelper.getPublishArtifactWorkspaceOnMaster(build).getRemote();
        logger.println("Uploading artifact to the repository");
        String result = this.uploadArtifact(fileList, uploadWorkspace, repo, name, version, uploadDirectory);
        logger.println("Upload result: " + result);
        try {
            FileHelper.removeTempDirectory(build);
            logger.println("Removed temporary directory " + uploadWorkspace);
        }
        catch (IOException ex) {
            logger.println("Failed to remove the temporary directory " + uploadWorkspace + "\n" + ex.getMessage());
        }
        return result;
    }

    public String uploadArtifact(List<File> fileList, String uploadWorkspace, String repo, String name, String version, boolean uploadDirectory) throws IOException, KeyManagementException, NoSuchAlgorithmException, InterruptedException {
        String sessionId = this.getSessionId();
        String requestURL = this.electricFlowUrl + "/commander/cgi-bin/publishArtifactAPI.cgi";
        MultipartUtility multipart = new MultipartUtility(requestURL, CHARSET, this.getIgnoreSslConnectionErrors());
        multipart.addFormField("artifactName", name);
        multipart.addFormField("artifactVersionVersion", version);
        multipart.addFormField("repositoryName", repo);
        multipart.addFormField("compress", "1");
        multipart.addFormField("commanderSessionId", sessionId);
        for (File file : fileList) {
            if (file.isDirectory()) {
                if (!uploadDirectory) continue;
                List<File> dirFiles = FileHelper.getFilesFromDirectory(file);
                for (File f : dirFiles) {
                    multipart.addFilePart("files", f, uploadWorkspace);
                }
                continue;
            }
            multipart.addFilePart("files", file, uploadWorkspace);
        }
        List<String> response = multipart.finish();
        String resultLine = "";
        for (String line : response) {
            resultLine = resultLine + line;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Response: " + line));
        }
        return resultLine;
    }

    private String expandVariable(String var) {
        return this.envReplacer != null ? this.envReplacer.expandEnv(var) : var;
    }

    public List<String> getApplications(String projectName) throws IOException {
        String endpoint = "/projects/" + Utils.encodeURL(projectName) + "/applications";
        String jsonResult = this.runRestAPI(endpoint, HttpMethod.GET);
        ArrayList<String> result = new ArrayList<String>();
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonResult);
        if (jsonObject.isEmpty() || !jsonObject.containsKey((Object)"application") || !(jsonObject.get("application") instanceof JSONArray)) {
            return result;
        }
        JSONArray application = jsonObject.getJSONArray("application");
        for (int i = 0; i < application.size(); ++i) {
            JSONObject applicationObject = application.getJSONObject(i);
            String applicationName = applicationObject.getString("applicationName");
            result.add(applicationName);
        }
        return result;
    }

    public List<String> getProcedures(String projectName) throws IOException {
        String endpoint = "/projects/" + Utils.encodeURL(projectName) + "/procedures";
        String jsonResult = this.runRestAPI(endpoint, HttpMethod.GET);
        ArrayList<String> result = new ArrayList<String>();
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonResult);
        if (jsonObject.isEmpty() || !jsonObject.containsKey((Object)"procedure") || !(jsonObject.get("procedure") instanceof JSONArray)) {
            return result;
        }
        JSONArray procedure = jsonObject.getJSONArray("procedure");
        for (int i = 0; i < procedure.size(); ++i) {
            JSONObject procedureObject = procedure.getJSONObject(i);
            String procedureName = procedureObject.getString("procedureName");
            result.add(procedureName);
        }
        return result;
    }

    public List<String> getArtifactRepositories() throws Exception {
        String requestEndpoint = "/repositories";
        String result = this.runRestAPI(requestEndpoint, HttpMethod.GET);
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        JSONArray arr = jsonObject.getJSONArray("repository");
        ArrayList<String> repositories = new ArrayList<String>();
        for (int i = 0; i < arr.size(); ++i) {
            String repositoryName = arr.getJSONObject(i).getString("repositoryName");
            repositories.add(repositoryName);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Repository name: " + repositoryName));
        }
        return repositories;
    }

    private HttpsURLConnection getConnection(String endpoint) throws IOException {
        URL url = new URL(this.electricFlowUrl + endpoint);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint: " + url.toString()));
        }
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        String authString = this.userName + ":" + this.password;
        byte[] encodedBytes = Base64.encodeBase64((byte[])authString.getBytes(CHARSET));
        String encoded = new String(encodedBytes, StandardCharsets.UTF_8);
        conn.setRequestProperty("Authorization", "Basic " + encoded);
        conn.setRequestProperty("Accept", "application/json");
        return conn;
    }

    public String getElectricFlowUrl() {
        return this.electricFlowUrl;
    }

    private boolean getIgnoreSslConnectionErrors() {
        return this.ignoreSslConnectionErrors;
    }

    public List<String> getEnvironments(String projectName) throws IOException {
        String endpoint = "/projects/" + Utils.encodeURL(projectName) + "/environments";
        String jsonResult = this.runRestAPI(endpoint, HttpMethod.GET);
        ArrayList<String> result = new ArrayList<String>();
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonResult);
        if (jsonObject.isEmpty() || !jsonObject.containsKey((Object)"environment") || !(jsonObject.get("environment") instanceof JSONArray)) {
            return result;
        }
        JSONArray environments = jsonObject.getJSONArray("environment");
        for (int i = 0; i < environments.size(); ++i) {
            JSONObject environmentObject = environments.getJSONObject(i);
            String environment = environmentObject.getString("environmentName");
            result.add(environment);
        }
        return result;
    }

    public List<String> getFormalParameters(String projectName, String applicationName, String applicationProcessName) throws IOException {
        String endpoint = "/projects/" + Utils.encodeURL(projectName) + "/applications/" + Utils.encodeURL(applicationName) + "/processes/" + Utils.encodeURL(applicationProcessName) + "/formalParameters";
        String jsonResult = this.runRestAPI(endpoint, HttpMethod.GET);
        ArrayList<String> result = new ArrayList<String>();
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonResult);
        if (jsonObject.isEmpty()) {
            return result;
        }
        JSONArray environments = jsonObject.getJSONArray("formalParameter");
        for (int i = 0; i < environments.size(); ++i) {
            JSONObject environmentObject = environments.getJSONObject(i);
            String expansionDeferred = environmentObject.getString("expansionDeferred");
            if (!"0".equals(expansionDeferred)) continue;
            String parameterName = environmentObject.getString("formalParameterName");
            result.add(parameterName);
        }
        return result;
    }

    public List<String> getProcedureFormalParameters(String projectName, String procedureName) throws IOException {
        String endpoint = "/projects/" + Utils.encodeURL(projectName) + "/procedures/" + Utils.encodeURL(procedureName) + "/formalParameters";
        String jsonResult = this.runRestAPI(endpoint, HttpMethod.GET);
        ArrayList<String> result = new ArrayList<String>();
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonResult);
        if (jsonObject.isEmpty() || !jsonObject.containsKey((Object)"formalParameter") || !(jsonObject.get("formalParameter") instanceof JSONArray)) {
            return result;
        }
        JSONArray environments = jsonObject.getJSONArray("formalParameter");
        for (int i = 0; i < environments.size(); ++i) {
            JSONObject environmentObject = environments.getJSONObject(i);
            String expansionDeferred = environmentObject.getString("expansionDeferred");
            if (!"0".equals(expansionDeferred)) continue;
            String parameterName = environmentObject.getString("formalParameterName");
            result.add(parameterName);
        }
        return result;
    }

    private JSONArray getParameters(JSONArray parameters, String argumentName, String parameterName, String parameterValue) {
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < parameters.size(); ++i) {
            JSONObject param = parameters.getJSONObject(i);
            String parName = param.getString(parameterName);
            String parValue = param.getString(parameterValue);
            JSONObject inner = new JSONObject();
            inner.put(argumentName, (Object)parName);
            inner.put("value", (Object)this.expandVariable(parValue));
            jsonArray.add((Object)inner);
        }
        return jsonArray;
    }

    public List<String> getPipelineFormalParameters(String projectName, String pipelineName) throws Exception {
        ArrayList<String> formalParameters = new ArrayList<String>();
        String pipelineId = this.getPipelineId(projectName, pipelineName);
        if (!pipelineId.isEmpty()) {
            return this.getPipelineFormalParameters(pipelineId);
        }
        return formalParameters;
    }

    public List<String> getPipelineFormalParameters(String pipelineId) throws Exception {
        ArrayList<String> formalParameters = new ArrayList<String>();
        String requestEndpoint = "/objects?request=findObjects";
        JSONObject obj = new JSONObject();
        JSONObject filter = new JSONObject();
        filter.put("operator", (Object)"equals");
        filter.put("propertyName", (Object)"container");
        filter.put("operand1", (Object)("pipeline-" + pipelineId));
        obj.put("filter", (Object)filter);
        obj.put("objectType", (Object)"formalParameter");
        String result = this.runRestAPI(requestEndpoint, HttpMethod.PUT, obj.toString());
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        if (jsonObject.isEmpty() || !jsonObject.containsKey((Object)"object") || !(jsonObject.get("object") instanceof JSONArray)) {
            return formalParameters;
        }
        JSONArray arr = jsonObject.getJSONArray("object");
        for (int i = 0; i < arr.size(); ++i) {
            String parameterName = arr.getJSONObject(i).getJSONObject("formalParameter").getString("formalParameterName");
            if (parameterName.equals("ec_stagesToRun")) continue;
            formalParameters.add(parameterName);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Formal parameter: " + parameterName));
        }
        return formalParameters;
    }

    public String getPipelineId(String projectName, String pipelineName) throws Exception {
        String requestEndpoint = "/objects?request=findObjects";
        JSONObject obj = new JSONObject();
        JSONObject filterTop = new JSONObject();
        JSONArray filters = new JSONArray();
        JSONObject filterPerProject = new JSONObject();
        JSONObject filterPerPipeline = new JSONObject();
        filterPerProject.put("operator", (Object)"equals");
        filterPerProject.put("propertyName", (Object)"projectName");
        filterPerProject.put("operand1", (Object)projectName);
        filterPerPipeline.put("operator", (Object)"equals");
        filterPerPipeline.put("propertyName", (Object)"pipelineName");
        filterPerPipeline.put("operand1", (Object)pipelineName);
        filters.add((Object)filterPerProject);
        filters.add((Object)filterPerPipeline);
        filterTop.put("operator", (Object)"and");
        filterTop.put("filter", (Object)filters);
        obj.put("filter", (Object)filterTop);
        obj.put("objectType", (Object)"pipeline");
        String result = this.runRestAPI(requestEndpoint, HttpMethod.PUT, obj.toString());
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        if (jsonObject.isEmpty() || !jsonObject.containsKey((Object)"object") || !(jsonObject.get("object") instanceof JSONArray)) {
            return "";
        }
        JSONArray arr = jsonObject.getJSONArray("object");
        for (int i = 0; i < arr.size(); ++i) {
            String pipelineName2 = arr.getJSONObject(i).getJSONObject("pipeline").getString("pipelineName");
            String pipelineId = arr.getJSONObject(i).getJSONObject("pipeline").getString("pipelineId");
            if (!pipelineName.equals(pipelineName2)) continue;
            return pipelineId;
        }
        return "";
    }

    public String getPipelines(String projectName) throws IOException {
        String requestEndpoint = "/projects/" + Utils.encodeURL(projectName) + "/pipelines";
        return this.runRestAPI(requestEndpoint, HttpMethod.GET);
    }

    public JSONObject getProcess(String projectName, String applicationName, String processName) throws IOException {
        String endpoint = "/projects/" + Utils.encodeURL(projectName) + "/applications/" + Utils.encodeURL(applicationName) + "/processes/" + Utils.encodeURL(processName);
        String jsonResult = this.runRestAPI(endpoint, HttpMethod.GET);
        return JSONObject.fromObject((Object)jsonResult);
    }

    public List<String> getProcesses(String projectName, String applicationName) throws IOException {
        String endpoint = "/projects/" + Utils.encodeURL(projectName) + "/applications/" + Utils.encodeURL(applicationName) + "/processes";
        String jsonResult = this.runRestAPI(endpoint, HttpMethod.GET);
        ArrayList<String> result = new ArrayList<String>();
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonResult);
        if (jsonObject.isEmpty() || !jsonObject.containsKey((Object)"process") || !(jsonObject.get("process") instanceof JSONArray)) {
            return result;
        }
        JSONArray processes = jsonObject.getJSONArray("process");
        for (int i = 0; i < processes.size(); ++i) {
            JSONObject applicationObject = processes.getJSONObject(i);
            String process = applicationObject.getString("processName");
            result.add(process);
        }
        return result;
    }

    public String getProjects() throws IOException {
        String requestEndpoint = "/projects";
        return this.runRestAPI(requestEndpoint, HttpMethod.GET);
    }

    public Release getRelease(String configuration, String projectName, String releaseName) throws Exception {
        Release cachedResult = this.getCachedRelease(configuration, projectName, releaseName);
        if (cachedResult != null) {
            return cachedResult;
        }
        this.getReleases(configuration, projectName);
        return this.getCachedRelease(configuration, projectName, releaseName);
    }

    private Release getCachedRelease(String configuration, String projectName, String releaseName) {
        for (Release release : this.releasesList) {
            if (!release.getConfiguration().equals(configuration) || !release.getProjectName().equals(projectName) || !release.getReleaseName().equals(releaseName)) continue;
            return release;
        }
        return null;
    }

    public List<String> getReleaseNames(String configuration, String projectName) throws Exception {
        if (this.releasesList.size() == 0) {
            this.getReleases(configuration, projectName);
        }
        return this.releasesList.stream().filter(release -> release.getConfiguration().equals(configuration) && release.getProjectName().equals(projectName)).map(Release::getReleaseName).collect(Collectors.toList());
    }

    public List<Map<String, Object>> getReleaseRuns(String conf, String projectName, String releaseName) throws Exception {
        Release release = this.getRelease(conf, projectName, releaseName);
        String pipelineName = release.getPipelineName();
        String requestEndpoint = "/projects/" + Utils.encodeURL(projectName) + "/pipelines/" + Utils.encodeURL(pipelineName);
        requestEndpoint = requestEndpoint + "?request=getPipelineRuntimes&releaseId=" + release.getReleaseId();
        String responseString = this.runRestAPI(requestEndpoint, HttpMethod.PUT);
        try {
            JSONObject response = JSONObject.fromObject((Object)responseString);
            if (!response.containsKey((Object)"flowRuntime") || !(response.get("flowRuntime") instanceof JSONArray)) {
                return new ArrayList<Map<String, Object>>(0);
            }
            JSONArray flowRuntimes = response.getJSONArray("flowRuntime");
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < flowRuntimes.size(); ++i) {
                result.add((Map<String, Object>)flowRuntimes.getJSONObject(i));
            }
            return result;
        }
        catch (RuntimeException ex) {
            log.error((Object)("Failed to parse Flow server response:" + ex.getMessage()));
            return null;
        }
    }

    public List<String> getReleases(String conf, String projectName) throws Exception {
        this.releasesList.clear();
        String requestEndpoint = "/projects/" + Utils.encodeURL(projectName) + "/releases";
        String result = this.runRestAPI(requestEndpoint, HttpMethod.GET);
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        if (jsonObject.isEmpty() || !jsonObject.containsKey((Object)"release") || !(jsonObject.get("release") instanceof JSONArray)) {
            return new ArrayList<String>(0);
        }
        JSONArray releases = jsonObject.getJSONArray("release");
        for (int i = 0; i < releases.size(); ++i) {
            JSONArray stagesArray;
            JSONObject stages;
            JSONObject releaseObject = releases.getJSONObject(i);
            String gotReleaseId = releaseObject.getString("releaseId");
            String gotReleaseName = releaseObject.getString("releaseName");
            String gotPipelineName = releaseObject.getString("pipelineName");
            String gotPipelineId = releaseObject.getString("pipelineId");
            Release release = new Release(conf, projectName, gotReleaseName);
            release.setPipelineName(gotPipelineName);
            release.setPipelineId(gotPipelineId);
            release.setPipelineParameters(this.getPipelineFormalParameters(gotPipelineId));
            release.setReleaseId(gotReleaseId);
            if (releaseObject.containsKey((Object)"flowRuntimeId")) {
                release.setFlowRuntimeId(releaseObject.getString("flowRuntimeId"));
            }
            if (!(stages = releaseObject.getJSONObject("stages")).isEmpty() && (stagesArray = stages.getJSONArray("stage")) != null && !stagesArray.isEmpty()) {
                ArrayList<String> stagesList = new ArrayList<String>();
                for (int j = 0; j < stagesArray.size(); ++j) {
                    String stageName = stagesArray.getJSONObject(j).getString("name");
                    if (stagesList.contains(stageName)) continue;
                    stagesList.add(stageName);
                }
                release.setStartStages(stagesList);
            }
            this.releasesList.add(release);
        }
        return this.getReleaseNames(conf, projectName);
    }

    public void testConnection() throws IOException {
        this.getSessionId();
    }

    public String getSessionId() throws IOException {
        String requestEndpoint = "/sessions";
        JSONObject requestObject = new JSONObject();
        requestObject.put("userName", (Object)this.userName);
        requestObject.put("password", (Object)this.password);
        String result = this.runRestAPI(requestEndpoint, HttpMethod.POST, requestObject.toString());
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        return jsonObject.getString("sessionId");
    }

    public GetJobStatusResponseData getCdJobStatus(String cdJobId) throws IOException {
        String requestEndpoint = "/jobs/" + cdJobId + "?request=getJobStatus";
        String result = this.runRestAPI(requestEndpoint, HttpMethod.GET);
        GetJobStatusResponseData getJobStatusResponseData = (GetJobStatusResponseData)new ObjectMapper().enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).readValue(result, GetJobStatusResponseData.class);
        getJobStatusResponseData.setContent(result);
        return getJobStatusResponseData;
    }

    public GetPipelineRuntimeDetailsResponseData getCdPipelineRuntimeDetails(String flowRuntimeId) throws IOException {
        String requestEndpoint = "/pipelineRuntimeDetails?request=getPipelineRuntimeDetails";
        String result = this.runRestAPI(requestEndpoint, HttpMethod.PUT, "{\"flowRuntimeId\":[\"" + flowRuntimeId + "\"]}");
        GetPipelineRuntimeDetailsResponseData getPipelineRuntimeDetailsResponseData = (GetPipelineRuntimeDetailsResponseData)new ObjectMapper().enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).readValue(JSONObject.fromObject((Object)result).getJSONArray("flowRuntime").getJSONObject(0).toString(), GetPipelineRuntimeDetailsResponseData.class);
        getPipelineRuntimeDetailsResponseData.setContent(result);
        return getPipelineRuntimeDetailsResponseData;
    }
}

