/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.electricflow.Credential;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.Release;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.action.CloudBeesCDPBABuildDetails;
import org.jenkinsci.plugins.electricflow.data.CloudBeesFlowBuildData;
import org.jenkinsci.plugins.electricflow.factories.ElectricFlowClientFactory;
import org.jenkinsci.plugins.electricflow.models.CIBuildDetail;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectFieldUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElectricFlowAssociateBuildToRelease
extends Recorder
implements SimpleBuildStep {
    private static final Log log = LogFactory.getLog(ElectricFlowAssociateBuildToRelease.class);
    private String configuration;
    private Credential overrideCredential;
    private String projectName;
    private String releaseName;
    private String flowRuntimeId;

    @DataBoundConstructor
    public ElectricFlowAssociateBuildToRelease() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) {
        try {
            CloudBeesFlowBuildData cloudBeesFlowBuildData = new CloudBeesFlowBuildData(run);
            EnvReplacer env = new EnvReplacer(run, taskListener);
            ElectricFlowClient efClient = ElectricFlowClientFactory.getElectricFlowClient(this.configuration, this.overrideCredential, env);
            PrintStream logger = taskListener.getLogger();
            this.setJenkinsBuildDetails(efClient, cloudBeesFlowBuildData, logger);
            Release release = efClient.getRelease(this.configuration, this.projectName, this.releaseName);
            if (release == null) {
                throw new RuntimeException("No release was found for parameters:\n configuration: '" + this.configuration + "'\n projectName: '" + this.projectName + "'\n releaseName: '" + this.releaseName + "'\n");
            }
            LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
            args.put("releaseName", this.releaseName);
            args.put("buildName", cloudBeesFlowBuildData.getDisplayName());
            args.put("releaseId", release.getReleaseId());
            if (this.flowRuntimeId != null && !this.flowRuntimeId.equals("")) {
                args.put("flowRuntimeId", this.flowRuntimeId);
            } else {
                args.put("flowRuntimeId", release.getFlowRuntimeId());
            }
            try {
                CloudBeesCDPBABuildDetails.applyToRuntime(run, this.configuration, this.overrideCredential, this.flowRuntimeId, null, this.projectName, this.releaseName, null, CIBuildDetail.BuildTriggerSource.CI, CIBuildDetail.BuildAssociationType.ATTACHED);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            run.addAction((Action)new SummaryTextAction(run, this.getSummaryHtml(efClient, args, logger)));
            run.setResult(Result.SUCCESS);
            run.save();
        }
        catch (Exception ex) {
            taskListener.getLogger().println("Failed to associate build to release: " + ex.toString());
            ex.printStackTrace();
            run.setResult(Result.FAILURE);
        }
    }

    private JSONObject setJenkinsBuildDetails(ElectricFlowClient efClient, CloudBeesFlowBuildData cloudBeesFlowBuildData, PrintStream logger) throws IOException {
        logger.println("JENKINS VERSION: " + Jenkins.VERSION);
        logger.println("Project name: " + this.projectName + ", Release name: " + this.releaseName);
        CIBuildDetail detail = new CIBuildDetail(cloudBeesFlowBuildData, this.projectName).setAssociationType(CIBuildDetail.BuildAssociationType.ATTACHED).setBuildTriggerSource(CIBuildDetail.BuildTriggerSource.CI);
        if (this.flowRuntimeId != null && !this.flowRuntimeId.equals("")) {
            logger.println("Attaching to a specific CD Runtime Id: " + this.flowRuntimeId);
            detail.setFlowRuntimeId(this.flowRuntimeId);
        } else {
            detail.setReleaseName(this.releaseName);
        }
        try {
            detail.validate();
        }
        catch (RuntimeException ex) {
            logger.println("[ERROR] Can't fill the CIBuildDetail: " + ex.getMessage());
            logger.println(Arrays.toString(ex.getStackTrace()));
        }
        if (log.isDebugEnabled()) {
            logger.println("JSON: " + Utils.formatJsonOutput(detail.toJsonObject().toString()));
        }
        logger.println("Preparing to attach build...");
        JSONObject result = efClient.attachCIBuildDetails(detail);
        logger.println("CD response: " + Utils.formatJsonOutput(result.toString()));
        return result;
    }

    private String getSummaryHtml(ElectricFlowClient electricFlowClient, Map<String, String> args, PrintStream logger) {
        String releaseName = args.get("releaseName");
        String releaseId = args.get("releaseId");
        String flowRuntimeId = args.get("flowRuntimeId");
        String path = String.format("/flow/#pipeline-run/%s/%s/release/%s", releaseId, flowRuntimeId, releaseId);
        String releaseRunLink = electricFlowClient.getElectricFlowUrl() + path;
        logger.println(String.format("INFO: link to the release: %s", releaseRunLink));
        return "<h3>CloudBees CD - Associate Build To Release</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td>Build details were attached to the release </td>\n    <td><a target='_blank' href='" + HtmlUtils.encodeForHtml(releaseRunLink) + "'>" + HtmlUtils.encodeForHtml(releaseName) + "</a></td>\n  </tr></table>";
    }

    public String getConfiguration() {
        return this.configuration;
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public Credential getOverrideCredential() {
        return this.overrideCredential;
    }

    @DataBoundSetter
    public void setOverrideCredential(Credential overrideCredential) {
        this.overrideCredential = overrideCredential;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = SelectFieldUtils.getSelectItemValue(projectName);
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    @DataBoundSetter
    public void setReleaseName(String releaseName) {
        this.releaseName = SelectFieldUtils.getSelectItemValue(releaseName);
    }

    public String getFlowRuntimeId() {
        return this.flowRuntimeId;
    }

    @DataBoundSetter
    public void setFlowRuntimeId(String flowRuntimeId) {
        this.flowRuntimeId = flowRuntimeId;
    }

    public String getStoredProjectName() {
        return this.projectName;
    }

    public String getStoredConfiguration() {
        return this.configuration;
    }

    public String getStoredReleaseName() {
        return this.releaseName;
    }

    public String getStoredFlowRuntimeId() {
        return this.releaseName;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Symbol(value={"cloudBeesFlowAssociateBuildToRelease"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateConfiguration(value);
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Project name");
        }

        public FormValidation doCheckReleaseName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Release name");
        }

        public FormValidation doCheckParameters(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillConfigurationItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
            return Credential.DescriptorImpl.doFillCredentialIdItems(item);
        }

        public ListBoxModel doFillProjectNameItems(@QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
            return Utils.getProjects(configuration, overrideCredentialObj);
        }

        public ListBoxModel doFillReleaseNameItems(@QueryParameter String projectName, @QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select release", "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName)) {
                    Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                    ElectricFlowClient client = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                    List<String> releasesList = client.getReleaseNames(configuration, projectName);
                    for (String release : releasesList) {
                        m.add(release);
                    }
                }
                return m;
            }
            catch (Exception e) {
                Credential overrideCredentialObj;
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching values for this parameter - release. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select release");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select release");
            }
        }

        public ListBoxModel doFillFlowRuntimeIdItems(@QueryParameter String releaseName, @QueryParameter String projectName, @QueryParameter String configuration, @QueryParameter boolean overrideCredential, @QueryParameter @RelativePath(value="overrideCredential") String credentialId, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            String dropdownPlaceholderText = "(Optional) Select release pipeline run";
            try {
                ListBoxModel m = new ListBoxModel();
                m.add(dropdownPlaceholderText, "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && !releaseName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName)) {
                    Credential overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                    ElectricFlowClient client = ElectricFlowClientFactory.getElectricFlowClient(configuration, overrideCredentialObj, null, true);
                    List<Map<String, Object>> pipelineRuns = client.getReleaseRuns(configuration, projectName, releaseName);
                    for (Map<String, Object> run : pipelineRuns) {
                        m.add((String)run.get("flowRuntimeName"), (String)run.get("flowRuntimeId"));
                    }
                }
                return m;
            }
            catch (Exception e) {
                Credential overrideCredentialObj;
                Credential credential = overrideCredentialObj = overrideCredential ? new Credential(credentialId) : null;
                if (Utils.isEflowAvailable(configuration, overrideCredentialObj)) {
                    log.error((Object)("Error when fetching values for this parameter - release. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException(dropdownPlaceholderText);
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf(dropdownPlaceholderText);
            }
        }

        public String getDisplayName() {
            return "CloudBees CD - Associate Build To Release";
        }

        public String getId() {
            return "electricFlowAssociateBuildToRelease";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doShowOldValues(@QueryParameter(value="configuration") String configuration, @QueryParameter(value="projectName") String projectName, @QueryParameter(value="releaseName") String releaseName, @QueryParameter(value="storedConfiguration") String storedConfiguration, @QueryParameter(value="storedProjectName") String storedProjectName, @QueryParameter(value="storedReleaseName") String storedReleaseName, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            String configurationValue = configuration;
            String projectNameValue = SelectFieldUtils.getSelectItemValue(projectName);
            String releaseNameValue = SelectFieldUtils.getSelectItemValue(releaseName);
            String comparisonTable = "<table>" + Utils.getValidationComparisonHeaderRow() + Utils.getValidationComparisonRow("Configuration", storedConfiguration, configurationValue) + Utils.getValidationComparisonRow("Project Name", storedProjectName, projectNameValue) + Utils.getValidationComparisonRow("Release Name", storedReleaseName, releaseNameValue) + "</table>";
            if (configurationValue.equals(storedConfiguration) && projectNameValue.equals(storedProjectName) && releaseNameValue.equals(storedReleaseName)) {
                return FormValidation.okWithMarkup((String)("No changes detected:<br>" + comparisonTable));
            }
            return FormValidation.warningWithMarkup((String)("Changes detected:<br>" + comparisonTable));
        }
    }
}

