/*
 * Decompiled with CFR 0.152.
 */
package eggPlant;

import hudson.model.AbstractBuild;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class RunscriptCommand {
    private String runscript;
    private String scripts;
    private String host;
    private int port;
    private String password;
    private int colorDepth;
    private int repeatCount;
    private String globalResultsFolder;
    private String defaultDocumentDirectory;
    private boolean commandLineOutput;
    private boolean reportFailures;
    private String params;
    private AbstractBuild build;
    private String runscriptCommandString;
    ArrayList<String> cmdList = new ArrayList();

    public RunscriptCommand(AbstractBuild b, String exeLoc, String scriptList) {
        this.runscript = exeLoc;
        this.build = b;
        this.colorDepth = 0;
        this.repeatCount = 0;
        this.port = 0;
        this.scripts = "";
        this.params = "";
        String[] scriptArray = scriptList.split(",");
        for (int i = 0; i < scriptArray.length; ++i) {
            this.scripts = this.scripts + this.build.getWorkspace() + File.separator + scriptArray[i].trim() + " ";
        }
        this.scripts = this.scripts.trim();
        this.runscriptCommandString = this.runscript + " " + this.scripts;
    }

    public void buildRunscriptCommandString() {
        if (this.host != null) {
            this.runscriptCommandString = this.runscriptCommandString + " -host " + this.host;
        }
        if (this.port != 0) {
            this.runscriptCommandString = this.runscriptCommandString + " -port " + this.port;
        }
        if (this.password != null) {
            this.runscriptCommandString = this.runscriptCommandString + " -password " + this.password;
        }
        if (this.colorDepth != 0) {
            this.runscriptCommandString = this.runscriptCommandString + " -colorDepth " + this.colorDepth;
        }
        if (this.repeatCount != 0) {
            this.runscriptCommandString = this.runscriptCommandString + " -repeat " + this.repeatCount;
        }
        if (this.globalResultsFolder != null) {
            this.runscriptCommandString = this.runscriptCommandString + " -GlobalResultsFolder " + this.globalResultsFolder;
        }
        if (this.defaultDocumentDirectory != null) {
            this.runscriptCommandString = this.runscriptCommandString + " -DefaultDocumentDirectory " + this.defaultDocumentDirectory;
        }
        if (this.commandLineOutput) {
            this.runscriptCommandString = this.runscriptCommandString + " -CommandLineOutput YES ";
        }
        if (this.reportFailures) {
            this.runscriptCommandString = this.runscriptCommandString + " -ReportFailures YES ";
        }
        if (!this.params.isEmpty()) {
            this.runscriptCommandString = this.runscriptCommandString + " -params " + this.params;
        }
    }

    public void buildRunscriptCommandList() {
        if (this.runscript != null) {
            this.cmdList.add(this.runscript);
        }
        if (this.scripts != null) {
            String[] myScriptArray = this.scripts.split(" ");
            this.cmdList.addAll(Arrays.asList(myScriptArray));
        }
        if (this.host != null) {
            this.cmdList.add("-host");
            this.cmdList.add(this.host);
        }
        if (this.port != 0) {
            this.cmdList.add("-port");
            this.cmdList.add(Integer.toString(this.port));
        }
        if (this.password != null) {
            this.cmdList.add("-password");
            this.cmdList.add(this.password);
        }
        if (this.colorDepth != 0) {
            this.cmdList.add("-colorDepth");
            this.cmdList.add(Integer.toString(this.colorDepth));
        }
        if (this.repeatCount != 0) {
            this.cmdList.add("-repeat");
            this.cmdList.add(Integer.toString(this.repeatCount));
        }
        if (this.globalResultsFolder != null) {
            this.cmdList.add("-GlobalResultsFolder");
            this.cmdList.add(this.globalResultsFolder);
        }
        if (this.defaultDocumentDirectory != null) {
            this.cmdList.add("-DefaultDocumentDirectory");
            this.cmdList.add(this.defaultDocumentDirectory);
        }
        if (this.commandLineOutput) {
            this.cmdList.add("-CommandLineOutput");
            this.cmdList.add("YES");
        }
        if (this.reportFailures) {
            this.cmdList.add("-ReportFailures");
            this.cmdList.add("YES");
        }
        if (!this.params.isEmpty()) {
            this.cmdList.add("-params");
            this.cmdList.add(this.params);
        }
    }

    public String getRunScriptCommandString() {
        return this.runscriptCommandString;
    }

    public ArrayList<String> getRunscriptCommandList() {
        return this.cmdList;
    }

    public int getColorDepth() {
        return this.colorDepth;
    }

    public void setColorDepth(int colorDepth) {
        this.colorDepth = colorDepth;
    }

    public boolean isCommandLineOutput() {
        return this.commandLineOutput;
    }

    public void setCommandLineOutput(boolean commandLineOutput) {
        this.commandLineOutput = commandLineOutput;
    }

    public String getDefaultDocumentDirectory() {
        return this.defaultDocumentDirectory;
    }

    public void setDefaultDocumentDirectory(String defaultDocumentDirectory) {
        this.defaultDocumentDirectory = defaultDocumentDirectory;
    }

    public String getGlobalResultsFolder() {
        return this.globalResultsFolder;
    }

    public void setGlobalResultsFolder(String globalResultsFolder) {
        this.globalResultsFolder = globalResultsFolder;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String prms) {
        String[] parameters = prms.split(",");
        for (int i = 0; i < parameters.length; ++i) {
            this.params = this.params + parameters[i] + " ";
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public boolean isReportFailures() {
        return this.reportFailures;
    }

    public void setReportFailures(boolean reportFailures) {
        this.reportFailures = reportFailures;
    }

    public String getRunscript() {
        return this.runscript;
    }

    public void setRunscript(String runscript) {
        this.runscript = runscript;
    }

    public String getScripts() {
        return this.scripts;
    }

    public void setScripts(String scripts) {
        this.scripts = scripts;
    }
}

