/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AmazonEC2Exception;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.CreditSpecificationRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceMarketOptionsRequest;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.MarketType;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.ResourceType;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.ShutdownBehavior;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.SpotMarketOptions;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.services.ec2.model.SpotPrice;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.model.listeners.SaveableListener;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.plugins.ec2.ConnectionStrategy;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2OndemandSlave;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.Messages;
import hudson.plugins.ec2.SpotConfiguration;
import hudson.plugins.ec2.UnixData;
import hudson.plugins.ec2.WindowsData;
import hudson.plugins.ec2.util.AmazonEC2Factory;
import hudson.plugins.ec2.util.DeviceMappingParser;
import hudson.plugins.ec2.util.EC2AgentConfig;
import hudson.plugins.ec2.util.EC2AgentFactory;
import hudson.plugins.ec2.util.MinimumInstanceChecker;
import hudson.plugins.ec2.util.MinimumNumberOfInstancesTimeRangeConfig;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.slaves.iterators.api.NodeIterator;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SlaveTemplate
implements Describable<SlaveTemplate> {
    private static final Logger LOGGER = Logger.getLogger(SlaveTemplate.class.getName());
    public String ami;
    public final String description;
    public final String zone;
    public final SpotConfiguration spotConfig;
    public final String securityGroups;
    public final String remoteFS;
    public final InstanceType type;
    public final boolean ebsOptimized;
    public final boolean monitoring;
    public final boolean t2Unlimited;
    public final String labels;
    public final Node.Mode mode;
    public final String initScript;
    public final String tmpDir;
    public final String userData;
    public final String numExecutors;
    public final String remoteAdmin;
    public final String jvmopts;
    public final String subnetId;
    public final String idleTerminationMinutes;
    public final String iamInstanceProfile;
    public final boolean deleteRootOnTermination;
    public final boolean useEphemeralDevices;
    public final String customDeviceMapping;
    public int instanceCap;
    private int minimumNumberOfInstances;
    private MinimumNumberOfInstancesTimeRangeConfig minimumNumberOfInstancesTimeRangeConfig;
    private int minimumNumberOfSpareInstances;
    public final boolean stopOnTerminate;
    private final List<EC2Tag> tags;
    public ConnectionStrategy connectionStrategy;
    public final boolean associatePublicIp;
    protected transient EC2Cloud parent;
    public final boolean useDedicatedTenancy;
    public AMITypeData amiType;
    public int launchTimeout;
    public boolean connectBySSHProcess;
    public int maxTotalUses;
    private DescribableList<NodeProperty<?>, NodePropertyDescriptor> nodeProperties;
    public int nextSubnet;
    public String currentSubnetId;
    private transient Set<LabelAtom> labelSet;
    private transient Set<String> securityGroupSet;
    @Deprecated
    public transient String sshPort;
    @Deprecated
    public transient String rootCommandPrefix;
    @Deprecated
    public transient String slaveCommandPrefix;
    @Deprecated
    public transient String slaveCommandSuffix;
    @Deprecated
    public boolean usePrivateDnsName;
    @Deprecated
    public boolean connectUsingPublicIp;

    @DataBoundConstructor
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, int minimumNumberOfSpareInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties) {
        if (StringUtils.isNotBlank((String)remoteAdmin) || StringUtils.isNotBlank((String)jvmopts) || StringUtils.isNotBlank((String)tmpDir)) {
            LOGGER.log(Level.FINE, "As remoteAdmin, jvmopts or tmpDir is not blank, we must ensure the user has ADMINISTER rights.");
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j != null) {
                j.checkPermission(Jenkins.ADMINISTER);
            }
        }
        this.ami = ami;
        this.zone = zone;
        this.spotConfig = spotConfig;
        this.securityGroups = securityGroups;
        this.remoteFS = remoteFS;
        this.amiType = amiType;
        this.type = type;
        this.ebsOptimized = ebsOptimized;
        this.labels = Util.fixNull((String)labelString);
        this.mode = mode != null ? mode : Node.Mode.NORMAL;
        this.description = description;
        this.initScript = initScript;
        this.tmpDir = tmpDir;
        this.userData = StringUtils.trimToEmpty((String)userData);
        this.numExecutors = Util.fixNull((String)numExecutors).trim();
        this.remoteAdmin = remoteAdmin;
        this.jvmopts = jvmopts;
        this.stopOnTerminate = stopOnTerminate;
        this.subnetId = subnetId;
        this.tags = tags;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.associatePublicIp = associatePublicIp;
        this.connectionStrategy = connectionStrategy == null ? ConnectionStrategy.PRIVATE_IP : connectionStrategy;
        this.useDedicatedTenancy = useDedicatedTenancy;
        this.connectBySSHProcess = connectBySSHProcess;
        this.maxTotalUses = maxTotalUses;
        this.nodeProperties = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(nodeProperties));
        this.monitoring = monitoring;
        this.nextSubnet = 0;
        this.usePrivateDnsName = this.connectionStrategy.equals((Object)ConnectionStrategy.PRIVATE_DNS);
        this.connectUsingPublicIp = this.connectionStrategy.equals((Object)ConnectionStrategy.PUBLIC_IP);
        this.minimumNumberOfInstances = minimumNumberOfInstances;
        this.minimumNumberOfSpareInstances = minimumNumberOfSpareInstances;
        this.instanceCap = null == instanceCapStr || instanceCapStr.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        try {
            this.launchTimeout = Integer.parseInt(launchTimeoutStr);
        }
        catch (NumberFormatException nfe) {
            this.launchTimeout = Integer.MAX_VALUE;
        }
        this.iamInstanceProfile = iamInstanceProfile;
        this.deleteRootOnTermination = deleteRootOnTermination;
        this.useEphemeralDevices = useEphemeralDevices;
        this.customDeviceMapping = customDeviceMapping;
        this.t2Unlimited = t2Unlimited;
        this.readResolve();
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, 0, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, nodeProperties);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, Collections.emptyList());
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, 0, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean connectUsingPublicIp, boolean monitoring, boolean t2Unlimited) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, ConnectionStrategy.backwardsCompatible(usePrivateDnsName, connectUsingPublicIp, associatePublicIp), -1);
    }

    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean connectUsingPublicIp) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, connectUsingPublicIp, false, false);
    }

    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, false, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, false);
    }

    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, false);
    }

    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, String sshPort, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, String rootCommandPrefix, String slaveCommandPrefix, String slaveCommandSuffix, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean useEphemeralDevices, String launchTimeoutStr) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, new UnixData(rootCommandPrefix, slaveCommandPrefix, slaveCommandSuffix, sshPort), jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, useEphemeralDevices, false, launchTimeoutStr, false, null);
    }

    public boolean isConnectBySSHProcess() {
        return this.connectBySSHProcess;
    }

    public EC2Cloud getParent() {
        return this.parent;
    }

    public String getLabelString() {
        return this.labels;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public String getDisplayName() {
        return String.format("EC2 (%s) - %s", this.parent.getDisplayName(), this.description);
    }

    public String getSlaveName(String instanceId) {
        return String.format("%s (%s)", this.getDisplayName(), instanceId);
    }

    String getZone() {
        return this.zone;
    }

    public String getSecurityGroupString() {
        return this.securityGroups;
    }

    public Set<String> getSecurityGroupSet() {
        return this.securityGroupSet;
    }

    public Set<String> parseSecurityGroups() {
        if (this.securityGroups == null || "".equals(this.securityGroups.trim())) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(this.securityGroups.split("\\s*,\\s*")));
    }

    public int getNumExecutors() {
        try {
            return Integer.parseInt(this.numExecutors);
        }
        catch (NumberFormatException e) {
            return EC2AbstractSlave.toNumExecutors(this.type);
        }
    }

    public int getSshPort() {
        try {
            String sshPort = "";
            if (this.amiType.isUnix()) {
                sshPort = ((UnixData)this.amiType).getSshPort();
            }
            return Integer.parseInt(sshPort);
        }
        catch (NumberFormatException e) {
            return 22;
        }
    }

    public String getRemoteAdmin() {
        return this.remoteAdmin;
    }

    public String getRootCommandPrefix() {
        return this.amiType.isUnix() ? ((UnixData)this.amiType).getRootCommandPrefix() : "";
    }

    public String getSlaveCommandPrefix() {
        return this.amiType.isUnix() ? ((UnixData)this.amiType).getSlaveCommandPrefix() : "";
    }

    public String getSlaveCommandSuffix() {
        return this.amiType.isUnix() ? ((UnixData)this.amiType).getSlaveCommandSuffix() : "";
    }

    public String chooseSubnetId() {
        if (StringUtils.isBlank((String)this.subnetId)) {
            return null;
        }
        String[] subnetIdList = this.getSubnetId().split(" ");
        this.currentSubnetId = subnetIdList[this.nextSubnet];
        this.nextSubnet = (this.nextSubnet + 1) % subnetIdList.length;
        return this.currentSubnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getCurrentSubnetId() {
        return this.currentSubnetId;
    }

    public boolean getAssociatePublicIp() {
        return this.associatePublicIp;
    }

    @Deprecated
    @DataBoundSetter
    public void setConnectUsingPublicIp(boolean connectUsingPublicIp) {
        this.connectUsingPublicIp = connectUsingPublicIp;
        this.connectionStrategy = ConnectionStrategy.backwardsCompatible(this.usePrivateDnsName, this.connectUsingPublicIp, this.associatePublicIp);
    }

    @Deprecated
    @DataBoundSetter
    public void setUsePrivateDnsName(boolean usePrivateDnsName) {
        this.usePrivateDnsName = usePrivateDnsName;
        this.connectionStrategy = ConnectionStrategy.backwardsCompatible(this.usePrivateDnsName, this.connectUsingPublicIp, this.associatePublicIp);
    }

    @Deprecated
    public boolean getUsePrivateDnsName() {
        return this.usePrivateDnsName;
    }

    @Deprecated
    public boolean isConnectUsingPublicIp() {
        return this.connectUsingPublicIp;
    }

    public List<EC2Tag> getTags() {
        if (null == this.tags) {
            return null;
        }
        return Collections.unmodifiableList(this.tags);
    }

    public String getidleTerminationMinutes() {
        return this.idleTerminationMinutes;
    }

    public boolean getUseDedicatedTenancy() {
        return this.useDedicatedTenancy;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public String getAmi() {
        return this.ami;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public AMITypeData getAmiType() {
        return this.amiType;
    }

    public void setAmiType(AMITypeData amiType) {
        this.amiType = amiType;
    }

    public int getMinimumNumberOfInstances() {
        return this.minimumNumberOfInstances;
    }

    public int getMinimumNumberOfSpareInstances() {
        return this.minimumNumberOfSpareInstances;
    }

    public MinimumNumberOfInstancesTimeRangeConfig getMinimumNumberOfInstancesTimeRangeConfig() {
        return this.minimumNumberOfInstancesTimeRangeConfig;
    }

    @DataBoundSetter
    public void setMinimumNumberOfInstancesTimeRangeConfig(MinimumNumberOfInstancesTimeRangeConfig minimumNumberOfInstancesTimeRangeConfig) {
        this.minimumNumberOfInstancesTimeRangeConfig = minimumNumberOfInstancesTimeRangeConfig;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public int getSpotBlockReservationDuration() {
        if (this.spotConfig == null) {
            return 0;
        }
        return this.spotConfig.spotBlockReservationDuration;
    }

    public String getSpotBlockReservationDurationStr() {
        if (this.spotConfig == null) {
            return "";
        }
        int dur = this.getSpotBlockReservationDuration();
        if (dur == 0) {
            return "";
        }
        return String.valueOf(this.getSpotBlockReservationDuration());
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public String getSpotMaxBidPrice() {
        if (this.spotConfig == null) {
            return null;
        }
        return SpotConfiguration.normalizeBid(this.spotConfig.spotMaxBidPrice);
    }

    public String getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String toString() {
        return "SlaveTemplate{ami='" + this.ami + '\'' + ", labels='" + this.labels + '\'' + '}';
    }

    public int getMaxTotalUses() {
        return this.maxTotalUses;
    }

    public DescribableList<NodeProperty<?>, NodePropertyDescriptor> getNodeProperties() {
        return Objects.requireNonNull(this.nodeProperties);
    }

    public List<EC2AbstractSlave> provision(int number, EnumSet<ProvisionOptions> provisionOptions) throws AmazonClientException, IOException {
        if (this.spotConfig != null) {
            if (provisionOptions.contains((Object)ProvisionOptions.ALLOW_CREATE) || provisionOptions.contains((Object)ProvisionOptions.FORCE_CREATE)) {
                return this.provisionSpot(number, provisionOptions);
            }
            return null;
        }
        return this.provisionOndemand(number, provisionOptions);
    }

    private boolean checkInstance(Instance instance) {
        for (EC2AbstractSlave node : NodeIterator.nodes(EC2AbstractSlave.class)) {
            if (!node.getInstanceId().equals(instance.getInstanceId()) || instance.getState().getName().equalsIgnoreCase(InstanceStateName.Stopped.toString())) continue;
            this.logInstanceCheck(instance, ". false - found existing corresponding Jenkins slave: " + node.getInstanceId());
            return false;
        }
        this.logInstanceCheck(instance, " true - Instance is not connected to Jenkins");
        return true;
    }

    private void logInstanceCheck(Instance instance, String message) {
        this.logProvisionInfo("checkInstance: " + instance.getInstanceId() + "." + message);
    }

    private boolean isSameIamInstanceProfile(Instance instance) {
        return StringUtils.isBlank((String)this.getIamInstanceProfile()) || instance.getIamInstanceProfile() != null && instance.getIamInstanceProfile().getArn().equals(this.getIamInstanceProfile());
    }

    private boolean isTerminatingOrShuttindDown(String instanceStateName) {
        return instanceStateName.equalsIgnoreCase(InstanceStateName.Terminated.toString()) || instanceStateName.equalsIgnoreCase(InstanceStateName.ShuttingDown.toString());
    }

    private void logProvisionInfo(String message) {
        LOGGER.info(this + ". " + message);
    }

    private List<EC2AbstractSlave> provisionOndemand(int number, EnumSet<ProvisionOptions> provisionOptions) throws IOException {
        return this.provisionOndemand(number, provisionOptions, false, false);
    }

    private List<EC2AbstractSlave> provisionOndemand(int number, EnumSet<ProvisionOptions> provisionOptions, boolean spotWithoutBidPrice, boolean fallbackSpotToOndemand) throws IOException {
        List newInstances;
        List<Object> groupIds;
        AmazonEC2 ec2 = this.getParent().connect();
        this.logProvisionInfo("Considering launching");
        RunInstancesRequest riRequest = new RunInstancesRequest(this.ami, Integer.valueOf(1), Integer.valueOf(number)).withInstanceType(this.type);
        riRequest.setEbsOptimized(Boolean.valueOf(this.ebsOptimized));
        riRequest.setMonitoring(Boolean.valueOf(this.monitoring));
        if (this.t2Unlimited) {
            CreditSpecificationRequest creditRequest = new CreditSpecificationRequest();
            creditRequest.setCpuCredits("unlimited");
            riRequest.setCreditSpecification(creditRequest);
        }
        this.setupBlockDeviceMappings(riRequest.getBlockDeviceMappings());
        if (this.stopOnTerminate) {
            riRequest.setInstanceInitiatedShutdownBehavior(ShutdownBehavior.Stop);
            this.logProvisionInfo("Setting Instance Initiated Shutdown Behavior : ShutdownBehavior.Stop");
        } else {
            riRequest.setInstanceInitiatedShutdownBehavior(ShutdownBehavior.Terminate);
            this.logProvisionInfo("Setting Instance Initiated Shutdown Behavior : ShutdownBehavior.Terminate");
        }
        ArrayList<Filter> diFilters = new ArrayList<Filter>();
        diFilters.add(new Filter("image-id").withValues(new String[]{this.ami}));
        diFilters.add(new Filter("instance-type").withValues(new String[]{this.type.toString()}));
        KeyPair keyPair = this.getKeyPair(ec2);
        riRequest.setUserData(Base64.getEncoder().encodeToString(this.userData.getBytes(StandardCharsets.UTF_8)));
        riRequest.setKeyName(keyPair.getKeyName());
        diFilters.add(new Filter("key-name").withValues(new String[]{keyPair.getKeyName()}));
        if (StringUtils.isNotBlank((String)this.getZone())) {
            Placement placement = new Placement(this.getZone());
            if (this.getUseDedicatedTenancy()) {
                placement.setTenancy("dedicated");
            }
            riRequest.setPlacement(placement);
            diFilters.add(new Filter("availability-zone").withValues(new String[]{this.getZone()}));
        }
        String subnetId = this.chooseSubnetId();
        InstanceNetworkInterfaceSpecification net = new InstanceNetworkInterfaceSpecification();
        if (StringUtils.isNotBlank((String)subnetId)) {
            if (this.getAssociatePublicIp()) {
                net.setSubnetId(subnetId);
            } else {
                riRequest.setSubnetId(subnetId);
            }
            diFilters.add(new Filter("subnet-id").withValues(new String[]{subnetId}));
            if (!this.securityGroupSet.isEmpty() && !(groupIds = this.getEc2SecurityGroups(ec2)).isEmpty()) {
                if (this.getAssociatePublicIp()) {
                    net.setGroups(groupIds);
                } else {
                    riRequest.setSecurityGroupIds(groupIds);
                }
                diFilters.add(new Filter("instance.group-id").withValues(groupIds));
            }
        } else {
            riRequest.setSecurityGroups(this.securityGroupSet);
            groupIds = this.getSecurityGroupsBy("group-name", this.securityGroupSet, ec2).getSecurityGroups().stream().map(SecurityGroup::getGroupId).collect(Collectors.toList());
            net.setGroups(groupIds);
            if (!groupIds.isEmpty()) {
                diFilters.add(new Filter("instance.group-id").withValues(groupIds));
            }
        }
        net.setAssociatePublicIpAddress(Boolean.valueOf(this.getAssociatePublicIp()));
        net.setDeviceIndex(Integer.valueOf(0));
        if (this.getAssociatePublicIp()) {
            riRequest.withNetworkInterfaces(new InstanceNetworkInterfaceSpecification[]{net});
        }
        HashSet<Tag> instTags = this.buildTags("demand");
        for (Tag tag : instTags) {
            diFilters.add(new Filter("tag:" + tag.getKey()).withValues(new String[]{tag.getValue()}));
        }
        DescribeInstancesRequest diRequest = new DescribeInstancesRequest().withFilters(diFilters);
        this.logProvisionInfo("Looking for existing instances with describe-instance: " + diRequest);
        DescribeInstancesResult diResult = ec2.describeInstances(diRequest);
        List<Instance> orphansOrStopped = this.findOrphansOrStopped(diResult, number);
        if (orphansOrStopped.isEmpty() && !provisionOptions.contains((Object)ProvisionOptions.FORCE_CREATE) && !provisionOptions.contains((Object)ProvisionOptions.ALLOW_CREATE)) {
            this.logProvisionInfo("No existing instance found - but cannot create new instance");
            return null;
        }
        this.wakeOrphansOrStoppedUp(ec2, orphansOrStopped);
        if (orphansOrStopped.size() == number) {
            return this.toSlaves(orphansOrStopped);
        }
        riRequest.setMaxCount(Integer.valueOf(number - orphansOrStopped.size()));
        if (StringUtils.isNotBlank((String)this.getIamInstanceProfile())) {
            riRequest.setIamInstanceProfile(new IamInstanceProfileSpecification().withArn(this.getIamInstanceProfile()));
        }
        ArrayList<TagSpecification> tagList = new ArrayList<TagSpecification>();
        TagSpecification tagSpecification = new TagSpecification();
        tagSpecification.setTags(instTags);
        tagList.add(tagSpecification.clone().withResourceType(ResourceType.Instance));
        tagList.add(tagSpecification.clone().withResourceType(ResourceType.Volume));
        riRequest.setTagSpecifications(tagList);
        if (spotWithoutBidPrice) {
            InstanceMarketOptionsRequest instanceMarketOptionsRequest = new InstanceMarketOptionsRequest().withMarketType(MarketType.Spot);
            if (this.getSpotBlockReservationDuration() != 0) {
                SpotMarketOptions spotOptions = new SpotMarketOptions().withBlockDurationMinutes(Integer.valueOf(this.getSpotBlockReservationDuration() * 60));
                instanceMarketOptionsRequest.setSpotOptions(spotOptions);
            }
            riRequest.setInstanceMarketOptions(instanceMarketOptionsRequest);
            try {
                newInstances = ec2.runInstances(riRequest).getReservation().getInstances();
            }
            catch (AmazonEC2Exception e) {
                if (fallbackSpotToOndemand && e.getErrorCode().equals("InsufficientInstanceCapacity")) {
                    this.logProvisionInfo("There is no spot capacity available matching your request, falling back to on-demand instance.");
                    riRequest.setInstanceMarketOptions(new InstanceMarketOptionsRequest());
                    newInstances = ec2.runInstances(riRequest).getReservation().getInstances();
                }
                throw e;
            }
        } else {
            newInstances = ec2.runInstances(riRequest).getReservation().getInstances();
        }
        if (newInstances.isEmpty()) {
            this.logProvisionInfo("No new instances were created");
        }
        newInstances.addAll(orphansOrStopped);
        return this.toSlaves(newInstances);
    }

    private void wakeOrphansOrStoppedUp(AmazonEC2 ec2, List<Instance> orphansOrStopped) {
        ArrayList<String> instances = new ArrayList<String>();
        for (Instance instance : orphansOrStopped) {
            if (instance.getState().getName().equalsIgnoreCase(InstanceStateName.Stopping.toString()) || instance.getState().getName().equalsIgnoreCase(InstanceStateName.Stopped.toString())) {
                this.logProvisionInfo("Found stopped instances - will start it: " + instance);
                instances.add(instance.getInstanceId());
                continue;
            }
            this.logProvisionInfo("Found existing pending or running: " + instance.getState().getName() + " instance: " + instance);
        }
        if (!instances.isEmpty()) {
            StartInstancesRequest siRequest = new StartInstancesRequest(instances);
            StartInstancesResult siResult = ec2.startInstances(siRequest);
            this.logProvisionInfo("Result of starting stopped instances:" + siResult);
        }
    }

    private List<EC2AbstractSlave> toSlaves(List<Instance> newInstances) throws IOException {
        try {
            ArrayList<EC2AbstractSlave> slaves = new ArrayList<EC2AbstractSlave>(newInstances.size());
            for (Instance instance : newInstances) {
                slaves.add(this.newOndemandSlave(instance));
                this.logProvisionInfo("Return instance: " + instance);
            }
            return slaves;
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError((Object)e);
        }
    }

    private List<Instance> findOrphansOrStopped(DescribeInstancesResult diResult, int number) {
        ArrayList<Instance> orphansOrStopped = new ArrayList<Instance>();
        int count = 0;
        for (Reservation reservation : diResult.getReservations()) {
            for (Instance instance : reservation.getInstances()) {
                if (!this.isSameIamInstanceProfile(instance)) {
                    this.logInstanceCheck(instance, ". false - IAM Instance profile does not match: " + instance.getIamInstanceProfile());
                    continue;
                }
                if (this.isTerminatingOrShuttindDown(instance.getState().getName())) {
                    this.logInstanceCheck(instance, ". false - Instance is terminated or shutting down");
                    continue;
                }
                if (this.checkInstance(instance)) {
                    this.logProvisionInfo("Found existing instance: " + instance);
                    orphansOrStopped.add(instance);
                    ++count;
                }
                if (count != number) continue;
                return orphansOrStopped;
            }
        }
        return orphansOrStopped;
    }

    private void setupRootDevice(List<BlockDeviceMapping> deviceMappings) {
        if (this.deleteRootOnTermination && this.getImage().getRootDeviceType().equals("ebs")) {
            List<BlockDeviceMapping> rootDeviceMappings = this.getAmiBlockDeviceMappings();
            if (rootDeviceMappings.size() == 0) {
                LOGGER.warning("AMI missing block devices");
                return;
            }
            BlockDeviceMapping rootMapping = rootDeviceMappings.get(0);
            LOGGER.info("AMI had " + rootMapping.getDeviceName());
            LOGGER.info(rootMapping.getEbs().toString());
            for (BlockDeviceMapping mapping : deviceMappings) {
                LOGGER.info("Request had " + mapping.getDeviceName());
                if (!rootMapping.getDeviceName().equals(mapping.getDeviceName())) continue;
                mapping.getEbs().setDeleteOnTermination(Boolean.TRUE);
                return;
            }
            BlockDeviceMapping newMapping = rootMapping.clone();
            newMapping.getEbs().setDeleteOnTermination(Boolean.TRUE);
            newMapping.getEbs().setEncrypted(null);
            deviceMappings.add(0, newMapping);
        }
    }

    private List<BlockDeviceMapping> getNewEphemeralDeviceMapping() {
        List<BlockDeviceMapping> oldDeviceMapping = this.getAmiBlockDeviceMappings();
        HashSet<String> occupiedDevices = new HashSet<String>();
        for (BlockDeviceMapping mapping : oldDeviceMapping) {
            occupiedDevices.add(mapping.getDeviceName());
        }
        ArrayList<String> available = new ArrayList<String>(Arrays.asList("ephemeral0", "ephemeral1", "ephemeral2", "ephemeral3"));
        ArrayList<BlockDeviceMapping> newDeviceMapping = new ArrayList<BlockDeviceMapping>(4);
        for (char suffix = 'b'; suffix <= 'z' && !available.isEmpty(); suffix = (char)(suffix + '\u0001')) {
            String deviceName = String.format("/dev/xvd%s", Character.valueOf(suffix));
            if (occupiedDevices.contains(deviceName)) continue;
            BlockDeviceMapping newMapping = new BlockDeviceMapping().withDeviceName(deviceName).withVirtualName((String)available.get(0));
            newDeviceMapping.add(newMapping);
            available.remove(0);
        }
        return newDeviceMapping;
    }

    private void setupEphemeralDeviceMapping(List<BlockDeviceMapping> deviceMappings) {
        deviceMappings.addAll(this.getNewEphemeralDeviceMapping());
    }

    private List<BlockDeviceMapping> getAmiBlockDeviceMappings() {
        return this.getImage().getBlockDeviceMappings();
    }

    private Image getImage() {
        DescribeImagesRequest request = new DescribeImagesRequest().withImageIds(new String[]{this.ami});
        for (Image image : this.getParent().connect().describeImages(request).getImages()) {
            if (!this.ami.equals(image.getImageId())) continue;
            return image;
        }
        throw new AmazonClientException("Unable to find AMI " + this.ami);
    }

    private void setupCustomDeviceMapping(List<BlockDeviceMapping> deviceMappings) {
        if (StringUtils.isNotBlank((String)this.customDeviceMapping)) {
            deviceMappings.addAll(DeviceMappingParser.parse(this.customDeviceMapping));
        }
    }

    private List<EC2AbstractSlave> provisionSpot(int number, EnumSet<ProvisionOptions> provisionOptions) throws IOException {
        if (!this.spotConfig.useBidPrice) {
            return this.provisionOndemand(1, provisionOptions, true, this.spotConfig.fallbackToOndemand);
        }
        AmazonEC2 ec2 = this.getParent().connect();
        try {
            RequestSpotInstancesResult reqResult;
            List reqInstances;
            List<String> groupIds;
            LOGGER.info("Launching " + this.ami + " for template " + this.description);
            KeyPair keyPair = this.getKeyPair(ec2);
            RequestSpotInstancesRequest spotRequest = new RequestSpotInstancesRequest();
            if (this.getSpotMaxBidPrice() == null) {
                throw new AmazonClientException("Invalid Spot price specified: " + this.getSpotMaxBidPrice());
            }
            spotRequest.setSpotPrice(this.getSpotMaxBidPrice());
            spotRequest.setInstanceCount(Integer.valueOf(number));
            LaunchSpecification launchSpecification = new LaunchSpecification();
            launchSpecification.setImageId(this.ami);
            launchSpecification.setInstanceType(this.type);
            launchSpecification.setEbsOptimized(Boolean.valueOf(this.ebsOptimized));
            launchSpecification.setMonitoringEnabled(Boolean.valueOf(this.monitoring));
            if (StringUtils.isNotBlank((String)this.getZone())) {
                SpotPlacement placement = new SpotPlacement(this.getZone());
                launchSpecification.setPlacement(placement);
            }
            InstanceNetworkInterfaceSpecification net = new InstanceNetworkInterfaceSpecification();
            String subnetId = this.chooseSubnetId();
            if (StringUtils.isNotBlank((String)subnetId)) {
                net.setSubnetId(subnetId);
                if (!this.securityGroupSet.isEmpty() && !(groupIds = this.getEc2SecurityGroups(ec2)).isEmpty()) {
                    net.setGroups(groupIds);
                }
            } else if (!this.securityGroupSet.isEmpty()) {
                groupIds = this.getSecurityGroupsBy("group-name", this.securityGroupSet, ec2).getSecurityGroups().stream().map(SecurityGroup::getGroupId).collect(Collectors.toList());
                net.setGroups(groupIds);
            }
            String userDataString = Base64.getEncoder().encodeToString(this.userData.getBytes(StandardCharsets.UTF_8));
            launchSpecification.setUserData(userDataString);
            launchSpecification.setKeyName(keyPair.getKeyName());
            launchSpecification.setInstanceType(this.type.toString());
            net.setAssociatePublicIpAddress(Boolean.valueOf(this.getAssociatePublicIp()));
            net.setDeviceIndex(Integer.valueOf(0));
            launchSpecification.withNetworkInterfaces(new InstanceNetworkInterfaceSpecification[]{net});
            HashSet<Tag> instTags = this.buildTags("spot");
            if (StringUtils.isNotBlank((String)this.getIamInstanceProfile())) {
                launchSpecification.setIamInstanceProfile(new IamInstanceProfileSpecification().withArn(this.getIamInstanceProfile()));
            }
            this.setupBlockDeviceMappings(launchSpecification.getBlockDeviceMappings());
            spotRequest.setLaunchSpecification(launchSpecification);
            if (this.getSpotBlockReservationDuration() != 0) {
                spotRequest.setBlockDurationMinutes(Integer.valueOf(this.getSpotBlockReservationDuration() * 60));
            }
            if ((reqInstances = (reqResult = ec2.requestSpotInstances(spotRequest)).getSpotInstanceRequests()).isEmpty()) {
                throw new AmazonClientException("No spot instances found");
            }
            ArrayList<EC2AbstractSlave> slaves = new ArrayList<EC2AbstractSlave>(reqInstances.size());
            for (SpotInstanceRequest spotInstReq : reqInstances) {
                if (spotInstReq == null) {
                    throw new AmazonClientException("Spot instance request is null");
                }
                String slaveName = spotInstReq.getSpotInstanceRequestId();
                if (this.spotConfig.fallbackToOndemand) {
                    for (int i = 0; i < 2 && spotInstReq.getStatus().getCode().equals("pending-evaluation"); ++i) {
                        LOGGER.info("Spot request " + slaveName + " is still pending evaluation");
                        Thread.sleep(5000L);
                        LOGGER.info("Fetching info about spot request " + slaveName);
                        DescribeSpotInstanceRequestsRequest describeRequest = new DescribeSpotInstanceRequestsRequest().withSpotInstanceRequestIds(new String[]{slaveName});
                        spotInstReq = (SpotInstanceRequest)ec2.describeSpotInstanceRequests(describeRequest).getSpotInstanceRequests().get(0);
                    }
                    List<String> spotRequestBadCodes = Arrays.asList("capacity-not-available", "capacity-oversubscribed", "price-too-low");
                    if (spotRequestBadCodes.contains(spotInstReq.getStatus().getCode())) {
                        LOGGER.info("There is no spot capacity available matching your request, falling back to on-demand instance.");
                        List requestsToCancel = reqInstances.stream().map(SpotInstanceRequest::getSpotInstanceRequestId).collect(Collectors.toList());
                        CancelSpotInstanceRequestsRequest cancelRequest = new CancelSpotInstanceRequestsRequest(requestsToCancel);
                        ec2.cancelSpotInstanceRequests(cancelRequest);
                        return this.provisionOndemand(number, provisionOptions);
                    }
                }
                this.updateRemoteTags(ec2, instTags, "InvalidSpotInstanceRequestID.NotFound", spotInstReq.getSpotInstanceRequestId());
                spotInstReq.setTags(instTags);
                LOGGER.info("Spot instance id in provision: " + spotInstReq.getSpotInstanceRequestId());
                slaves.add(this.newSpotSlave(spotInstReq));
            }
            return slaves;
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void setupBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
        this.setupRootDevice(blockDeviceMappings);
        if (this.useEphemeralDevices) {
            this.setupEphemeralDeviceMapping(blockDeviceMappings);
        } else {
            this.setupCustomDeviceMapping(blockDeviceMappings);
        }
    }

    private HashSet<Tag> buildTags(String slaveType) {
        boolean hasCustomTypeTag = false;
        boolean hasJenkinsServerUrlTag = false;
        HashSet<Tag> instTags = new HashSet<Tag>();
        if (this.tags != null && !this.tags.isEmpty()) {
            for (EC2Tag t : this.tags) {
                instTags.add(new Tag(t.getName(), t.getValue()));
                if (StringUtils.equals((String)t.getName(), (String)"jenkins_slave_type")) {
                    hasCustomTypeTag = true;
                }
                if (!StringUtils.equals((String)t.getName(), (String)"jenkins_server_url")) continue;
                hasJenkinsServerUrlTag = true;
            }
        }
        if (!hasCustomTypeTag) {
            instTags.add(new Tag("jenkins_slave_type", EC2Cloud.getSlaveTypeTagValue(slaveType, this.description)));
        }
        JenkinsLocationConfiguration jenkinsLocation = JenkinsLocationConfiguration.get();
        if (!hasJenkinsServerUrlTag && jenkinsLocation.getUrl() != null) {
            instTags.add(new Tag("jenkins_server_url", jenkinsLocation.getUrl()));
        }
        return instTags;
    }

    protected EC2OndemandSlave newOndemandSlave(Instance inst) throws Descriptor.FormException, IOException {
        EC2AgentConfig.OnDemand config = ((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)new EC2AgentConfig.OnDemandBuilder().withName(this.getSlaveName(inst.getInstanceId()))).withInstanceId(inst.getInstanceId()).withDescription(this.description)).withRemoteFS(this.remoteFS)).withNumExecutors(this.getNumExecutors())).withLabelString(this.labels)).withMode(this.mode)).withInitScript(this.initScript)).withTmpDir(this.tmpDir)).withNodeProperties(this.nodeProperties.toList())).withRemoteAdmin(this.remoteAdmin)).withJvmopts(this.jvmopts)).withStopOnTerminate(this.stopOnTerminate).withIdleTerminationMinutes(this.idleTerminationMinutes)).withPublicDNS(inst.getPublicDnsName()).withPrivateDNS(inst.getPrivateDnsName()).withTags((List)EC2Tag.fromAmazonTags(inst.getTags()))).withCloudName(this.parent.name)).withUseDedicatedTenancy(this.useDedicatedTenancy).withLaunchTimeout(this.getLaunchTimeout())).withAmiType(this.amiType)).withConnectionStrategy(this.connectionStrategy)).withMaxTotalUses(this.maxTotalUses)).build();
        return EC2AgentFactory.getInstance().createOnDemandAgent(config);
    }

    protected EC2SpotSlave newSpotSlave(SpotInstanceRequest sir) throws Descriptor.FormException, IOException {
        EC2AgentConfig.Spot config = ((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)new EC2AgentConfig.SpotBuilder().withName(this.getSlaveName(sir.getSpotInstanceRequestId()))).withSpotInstanceRequestId(sir.getSpotInstanceRequestId()).withDescription(this.description)).withRemoteFS(this.remoteFS)).withNumExecutors(this.getNumExecutors())).withMode(this.mode)).withInitScript(this.initScript)).withTmpDir(this.tmpDir)).withLabelString(this.labels)).withNodeProperties(this.nodeProperties.toList())).withRemoteAdmin(this.remoteAdmin)).withJvmopts(this.jvmopts)).withIdleTerminationMinutes(this.idleTerminationMinutes)).withTags((List)EC2Tag.fromAmazonTags(sir.getTags()))).withCloudName(this.parent.name)).withLaunchTimeout(this.getLaunchTimeout())).withAmiType(this.amiType)).withConnectionStrategy(this.connectionStrategy)).withMaxTotalUses(this.maxTotalUses)).build();
        return EC2AgentFactory.getInstance().createSpotAgent(config);
    }

    private KeyPair getKeyPair(AmazonEC2 ec2) throws IOException, AmazonClientException {
        KeyPair keyPair = this.parent.getPrivateKey().find(ec2);
        if (keyPair == null) {
            throw new AmazonClientException("No matching keypair found on EC2. Is the EC2 private key a valid one?");
        }
        return keyPair;
    }

    private void updateRemoteTags(AmazonEC2 ec2, Collection<Tag> instTags, String catchErrorCode, String ... params) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            try {
                CreateTagsRequest tagRequest = new CreateTagsRequest();
                tagRequest.withResources(params).setTags(instTags);
                ec2.createTags(tagRequest);
                break;
            }
            catch (AmazonServiceException e) {
                if (e.getErrorCode().equals(catchErrorCode)) {
                    Thread.sleep(5000L);
                    continue;
                }
                LOGGER.log(Level.SEVERE, e.getErrorMessage(), e);
                continue;
            }
        }
    }

    private List<String> getEc2SecurityGroups(AmazonEC2 ec2) throws AmazonClientException {
        ArrayList<String> groupIds = new ArrayList<String>();
        DescribeSecurityGroupsResult groupResult = this.getSecurityGroupsBy("group-name", this.securityGroupSet, ec2);
        if (groupResult.getSecurityGroups().size() == 0) {
            groupResult = this.getSecurityGroupsBy("group-id", this.securityGroupSet, ec2);
        }
        for (SecurityGroup group : groupResult.getSecurityGroups()) {
            if (group.getVpcId() == null || group.getVpcId().isEmpty()) continue;
            ArrayList<Filter> filters = new ArrayList<Filter>();
            filters.add(new Filter("vpc-id").withValues(new String[]{group.getVpcId()}));
            filters.add(new Filter("state").withValues(new String[]{"available"}));
            filters.add(new Filter("subnet-id").withValues(new String[]{this.getCurrentSubnetId()}));
            DescribeSubnetsRequest subnetReq = new DescribeSubnetsRequest();
            subnetReq.withFilters(filters);
            DescribeSubnetsResult subnetResult = ec2.describeSubnets(subnetReq);
            List subnets = subnetResult.getSubnets();
            if (subnets == null || subnets.isEmpty()) continue;
            groupIds.add(group.getGroupId());
        }
        if (this.securityGroupSet.size() != groupIds.size()) {
            throw new AmazonClientException("Security groups must all be VPC security groups to work in a VPC context");
        }
        return groupIds;
    }

    private DescribeSecurityGroupsResult getSecurityGroupsBy(String filterName, Set<String> filterValues, AmazonEC2 ec2) {
        DescribeSecurityGroupsRequest groupReq = new DescribeSecurityGroupsRequest();
        groupReq.withFilters(new Filter[]{new Filter(filterName).withValues(filterValues)});
        return ec2.describeSecurityGroups(groupReq);
    }

    public EC2AbstractSlave attach(String instanceId, TaskListener listener) throws AmazonClientException, IOException {
        PrintStream logger = listener.getLogger();
        AmazonEC2 ec2 = this.getParent().connect();
        try {
            logger.println("Attaching to " + instanceId);
            LOGGER.info("Attaching to " + instanceId);
            DescribeInstancesRequest request = new DescribeInstancesRequest();
            request.setInstanceIds(Collections.singletonList(instanceId));
            Instance inst = (Instance)((Reservation)ec2.describeInstances(request).getReservations().get(0)).getInstances().get(0);
            return this.newOndemandSlave(inst);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    protected Object readResolve() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.labelSet = Label.parse((String)this.labels);
        this.securityGroupSet = this.parseSecurityGroups();
        if (this.instanceCap == 0) {
            this.instanceCap = Integer.MAX_VALUE;
        }
        if (this.amiType == null) {
            this.amiType = new UnixData(this.rootCommandPrefix, this.slaveCommandPrefix, this.slaveCommandSuffix, this.sshPort);
        }
        if (this.connectionStrategy == null) {
            this.connectionStrategy = ConnectionStrategy.backwardsCompatible(this.usePrivateDnsName, this.connectUsingPublicIp, this.associatePublicIp);
        }
        if (this.maxTotalUses == 0) {
            this.maxTotalUses = -1;
        }
        if (this.nodeProperties == null) {
            this.nodeProperties = new DescribableList(Saveable.NOOP);
        }
        return this;
    }

    public Descriptor<SlaveTemplate> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    public int getLaunchTimeout() {
        return this.launchTimeout <= 0 ? Integer.MAX_VALUE : this.launchTimeout;
    }

    public String getLaunchTimeoutStr() {
        if (this.launchTimeout == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.launchTimeout);
    }

    public boolean isWindowsSlave() {
        return this.amiType.isWindows();
    }

    public boolean isUnixSlave() {
        return this.amiType.isUnix();
    }

    public Secret getAdminPassword() {
        return this.amiType.isWindows() ? ((WindowsData)this.amiType).getPassword() : Secret.fromString((String)"");
    }

    public boolean isUseHTTPS() {
        return this.amiType.isWindows() && ((WindowsData)this.amiType).isUseHTTPS();
    }

    public static enum ProvisionOptions {
        ALLOW_CREATE,
        FORCE_CREATE;

    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SlaveTemplate> {
        public String getDisplayName() {
            return "";
        }

        public List<Descriptor<AMITypeData>> getAMITypeDescriptors() {
            return Jenkins.get().getDescriptorList(AMITypeData.class);
        }

        public String getHelpFile(String fieldName) {
            String p = super.getHelpFile(fieldName);
            if (p != null) {
                return p;
            }
            Descriptor slaveDescriptor = Jenkins.get().getDescriptor(EC2OndemandSlave.class);
            if (slaveDescriptor != null && (p = slaveDescriptor.getHelpFile(fieldName)) != null) {
                return p;
            }
            slaveDescriptor = Jenkins.get().getDescriptor(EC2SpotSlave.class);
            if (slaveDescriptor != null) {
                return slaveDescriptor.getHelpFile(fieldName);
            }
            return null;
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRemoteAdmin(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.General_MissingPermission());
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckTmpDir(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.General_MissingPermission());
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckJvmopts(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.General_MissingPermission());
        }

        private Image getAmiImage(AmazonEC2 ec2, String ami) {
            LinkedList<String> images = new LinkedList<String>();
            images.add(ami);
            LinkedList owners = new LinkedList();
            LinkedList users = new LinkedList();
            DescribeImagesRequest request = new DescribeImagesRequest();
            request.setImageIds(images);
            request.setOwners(owners);
            request.setExecutableUsers(users);
            List img = ec2.describeImages(request).getImages();
            if (img == null || img.isEmpty()) {
                return null;
            }
            return (Image)img.get(0);
        }

        public FormValidation doValidateAmi(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String ec2endpoint, @QueryParameter String region, @QueryParameter String ami, @QueryParameter String roleArn, @QueryParameter String roleSessionName) throws IOException {
            AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
            AmazonEC2 ec2 = region != null ? AmazonEC2Factory.getInstance().connect(credentialsProvider, AmazonEC2Cloud.getEc2EndpointUrl(region)) : AmazonEC2Factory.getInstance().connect(credentialsProvider, new URL(ec2endpoint));
            try {
                Image img = this.getAmiImage(ec2, ami);
                if (img == null) {
                    return FormValidation.error((String)("No such AMI, or not usable with this accessId: " + ami));
                }
                String ownerAlias = img.getImageOwnerAlias();
                return FormValidation.ok((String)(img.getImageLocation() + (ownerAlias != null ? " by " + ownerAlias : "")));
            }
            catch (AmazonClientException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckLabelString(@QueryParameter String value, @QueryParameter Node.Mode mode) {
            if (mode == Node.Mode.EXCLUSIVE && (value == null || value.trim().isEmpty())) {
                return FormValidation.warning((String)"You may want to assign labels to this node; it's marked to only run jobs that are exclusively tied to itself or a label.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIdleTerminationMinutes(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val >= -59) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Idle Termination time must be a greater than -59 (or null)");
        }

        public FormValidation doCheckMaxTotalUses(@QueryParameter String value) {
            try {
                int val = Integer.parseInt(value);
                if (val >= -1) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Maximum Total Uses must be greater or equal to -1");
        }

        public FormValidation doCheckMinimumNumberOfInstances(@QueryParameter String value, @QueryParameter String instanceCapStr) {
            block6: {
                if (value == null || value.trim().isEmpty()) {
                    return FormValidation.ok();
                }
                try {
                    int instanceCap;
                    int val = Integer.parseInt(value);
                    if (val < 0) break block6;
                    try {
                        instanceCap = Integer.parseInt(instanceCapStr);
                    }
                    catch (NumberFormatException ignore) {
                        instanceCap = Integer.MAX_VALUE;
                    }
                    if (val > instanceCap) {
                        return FormValidation.error((String)"Minimum number of instances must not be larger than AMI Instance Cap %d", (Object[])new Object[]{instanceCap});
                    }
                    return FormValidation.ok();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return FormValidation.error((String)"Minimum number of instances must be a non-negative integer (or null)");
        }

        public FormValidation doCheckMinimumNoInstancesActiveTimeRangeFrom(@QueryParameter String value) {
            try {
                MinimumNumberOfInstancesTimeRangeConfig.validateLocalTimeString(value);
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)"Please enter value in format 'h:mm a' or 'HH:mm'");
            }
        }

        public FormValidation doCheckMinimumNoInstancesActiveTimeRangeTo(@QueryParameter String value) {
            try {
                MinimumNumberOfInstancesTimeRangeConfig.validateLocalTimeString(value);
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)"Please enter value in format 'h:mm a' or 'HH:mm'");
            }
        }

        public FormValidation doCheckMonday(@QueryParameter boolean monday, @QueryParameter boolean tuesday, @QueryParameter boolean wednesday, @QueryParameter boolean thursday, @QueryParameter boolean friday, @QueryParameter boolean saturday, @QueryParameter boolean sunday) {
            if (!(monday || tuesday || wednesday || thursday || friday || saturday || sunday)) {
                return FormValidation.warning((String)"At least one day should be checked or minimum number of instances won't be active");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMinimumNumberOfSpareInstances(@QueryParameter String value, @QueryParameter String instanceCapStr) {
            block6: {
                if (value == null || value.trim().isEmpty()) {
                    return FormValidation.ok();
                }
                try {
                    int instanceCap;
                    int val = Integer.parseInt(value);
                    if (val < 0) break block6;
                    try {
                        instanceCap = Integer.parseInt(instanceCapStr);
                    }
                    catch (NumberFormatException ignore) {
                        instanceCap = Integer.MAX_VALUE;
                    }
                    if (val > instanceCap) {
                        return FormValidation.error((String)"Minimum number of spare instances must not be larger than AMI Instance Cap %d", (Object[])new Object[]{instanceCap});
                    }
                    return FormValidation.ok();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return FormValidation.error((String)"Minimum number of spare instances must be a non-negative integer (or null)");
        }

        public FormValidation doCheckInstanceCapStr(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val > 0) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"InstanceCap must be a non-negative integer (or null)");
        }

        public FormValidation doCheckSpotBlockReservationDurationStr(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val >= 0 && val <= 6) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Spot Block Reservation Duration must be an integer between 0 & 6");
        }

        public FormValidation doCheckLaunchTimeoutStr(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val >= 0) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Launch Timeout must be a non-negative integer (or null)");
        }

        public ListBoxModel doFillZoneItems(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String roleArn, @QueryParameter String roleSessionName) throws IOException, ServletException {
            AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
            return EC2AbstractSlave.fillZoneItems(credentialsProvider, region);
        }

        public FormValidation doCheckSpotMaxBidPrice(@QueryParameter String spotMaxBidPrice) {
            if (SpotConfiguration.normalizeBid(spotMaxBidPrice) != null) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Not a correct bid price");
        }

        private ArrayList<String> getAvailabilityZones(AmazonEC2 ec2) {
            ArrayList<String> availabilityZones = new ArrayList<String>();
            DescribeAvailabilityZonesResult zones = ec2.describeAvailabilityZones();
            List zoneList = zones.getAvailabilityZones();
            for (AvailabilityZone z : zoneList) {
                availabilityZones.add(z.getZoneName());
            }
            return availabilityZones;
        }

        public FormValidation doCurrentSpotPrice(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String type, @QueryParameter String zone, @QueryParameter String roleArn, @QueryParameter String roleSessionName, @QueryParameter String ami) throws IOException, ServletException {
            String cp = "";
            String zoneStr = "";
            AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
            AmazonEC2 ec2 = AmazonEC2Factory.getInstance().connect(credentialsProvider, AmazonEC2Cloud.getEc2EndpointUrl(region));
            if (ec2 != null) {
                try {
                    Image img;
                    DescribeSpotPriceHistoryRequest request = new DescribeSpotPriceHistoryRequest();
                    if (this.getAvailabilityZones(ec2).contains(zone)) {
                        request.setAvailabilityZone(zone);
                        zoneStr = zone + " availability zone";
                    } else {
                        zoneStr = region + " region";
                    }
                    InstanceType ec2Type = null;
                    for (InstanceType it : InstanceType.values()) {
                        if (!it.name().equals(type)) continue;
                        ec2Type = it;
                        break;
                    }
                    if (ec2Type == null) {
                        return FormValidation.error((String)("Could not resolve instance type: " + type));
                    }
                    if (!ami.isEmpty() && (img = this.getAmiImage(ec2, ami)) != null) {
                        ArrayList<String> productDescriptions = new ArrayList<String>();
                        productDescriptions.add(img.getPlatform() == "Windows" ? "Windows" : "Linux/UNIX");
                        request.setProductDescriptions(productDescriptions);
                    }
                    ArrayList<String> instanceType = new ArrayList<String>();
                    instanceType.add(ec2Type.toString());
                    request.setInstanceTypes(instanceType);
                    request.setStartTime(new Date());
                    DescribeSpotPriceHistoryResult result = ec2.describeSpotPriceHistory(request);
                    if (!result.getSpotPriceHistory().isEmpty()) {
                        SpotPrice currentPrice = (SpotPrice)result.getSpotPriceHistory().get(0);
                        cp = currentPrice.getSpotPrice();
                    }
                }
                catch (AmazonServiceException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            if (cp.isEmpty()) {
                return FormValidation.error((String)"Could not retrieve current Spot price");
            }
            cp = cp.substring(0, cp.length() - 3);
            return FormValidation.ok((String)("The current Spot price for a " + type + " in the " + zoneStr + " is $" + cp));
        }

        public String getDefaultConnectionStrategy() {
            return ConnectionStrategy.PRIVATE_IP.toString();
        }

        public List<NodePropertyDescriptor> getNodePropertyDescriptors() {
            return NodePropertyDescriptor.for_((List)NodeProperty.all(), EC2AbstractSlave.class);
        }

        public ListBoxModel doFillConnectionStrategyItems(@QueryParameter String connectionStrategy) {
            return Stream.of(ConnectionStrategy.values()).map(v -> {
                if (v.toString().equals(connectionStrategy)) {
                    return new ListBoxModel.Option(v.toString(), v.name(), true);
                }
                return new ListBoxModel.Option(v.toString(), v.name(), false);
            }).collect(Collectors.toCollection(ListBoxModel::new));
        }

        public FormValidation doCheckConnectionStrategy(@QueryParameter String connectionStrategy) {
            return Stream.of(ConnectionStrategy.values()).filter(v -> v.equalsName(connectionStrategy)).findFirst().map(s -> FormValidation.ok()).orElse(FormValidation.error((String)"Could not find selected connection strategy"));
        }
    }

    @Extension
    public static final class OnSaveListener
    extends SaveableListener {
        public void onChange(Saveable o, XmlFile file) {
            if (o instanceof Jenkins) {
                MinimumInstanceChecker.checkForMinimumInstances();
            }
        }
    }
}

