/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win.winrm.soap;

import com.google.common.collect.ImmutableList;
import hudson.plugins.ec2.win.winrm.soap.Namespaces;
import hudson.plugins.ec2.win.winrm.soap.Option;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class Header {
    private final String to;
    private final String replyTo;
    private final String maxEnvelopeSize;
    private final String timeout;
    private final String locale;
    private final String id;
    private final String action;
    private final String shellId;
    private final String resourceURI;
    private final ImmutableList<Option> optionSet;

    Header(String to, String replyTo, String maxEnvelopeSize, String timeout, String locale, String id, String action, String shellId, String resourceURI, ImmutableList<Option> optionSet) {
        this.to = to;
        this.replyTo = replyTo;
        this.maxEnvelopeSize = maxEnvelopeSize;
        this.timeout = timeout;
        this.locale = locale;
        this.id = id;
        this.action = action;
        this.shellId = shellId;
        this.resourceURI = resourceURI;
        this.optionSet = optionSet;
    }

    void toElement(Element header) {
        if (this.to != null) {
            header.addElement(QName.get((String)"To", (Namespace)Namespaces.NS_ADDRESSING)).addText(this.to);
        }
        if (this.replyTo != null) {
            Header.mustUnderstand(header.addElement(QName.get((String)"ReplyTo", (Namespace)Namespaces.NS_ADDRESSING)).addElement(QName.get((String)"Address", (Namespace)Namespaces.NS_ADDRESSING))).addText(this.replyTo);
        }
        if (this.maxEnvelopeSize != null) {
            Header.mustUnderstand(header.addElement(QName.get((String)"MaxEnvelopeSize", (Namespace)Namespaces.NS_WSMAN_DMTF))).addText(this.maxEnvelopeSize);
        }
        if (this.id != null) {
            header.addElement(QName.get((String)"MessageID", (Namespace)Namespaces.NS_ADDRESSING)).addText(this.id);
        }
        if (this.locale != null) {
            Header.mustNotUnderstand(header.addElement(QName.get((String)"Locale", (Namespace)Namespaces.NS_WSMAN_DMTF))).addAttribute("xml:lang", this.locale);
            Header.mustNotUnderstand(header.addElement(QName.get((String)"DataLocale", (Namespace)Namespaces.NS_WSMAN_MSFT))).addAttribute("xml:lang", this.locale);
        }
        if (this.timeout != null) {
            header.addElement(QName.get((String)"OperationTimeout", (Namespace)Namespaces.NS_WSMAN_DMTF)).addText(this.timeout);
        }
        if (this.action != null) {
            Header.mustUnderstand(header.addElement(QName.get((String)"Action", (Namespace)Namespaces.NS_ADDRESSING))).addText(this.action);
        }
        if (this.shellId != null) {
            header.addElement(QName.get((String)"SelectorSet", (Namespace)Namespaces.NS_WSMAN_DMTF)).addElement(QName.get((String)"Selector", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("Name", "ShellId").addText(this.shellId);
        }
        if (this.resourceURI != null) {
            Header.mustUnderstand(header.addElement(QName.get((String)"ResourceURI", (Namespace)Namespaces.NS_WSMAN_DMTF))).addText(this.resourceURI);
        }
        if (this.optionSet != null) {
            Element set = header.addElement(QName.get((String)"OptionSet", (Namespace)Namespaces.NS_WSMAN_DMTF));
            for (Option p : this.optionSet) {
                set.addElement(QName.get((String)"Option", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("Name", p.getName()).addText(p.getValue());
            }
        }
    }

    private static Element mustUnderstand(Element e) {
        return e.addAttribute("mustUnderstand", "true");
    }

    private static Element mustNotUnderstand(Element e) {
        return e.addAttribute("mustUnderstand", "false");
    }
}

