/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import hudson.plugins.ec2.win.winrm.WinRM;
import hudson.plugins.ec2.win.winrm.WindowsProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WinConnection {
    private static final Logger log = Logger.getLogger(WinConnection.class.getName());
    private final String host;
    private final String username;
    private final String password;
    private final SMBClient smbclient;
    private final AuthenticationContext authentication;
    private boolean useHTTPS;
    private static final int TIMEOUT = 8000;

    public WinConnection(String host, String username, String password) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.smbclient = new SMBClient();
        this.authentication = new AuthenticationContext(username, password.toCharArray(), null);
    }

    public WinRM winrm() {
        WinRM winrm = new WinRM(this.host, this.username, this.password);
        winrm.setUseHTTPS(this.useHTTPS);
        return winrm;
    }

    public WinRM winrm(int timeout) {
        WinRM winrm = this.winrm();
        winrm.setTimeout(timeout);
        return winrm;
    }

    public WindowsProcess execute(String commandLine) {
        return this.execute(commandLine, 60);
    }

    public WindowsProcess execute(String commandLine, int timeout) {
        return this.winrm(timeout).execute(commandLine);
    }

    private DiskShare getSmbShare(String path) throws IOException {
        Connection connection = this.smbclient.connect(this.host);
        Session session = connection.authenticate(this.authentication);
        return (DiskShare)session.connectShare(WinConnection.toAdministrativeShare(path));
    }

    public OutputStream putFile(String path) throws IOException {
        return this.getSmbShare(path).openFile(WinConnection.toFilePath(path), EnumSet.of(AccessMask.GENERIC_READ, AccessMask.GENERIC_WRITE), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OVERWRITE_IF, null).getOutputStream();
    }

    public InputStream getFile(String path) throws IOException {
        return this.getSmbShare(path).openFile(WinConnection.toFilePath(path), EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, null, null).getInputStream();
    }

    public boolean exists(String path) throws IOException {
        return this.getSmbShare(path).fileExists(WinConnection.toFilePath(path));
    }

    private static String toAdministrativeShare(String path) {
        return path.substring(0, 1) + "$";
    }

    private static String toFilePath(String path) {
        return path.substring(3);
    }

    public boolean ping() {
        log.log(Level.FINE, "checking SMB connection to " + this.host);
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(this.host, 445), 8000);
            socket.close();
            this.winrm().ping();
            Connection connection = this.smbclient.connect(this.host);
            Session session = connection.authenticate(this.authentication);
            session.connectShare("IPC$");
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to verify connectivity to Windows slave", e);
            return false;
        }
    }

    public void close() {
    }

    public void setUseHTTPS(boolean useHTTPS) {
        this.useHTTPS = useHTTPS;
    }
}

