/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsImpl;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.TaskListener;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2PrivateKey;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.Messages;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.util.AmazonEC2Factory;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class EC2Cloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(EC2Cloud.class.getName());
    public static final String DEFAULT_EC2_HOST = "us-east-1";
    public static final String DEFAULT_EC2_ENDPOINT = "https://ec2.amazonaws.com";
    public static final String AWS_URL_HOST = "amazonaws.com";
    public static final String EC2_SLAVE_TYPE_SPOT = "spot";
    public static final String EC2_SLAVE_TYPE_DEMAND = "demand";
    private static final SimpleFormatter sf = new SimpleFormatter();
    private transient ReentrantLock slaveCountingLock = new ReentrantLock();
    private final boolean useInstanceProfileForCredentials;
    private final String roleArn;
    private final String roleSessionName;
    @CheckForNull
    private String credentialsId;
    @CheckForNull
    @Deprecated
    private transient String accessId;
    @CheckForNull
    @Deprecated
    private transient Secret secretKey;
    private final EC2PrivateKey privateKey;
    private final int instanceCap;
    private final List<? extends SlaveTemplate> templates;
    private transient KeyPair usableKeyPair;
    private volatile transient AmazonEC2 connection;

    protected EC2Cloud(String id, boolean useInstanceProfileForCredentials, String credentialsId, String privateKey, String instanceCapStr, List<? extends SlaveTemplate> templates, String roleArn, String roleSessionName) {
        super(id);
        this.useInstanceProfileForCredentials = useInstanceProfileForCredentials;
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
        this.credentialsId = credentialsId;
        this.privateKey = new EC2PrivateKey(privateKey);
        this.templates = templates == null ? Collections.emptyList() : templates;
        this.instanceCap = instanceCapStr == null || instanceCapStr.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        this.readResolve();
    }

    public abstract URL getEc2EndpointUrl() throws IOException;

    public abstract URL getS3EndpointUrl() throws IOException;

    protected Object readResolve() {
        this.slaveCountingLock = new ReentrantLock();
        for (SlaveTemplate slaveTemplate : this.templates) {
            slaveTemplate.parent = this;
        }
        if (this.accessId != null && this.secretKey != null && this.credentialsId == null) {
            String secretKeyEncryptedValue = this.secretKey.getEncryptedValue();
            SystemCredentialsProvider systemCredentialsProvider = SystemCredentialsProvider.getInstance();
            for (Credentials credentials : systemCredentialsProvider.getCredentials()) {
                AmazonWebServicesCredentials awsCreds;
                AWSCredentials awsCredentials;
                if (!(credentials instanceof AmazonWebServicesCredentials) || !this.accessId.equals((awsCredentials = (awsCreds = (AmazonWebServicesCredentials)credentials).getCredentials()).getAWSAccessKeyId()) || !Secret.toString((Secret)this.secretKey).equals(awsCredentials.getAWSSecretKey())) continue;
                this.credentialsId = awsCreds.getId();
                this.accessId = null;
                this.secretKey = null;
                return this;
            }
            for (CredentialsStore credentialsStore : CredentialsProvider.lookupStores((ModelObject)Jenkins.get())) {
                if (!(credentialsStore instanceof SystemCredentialsProvider.StoreImpl)) continue;
                try {
                    String credsId = UUID.randomUUID().toString();
                    credentialsStore.addCredentials(Domain.global(), (Credentials)new AWSCredentialsImpl(CredentialsScope.SYSTEM, credsId, this.accessId, secretKeyEncryptedValue, "EC2 Cloud - " + this.getDisplayName()));
                    this.credentialsId = credsId;
                    this.accessId = null;
                    this.secretKey = null;
                    return this;
                }
                catch (IOException e) {
                    this.credentialsId = null;
                    LOGGER.log(Level.WARNING, "Exception converting legacy configuration to the new credentials API", e);
                }
            }
            LOGGER.log(Level.WARNING, "EC2 Plugin could not migrate credentials to the Jenkins Global Credentials Store, EC2 Plugin for cloud {0} must be manually reconfigured", this.getDisplayName());
        }
        return this;
    }

    public boolean isUseInstanceProfileForCredentials() {
        return this.useInstanceProfileForCredentials;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public EC2PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public List<SlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    @CheckForNull
    public SlaveTemplate getTemplate(String template) {
        for (SlaveTemplate slaveTemplate : this.templates) {
            if (!slaveTemplate.description.equals(template)) continue;
            return slaveTemplate;
        }
        return null;
    }

    public SlaveTemplate getTemplate(Label label) {
        for (SlaveTemplate slaveTemplate : this.templates) {
            if (!(slaveTemplate.getMode() == Node.Mode.NORMAL ? label == null || label.matches(slaveTemplate.getLabelSet()) : slaveTemplate.getMode() == Node.Mode.EXCLUSIVE && label != null && label.matches(slaveTemplate.getLabelSet()))) continue;
            return slaveTemplate;
        }
        return null;
    }

    public synchronized KeyPair getKeyPair() throws AmazonClientException, IOException {
        if (this.usableKeyPair == null) {
            this.usableKeyPair = this.privateKey.find(this.connect());
        }
        return this.usableKeyPair;
    }

    public void doAttach(StaplerRequest req, StaplerResponse rsp, @QueryParameter String id) throws ServletException, IOException, AmazonClientException {
        this.checkPermission(PROVISION);
        SlaveTemplate t = this.getTemplates().get(0);
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        EC2AbstractSlave node = t.attach(id, (TaskListener)listener);
        Jenkins.get().addNode((Node)node);
        rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
    }

    public HttpResponse doProvision(@QueryParameter String template) throws ServletException, IOException {
        this.checkPermission(PROVISION);
        if (template == null) {
            throw HttpResponses.error((int)400, (String)"The 'template' query parameter is missing");
        }
        SlaveTemplate t = this.getTemplate(template);
        if (t == null) {
            throw HttpResponses.error((int)400, (String)("No such template: " + template));
        }
        Jenkins jenkinsInstance = Jenkins.get();
        if (jenkinsInstance.isQuietingDown()) {
            throw HttpResponses.error((int)400, (String)"Jenkins instance is quieting down");
        }
        if (jenkinsInstance.isTerminating()) {
            throw HttpResponses.error((int)400, (String)"Jenkins instance is terminating");
        }
        try {
            List<EC2AbstractSlave> nodes = this.getNewOrExistingAvailableSlave(t, 1, true);
            if (nodes == null || nodes.isEmpty()) {
                throw HttpResponses.error((int)400, (String)("Cloud or AMI instance cap would be exceeded for: " + template));
            }
            Computer c = nodes.get(0).toComputer();
            if (nodes.get(0).getStopOnTerminate() && c != null) {
                c.connect(false);
            }
            jenkinsInstance.addNode((Node)nodes.get(0));
            return HttpResponses.redirectViaContextPath((String)("/computer/" + nodes.get(0).getNodeName()));
        }
        catch (AmazonClientException e) {
            throw HttpResponses.error((int)500, (Throwable)e);
        }
    }

    private int countCurrentEC2Slaves(SlaveTemplate template) throws AmazonClientException {
        String jenkinsServerUrl = JenkinsLocationConfiguration.get().getUrl();
        if (jenkinsServerUrl == null) {
            LOGGER.log(Level.WARNING, "No Jenkins server URL specified, it is strongly recommended to open /configure and set the server URL. Not having has disabled the per-master instance cap counting (cf. https://github.com/jenkinsci/ec2-plugin/pull/310)");
        }
        LOGGER.log(Level.FINE, "Counting current slaves: " + (template != null ? " AMI: " + template.getAmi() + " TemplateDesc: " + template.description : " All AMIS") + " Jenkins Server: " + jenkinsServerUrl);
        int n = 0;
        HashSet<String> instanceIds = new HashSet<String>();
        String description = template != null ? template.description : null;
        List<Filter> filters = this.getGenericFilters(jenkinsServerUrl, template);
        filters.add(new Filter("instance-state-name").withValues(new String[]{"running", "pending", "stopping"}));
        DescribeInstancesRequest dir = new DescribeInstancesRequest().withFilters(filters);
        DescribeInstancesResult result = null;
        do {
            result = this.connect().describeInstances(dir);
            dir.setNextToken(result.getNextToken());
            for (Reservation r : result.getReservations()) {
                for (Instance i : r.getInstances()) {
                    if (!this.isEc2ProvisionedAmiSlave(i.getTags(), description)) continue;
                    LOGGER.log(Level.FINE, "Existing instance found: " + i.getInstanceId() + " AMI: " + i.getImageId() + (template != null ? " Template: " + description : "") + " Jenkins Server: " + jenkinsServerUrl);
                    ++n;
                    instanceIds.add(i.getInstanceId());
                }
            }
        } while (result.getNextToken() != null);
        return n += this.countCurrentEC2SpotSlaves(template, jenkinsServerUrl, instanceIds);
    }

    private int countCurrentEC2SpotSlaves(SlaveTemplate template, String jenkinsServerUrl, Set<String> instanceIds) throws AmazonClientException {
        int n = 0;
        String description = template != null ? template.description : null;
        List sirs = null;
        List<Filter> filters = this.getGenericFilters(jenkinsServerUrl, template);
        if (template != null) {
            filters.add(new Filter("launch.image-id").withValues(new String[]{template.getAmi()}));
        }
        DescribeSpotInstanceRequestsRequest dsir = new DescribeSpotInstanceRequestsRequest().withFilters(filters).withMaxResults(Integer.valueOf(100));
        HashSet<SpotInstanceRequest> sirSet = new HashSet<SpotInstanceRequest>();
        DescribeSpotInstanceRequestsResult sirResp = null;
        do {
            try {
                sirResp = this.connect().describeSpotInstanceRequests(dsir);
                sirs = sirResp.getSpotInstanceRequests();
                dsir.setNextToken(sirResp.getNextToken());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Describe spot instance requests failed", ex);
                break;
            }
            if (sirs == null) continue;
            block5: for (SpotInstanceRequest sir : sirs) {
                sirSet.add(sir);
                if (sir.getState().equals("open") || sir.getState().equals("active")) {
                    if (sir.getInstanceId() != null && instanceIds.contains(sir.getInstanceId()) || !this.isEc2ProvisionedAmiSlave(sir.getTags(), description)) continue;
                    LOGGER.log(Level.FINE, "Spot instance request found: " + sir.getSpotInstanceRequestId() + " AMI: " + sir.getInstanceId() + " state: " + sir.getState() + " status: " + sir.getStatus());
                    ++n;
                    if (sir.getInstanceId() == null) continue;
                    instanceIds.add(sir.getInstanceId());
                    continue;
                }
                for (Node node : Jenkins.get().getNodes()) {
                    try {
                        EC2SpotSlave ec2Slave;
                        if (!(node instanceof EC2SpotSlave) || !(ec2Slave = (EC2SpotSlave)node).getSpotInstanceRequestId().equals(sir.getSpotInstanceRequestId())) continue;
                        LOGGER.log(Level.INFO, "Removing dead request: " + sir.getSpotInstanceRequestId() + " AMI: " + sir.getInstanceId() + " state: " + sir.getState() + " status: " + sir.getStatus());
                        Jenkins.get().removeNode(node);
                        continue block5;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to remove node for dead request: " + sir.getSpotInstanceRequestId() + " AMI: " + sir.getInstanceId() + " state: " + sir.getState() + " status: " + sir.getStatus(), e);
                    }
                }
            }
        } while (sirResp.getNextToken() != null);
        return n += this.countJenkinsNodeSpotInstancesWithoutRequests(template, sirSet, instanceIds);
    }

    private int countJenkinsNodeSpotInstancesWithoutRequests(SlaveTemplate template, Set<SpotInstanceRequest> sirSet, Set<String> instanceIds) throws AmazonClientException {
        int n = 0;
        for (Node node : Jenkins.get().getNodes()) {
            if (!(node instanceof EC2SpotSlave)) continue;
            EC2SpotSlave ec2Slave = (EC2SpotSlave)node;
            SpotInstanceRequest sir = ec2Slave.getSpotRequest();
            if (sir == null) {
                LOGGER.log(Level.FINE, "Found spot node without request: " + ec2Slave.getSpotInstanceRequestId());
                ++n;
                continue;
            }
            if (sirSet.contains(sir)) continue;
            sirSet.add(sir);
            if (!sir.getState().equals("open") && !sir.getState().equals("active") || template == null) continue;
            List instanceTags = sir.getTags();
            for (Tag tag : instanceTags) {
                if (!StringUtils.equals((String)tag.getKey(), (String)"jenkins_slave_type") || !StringUtils.equals((String)tag.getValue(), (String)EC2Cloud.getSlaveTypeTagValue(EC2_SLAVE_TYPE_SPOT, template.description)) || !sir.getLaunchSpecification().getImageId().equals(template.getAmi()) || sir.getInstanceId() != null && instanceIds.contains(sir.getInstanceId())) continue;
                LOGGER.log(Level.FINE, "Spot instance request found (from node): " + sir.getSpotInstanceRequestId() + " AMI: " + sir.getInstanceId() + " state: " + sir.getState() + " status: " + sir.getStatus());
                ++n;
                if (sir.getInstanceId() == null) continue;
                instanceIds.add(sir.getInstanceId());
            }
        }
        return n;
    }

    private List<Filter> getGenericFilters(String jenkinsServerUrl, SlaveTemplate template) {
        List<EC2Tag> tags;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new Filter("tag-key").withValues(new String[]{"jenkins_slave_type"}));
        if (jenkinsServerUrl != null) {
            filters.add(new Filter("tag:jenkins_server_url").withValues(new String[]{jenkinsServerUrl}));
        } else {
            filters.add(new Filter("tag-key").withValues(new String[]{"jenkins_server_url"}));
        }
        if (template != null && (tags = template.getTags()) != null) {
            for (EC2Tag tag : tags) {
                if (tag.getName() == null || tag.getValue() == null) continue;
                filters.add(new Filter("tag:" + tag.getName()).withValues(new String[]{tag.getValue()}));
            }
        }
        return filters;
    }

    private boolean isEc2ProvisionedAmiSlave(List<Tag> tags, String description) {
        for (Tag tag : tags) {
            if (!StringUtils.equals((String)tag.getKey(), (String)"jenkins_slave_type")) continue;
            if (description == null) {
                return true;
            }
            if (StringUtils.equals((String)tag.getValue(), (String)EC2_SLAVE_TYPE_DEMAND) || StringUtils.equals((String)tag.getValue(), (String)EC2_SLAVE_TYPE_SPOT)) {
                return true;
            }
            return StringUtils.equals((String)tag.getValue(), (String)EC2Cloud.getSlaveTypeTagValue(EC2_SLAVE_TYPE_DEMAND, description)) || StringUtils.equals((String)tag.getValue(), (String)EC2Cloud.getSlaveTypeTagValue(EC2_SLAVE_TYPE_SPOT, description));
        }
        return false;
    }

    private int getPossibleNewSlavesCount(SlaveTemplate template) throws AmazonClientException {
        int estimatedTotalSlaves = this.countCurrentEC2Slaves(null);
        int estimatedAmiSlaves = this.countCurrentEC2Slaves(template);
        int availableTotalSlaves = this.instanceCap - estimatedTotalSlaves;
        int availableAmiSlaves = template.getInstanceCap() - estimatedAmiSlaves;
        LOGGER.log(Level.FINE, "Available Total Slaves: " + availableTotalSlaves + " Available AMI slaves: " + availableAmiSlaves + " AMI: " + template.getAmi() + " TemplateDesc: " + template.description);
        return Math.min(availableAmiSlaves, availableTotalSlaves);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EC2AbstractSlave> getNewOrExistingAvailableSlave(SlaveTemplate t, int number, boolean forceCreateNew) {
        try {
            this.slaveCountingLock.lock();
            int possibleSlavesCount = this.getPossibleNewSlavesCount(t);
            if (possibleSlavesCount <= 0) {
                LOGGER.log(Level.INFO, "{0}. Cannot provision - no capacity for instances: " + possibleSlavesCount, t);
                List<EC2AbstractSlave> list = null;
                return list;
            }
            EnumSet<SlaveTemplate.ProvisionOptions> provisionOptions = forceCreateNew ? EnumSet.of(SlaveTemplate.ProvisionOptions.FORCE_CREATE) : EnumSet.of(SlaveTemplate.ProvisionOptions.ALLOW_CREATE);
            if (number > possibleSlavesCount) {
                LOGGER.log(Level.INFO, String.format("%d nodes were requested for the template %s, but because of instance cap only %d can be provisioned", number, t, possibleSlavesCount));
                number = possibleSlavesCount;
            }
            List<EC2AbstractSlave> list = t.provision(number, provisionOptions);
            return list;
        }
        finally {
            this.slaveCountingLock.unlock();
        }
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        SlaveTemplate t = this.getTemplate(label);
        ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>();
        Jenkins jenkinsInstance = Jenkins.get();
        if (jenkinsInstance.isQuietingDown()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is quieting down");
            return Collections.emptyList();
        }
        if (jenkinsInstance.isTerminating()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is terminating");
            return Collections.emptyList();
        }
        try {
            LOGGER.log(Level.INFO, "{0}. Attempting to provision slave needed by excess workload of " + excessWorkload + " units", t);
            int number = Math.max(excessWorkload / t.getNumExecutors(), 1);
            List<EC2AbstractSlave> slaves = this.getNewOrExistingAvailableSlave(t, number, false);
            if (slaves == null || slaves.isEmpty()) {
                LOGGER.warning("Can't raise nodes for " + t);
                return Collections.emptyList();
            }
            for (EC2AbstractSlave slave : slaves) {
                if (slave == null) {
                    LOGGER.warning("Can't raise node for " + t);
                    continue;
                }
                plannedNodes.add(this.createPlannedNode(t, slave));
                excessWorkload -= t.getNumExecutors();
            }
            LOGGER.log(Level.INFO, "{0}. Attempting provision finished, excess workload: " + excessWorkload, t);
            LOGGER.log(Level.INFO, "We have now {0} computers, waiting for {1} more", new Object[]{jenkinsInstance.getComputers().length, plannedNodes.size()});
            return plannedNodes;
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, t + ". Exception during provisioning", e);
            return Collections.emptyList();
        }
    }

    public void provision(SlaveTemplate t, int number) {
        Jenkins jenkinsInstance = Jenkins.get();
        if (jenkinsInstance.isQuietingDown()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is quieting down");
            return;
        }
        if (jenkinsInstance.isTerminating()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is terminating");
            return;
        }
        try {
            LOGGER.log(Level.INFO, "{0}. Attempting to provision {1} slave(s)", new Object[]{t, number});
            List<EC2AbstractSlave> slaves = this.getNewOrExistingAvailableSlave(t, number, false);
            if (slaves == null || slaves.isEmpty()) {
                LOGGER.warning("Can't raise nodes for " + t);
                return;
            }
            for (EC2AbstractSlave slave : slaves) {
                if (slave == null) {
                    LOGGER.warning("Can't raise node for " + t);
                    continue;
                }
                Computer c = slave.toComputer();
                if (slave.getStopOnTerminate() && c != null) {
                    c.connect(false);
                }
                jenkinsInstance.addNode((Node)slave);
            }
            LOGGER.log(Level.INFO, "{0}. Attempting provision finished", t);
            LOGGER.log(Level.INFO, "We have now {0} computers, waiting for {1} more", new Object[]{Jenkins.get().getComputers().length, number});
        }
        catch (AmazonClientException | IOException e) {
            LOGGER.log(Level.WARNING, t + ". Exception during provisioning", e);
        }
    }

    private NodeProvisioner.PlannedNode createPlannedNode(final SlaveTemplate t, final EC2AbstractSlave slave) {
        return new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){
            int retryCount = 0;
            private static final int DESCRIBE_LIMIT = 2;

            @Override
            public Node call() throws Exception {
                while (true) {
                    Instance instance;
                    String instanceId = slave.getInstanceId();
                    if (slave instanceof EC2SpotSlave) {
                        if (((EC2SpotSlave)slave).isSpotRequestDead()) {
                            LOGGER.log(Level.WARNING, "{0} Spot request died, can't do anything. Terminate provisioning", t);
                            return null;
                        }
                        if (StringUtils.isEmpty((String)instanceId)) {
                            Thread.sleep(5000L);
                            continue;
                        }
                    }
                    if ((instance = CloudHelper.getInstanceWithRetry(instanceId, slave.getCloud())) == null) {
                        LOGGER.log(Level.WARNING, "{0} Can't find instance with instance id `{1}` in cloud {2}. Terminate provisioning ", new Object[]{t, instanceId, slave.cloudName});
                        return null;
                    }
                    InstanceStateName state = InstanceStateName.fromValue((String)instance.getState().getName());
                    if (state.equals((Object)InstanceStateName.Running)) {
                        Computer c = slave.toComputer();
                        if (slave.getStopOnTerminate() && c != null) {
                            c.connect(false);
                        }
                        long startTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - instance.getLaunchTime().getTime());
                        LOGGER.log(Level.INFO, "{0} Node {1} moved to RUNNING state in {2} seconds and is ready to be connected by Jenkins", new Object[]{t, slave.getNodeName(), startTime});
                        return slave;
                    }
                    if (!state.equals((Object)InstanceStateName.Pending)) {
                        if (this.retryCount >= 2) {
                            LOGGER.log(Level.WARNING, "Instance {0} did not move to running after {1} attempts, terminating provisioning", new Object[]{instanceId, this.retryCount});
                            return null;
                        }
                        LOGGER.log(Level.INFO, "Attempt {0}: {1}. Node {2} is neither pending, neither running, it''s {3}. Will try again after 5s", new Object[]{this.retryCount, t, slave.getNodeName(), state});
                        ++this.retryCount;
                    }
                    Thread.sleep(5000L);
                }
            }
        }), t.getNumExecutors());
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    protected AWSCredentialsProvider createCredentialsProvider() {
        return EC2Cloud.createCredentialsProvider(this.useInstanceProfileForCredentials, this.credentialsId);
    }

    public static String getSlaveTypeTagValue(String slaveType, String templateDescription) {
        return templateDescription != null ? slaveType + "_" + templateDescription : slaveType;
    }

    public static AWSCredentialsProvider createCredentialsProvider(boolean useInstanceProfileForCredentials, String credentialsId) {
        if (useInstanceProfileForCredentials) {
            return new InstanceProfileCredentialsProvider(false);
        }
        if (StringUtils.isBlank((String)credentialsId)) {
            return new DefaultAWSCredentialsProviderChain();
        }
        AmazonWebServicesCredentials credentials = EC2Cloud.getCredentials(credentialsId);
        if (credentials != null) {
            return new AWSStaticCredentialsProvider(credentials.getCredentials());
        }
        return new DefaultAWSCredentialsProviderChain();
    }

    public static AWSCredentialsProvider createCredentialsProvider(boolean useInstanceProfileForCredentials, String credentialsId, String roleArn, String roleSessionName, String region) {
        AWSCredentialsProvider provider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
        if (StringUtils.isNotEmpty((String)roleArn) && StringUtils.isNotEmpty((String)roleSessionName)) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, roleSessionName).withStsClient((AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(provider)).withRegion(region)).withClientConfiguration(EC2Cloud.createClientConfiguration(EC2Cloud.convertHostName(region)))).build()).build();
        }
        return provider;
    }

    @CheckForNull
    private static AmazonWebServicesCredentials getCredentials(@CheckForNull String credentialsId) {
        if (StringUtils.isBlank((String)credentialsId)) {
            return null;
        }
        return (AmazonWebServicesCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AmazonEC2 reconnectToEc2() throws IOException {
        EC2Cloud eC2Cloud = this;
        synchronized (eC2Cloud) {
            this.connection = AmazonEC2Factory.getInstance().connect(this.createCredentialsProvider(), this.getEc2EndpointUrl());
            return this.connection;
        }
    }

    public AmazonEC2 connect() throws AmazonClientException {
        try {
            if (this.connection != null) {
                return this.connection;
            }
            return this.reconnectToEc2();
        }
        catch (IOException e) {
            throw new AmazonClientException("Failed to retrieve the endpoint", (Throwable)e);
        }
    }

    public static ClientConfiguration createClientConfiguration(String host) {
        Proxy proxy;
        ClientConfiguration config = new ClientConfiguration();
        config.setMaxErrorRetry(16);
        config.setSignerOverride("AWS4SignerType");
        ProxyConfiguration proxyConfig = Jenkins.get().proxy;
        Proxy proxy2 = proxy = proxyConfig == null ? Proxy.NO_PROXY : proxyConfig.createProxy(host);
        if (!proxy.equals(Proxy.NO_PROXY) && proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            config.setProxyHost(address.getHostName());
            config.setProxyPort(address.getPort());
            if (null != proxyConfig.getUserName()) {
                config.setProxyUsername(proxyConfig.getUserName());
                config.setProxyPassword(proxyConfig.getPassword());
            }
        }
        return config;
    }

    public static String convertHostName(String ec2HostName) {
        if (ec2HostName == null || ec2HostName.length() == 0) {
            ec2HostName = DEFAULT_EC2_HOST;
        }
        if (!ec2HostName.contains(".")) {
            ec2HostName = "ec2." + ec2HostName + "." + AWS_URL_HOST;
        }
        return ec2HostName;
    }

    public static Integer convertPort(String ec2Port) {
        if (ec2Port == null || ec2Port.length() == 0) {
            return -1;
        }
        return Integer.parseInt(ec2Port);
    }

    public URL buildPresignedURL(String path) throws AmazonClientException {
        AWSCredentialsProvider provider = this.createCredentialsProvider();
        AWSCredentials credentials = provider.getCredentials();
        long expires = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(60L);
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(path, credentials.getAWSSecretKey());
        request.setExpiration(new Date(expires));
        AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(provider)).build();
        return s3.generatePresignedUrl(request);
    }

    public static URL checkEndPoint(String url) throws FormValidation {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw FormValidation.error((String)"Endpoint URL is not a valid URL");
        }
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message) {
        EC2Cloud.log(logger, level, listener, message, null);
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message, Throwable exception) {
        logger.log(level, message, exception);
        if (listener != null) {
            if (exception != null) {
                message = message + " Exception: " + exception;
            }
            LogRecord lr = new LogRecord(level, message);
            lr.setLoggerName(LOGGER.getName());
            PrintStream printStream = listener.getLogger();
            printStream.print(sf.format(lr));
        }
    }

    @Extension
    public static class EC2ConnectionUpdater
    extends PeriodicWork {
        public long getRecurrencePeriod() {
            return TimeUnit.SECONDS.toMillis(60L);
        }

        protected void doRun() throws IOException {
            Jenkins instance = Jenkins.get();
            if (instance.clouds != null) {
                for (Cloud cloud : instance.clouds) {
                    if (!(cloud instanceof EC2Cloud)) continue;
                    EC2Cloud ec2_cloud = (EC2Cloud)cloud;
                    LOGGER.finer(() -> "Checking EC2 Connection on: " + ec2_cloud.getDisplayName());
                    try {
                        if (ec2_cloud.connection == null) continue;
                        ec2_cloud.connection.describeInstances();
                    }
                    catch (AmazonClientException e) {
                        LOGGER.finer(() -> "Reconnecting to EC2 on: " + ec2_cloud.getDisplayName());
                        ec2_cloud.reconnectToEc2();
                    }
                }
            }
        }
    }

    public static abstract class DescriptorImpl
    extends Descriptor<Cloud> {
        public InstanceType[] getInstanceTypes() {
            return InstanceType.values();
        }

        public FormValidation doCheckUseInstanceProfileForCredentials(@QueryParameter boolean value) {
            if (value) {
                try {
                    new InstanceProfileCredentialsProvider(false).getCredentials();
                }
                catch (AmazonClientException e) {
                    return FormValidation.error((String)Messages.EC2Cloud_FailedToObtainCredentialsFromEC2(), (Object[])new Object[]{e.getMessage()});
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPrivateKey(@QueryParameter String value) throws IOException, ServletException {
            String line;
            boolean hasStart = false;
            boolean hasEnd = false;
            BufferedReader br = new BufferedReader(new StringReader(value));
            while ((line = br.readLine()) != null) {
                if (line.equals("-----BEGIN RSA PRIVATE KEY-----")) {
                    hasStart = true;
                }
                if (!line.equals("-----END RSA PRIVATE KEY-----")) continue;
                hasEnd = true;
            }
            if (!hasStart) {
                return FormValidation.error((String)"This doesn't look like a private key at all");
            }
            if (!hasEnd) {
                return FormValidation.error((String)"The private key is missing the trailing 'END RSA PRIVATE KEY' marker. Copy&paste error?");
            }
            return FormValidation.ok();
        }

        protected FormValidation doTestConnection(URL ec2endpoint, boolean useInstanceProfileForCredentials, String credentialsId, String privateKey, String roleArn, String roleSessionName, String region) throws IOException, ServletException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                EC2PrivateKey pk;
                AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
                AmazonEC2 ec2 = AmazonEC2Factory.getInstance().connect(credentialsProvider, ec2endpoint);
                ec2.describeInstances();
                if (privateKey == null) {
                    return FormValidation.error((String)"Private key is not specified. Please fill the private key field with a valid one.");
                }
                if (privateKey.trim().length() > 0 && (pk = new EC2PrivateKey(privateKey)).find(ec2) == null) {
                    return FormValidation.error((String)("The EC2 key pair private key isn't registered to this EC2 region (fingerprint is " + pk.getFingerprint() + ")"));
                }
                return FormValidation.ok((String)Messages.EC2Cloud_Success());
            }
            catch (AmazonClientException e) {
                LOGGER.log(Level.WARNING, "Failed to check EC2 credential", e);
                return FormValidation.error((String)e.getMessage());
            }
        }

        public ListBoxModel doFillCredentialsIdItems() {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.always(), (Iterable)CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }
    }
}

