/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win.winrm.request;

import hudson.plugins.ec2.win.winrm.request.AbstractWinRMRequest;
import hudson.plugins.ec2.win.winrm.soap.Namespaces;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class SendInputRequest
extends AbstractWinRMRequest {
    byte[] input;
    private final String commandId;
    private final String shellId;

    public SendInputRequest(URL url, byte[] input, String shellId, String commandId) {
        super(url);
        this.input = (byte[])input.clone();
        this.commandId = commandId;
        this.shellId = shellId;
    }

    @Override
    protected void construct() {
        try {
            this.defaultHeader().action(new URI("http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Send")).resourceURI(new URI("http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd")).shellId(this.shellId);
            Element body = DocumentHelper.createElement((QName)QName.get((String)"Send", (Namespace)Namespaces.NS_WIN_SHELL));
            body.addElement(QName.get((String)"Stream", (Namespace)Namespaces.NS_WIN_SHELL)).addAttribute("Name", "stdin").addAttribute("CommandId", this.commandId).addText(Base64.getEncoder().encodeToString(this.input));
            this.setBody(body);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error while building request content", e);
        }
    }
}

