/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DeviceMappingParser {
    private DeviceMappingParser() {
    }

    public static List<BlockDeviceMapping> parse(String customDeviceMapping) {
        ArrayList<BlockDeviceMapping> deviceMappings = new ArrayList<BlockDeviceMapping>();
        for (String mapping : customDeviceMapping.split(",")) {
            String[] mappingPair = mapping.split("=");
            String device = mappingPair[0];
            String blockDevice = mappingPair[1];
            BlockDeviceMapping deviceMapping = new BlockDeviceMapping().withDeviceName(device);
            if (blockDevice.equals("none")) {
                deviceMapping.setNoDevice("none");
            } else if (blockDevice.startsWith("ephemeral")) {
                deviceMapping.setVirtualName(blockDevice);
            } else {
                deviceMapping.setEbs(DeviceMappingParser.parseEbs(blockDevice));
            }
            deviceMappings.add(deviceMapping);
        }
        return deviceMappings;
    }

    private static EbsBlockDevice parseEbs(String blockDevice) {
        String[] parts = blockDevice.split(":");
        EbsBlockDevice ebs = new EbsBlockDevice();
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 0))) {
            ebs.setSnapshotId(parts[0]);
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 1))) {
            ebs.setVolumeSize(Integer.valueOf(parts[1]));
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 2))) {
            ebs.setDeleteOnTermination(Boolean.valueOf(parts[2]));
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 3))) {
            ebs.setVolumeType(parts[3]);
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 4))) {
            ebs.setIops(Integer.valueOf(parts[4]));
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 5))) {
            ebs.setEncrypted(Boolean.valueOf(parts[5].equals("encrypted")));
        }
        return ebs;
    }

    private static String getOrEmpty(String[] arr, int idx) {
        if (idx < arr.length) {
            return arr[idx];
        }
        return "";
    }
}

