/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import hudson.plugins.ec2.EC2Cloud;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CloudHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudHelper.class);

    CloudHelper() {
    }

    static Instance getInstanceWithRetry(String instanceId, EC2Cloud cloud) throws AmazonClientException, InterruptedException {
        for (int i = 0; i < 5; ++i) {
            try {
                return CloudHelper.getInstance(instanceId, cloud);
            }
            catch (AmazonServiceException e) {
                if (!e.getErrorCode().equals("InvalidInstanceID.NotFound")) {
                    throw e;
                }
                Thread.sleep(5000L);
                continue;
            }
        }
        return CloudHelper.getInstance(instanceId, cloud);
    }

    @CheckForNull
    static Instance getInstance(String instanceId, EC2Cloud cloud) throws AmazonClientException {
        if (StringUtils.isEmpty((String)instanceId) || cloud == null) {
            return null;
        }
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        request.setInstanceIds(Collections.singletonList(instanceId));
        List reservations = cloud.connect().describeInstances(request).getReservations();
        if (reservations.size() != 1) {
            String message = "Unexpected number of reservations reported by EC2 for instance id '" + instanceId + "', expected 1 result, found " + reservations + ".";
            if (reservations.size() == 0) {
                message = message + " Instance seems to be dead.";
            }
            LOGGER.info(message);
            throw new AmazonClientException(message);
        }
        Reservation reservation = (Reservation)reservations.get(0);
        List instances = reservation.getInstances();
        if (instances.size() != 1) {
            String message = "Unexpected number of instances reported by EC2 for instance id '" + instanceId + "', expected 1 result, found " + instances + ".";
            if (instances.size() == 0) {
                message = message + " Instance seems to be dead.";
            }
            LOGGER.info(message);
            throw new AmazonClientException(message);
        }
        return (Instance)instances.get(0);
    }
}

