/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.KeyPair;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2ComputerLauncher;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.remoting.Channel;
import hudson.slaves.CommandLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;

public class EC2UnixLauncher
extends EC2ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(EC2UnixLauncher.class.getName());
    private static final String BOOTSTRAP_AUTH_SLEEP_MS = "jenkins.ec2.bootstrapAuthSleepMs";
    private static final String BOOTSTRAP_AUTH_TRIES = "jenkins.ec2.bootstrapAuthTries";
    private static int bootstrapAuthSleepMs = 30000;
    private static int bootstrapAuthTries = 30;
    private final int FAILED = -1;

    protected void log(Level level, EC2Computer computer, TaskListener listener, String message) {
        EC2Cloud cloud = computer.getCloud();
        if (cloud != null) {
            EC2Cloud.log(LOGGER, level, listener, message);
        }
    }

    protected void logException(EC2Computer computer, TaskListener listener, String message, Throwable exception) {
        EC2Cloud cloud = computer.getCloud();
        if (cloud != null) {
            EC2Cloud.log(LOGGER, Level.WARNING, listener, message, exception);
        }
    }

    protected void logInfo(EC2Computer computer, TaskListener listener, String message) {
        this.log(Level.INFO, computer, listener, message);
    }

    protected void logWarning(EC2Computer computer, TaskListener listener, String message) {
        this.log(Level.WARNING, computer, listener, message);
    }

    protected String buildUpCommand(EC2Computer computer, String command) {
        if (!computer.getRemoteAdmin().equals("root")) {
            command = computer.getRootCommandPrefix() + " " + command;
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launch(EC2Computer computer, TaskListener listener, Instance inst) throws IOException, AmazonClientException, InterruptedException {
        Connection cleanupConn = null;
        boolean successful = false;
        PrintStream logger = listener.getLogger();
        this.logInfo(computer, listener, "Launching instance: " + computer.getNode().getInstanceId());
        try {
            boolean isBootstrapped = this.bootstrap(computer, listener);
            if (isBootstrapped) {
                this.logInfo(computer, listener, "connect fresh as root");
                cleanupConn = this.connectToSsh(computer, listener);
                KeyPair key = computer.getCloud().getKeyPair();
                if (!cleanupConn.authenticateWithPublicKey(computer.getRemoteAdmin(), key.getKeyMaterial().toCharArray(), "")) {
                    this.logWarning(computer, listener, "Authentication failed");
                    return;
                }
            } else {
                this.logWarning(computer, listener, "bootstrapresult failed");
                return;
            }
            final Connection conn = cleanupConn;
            SCPClient scp = conn.createSCPClient();
            String initScript = computer.getNode().initScript;
            String tmpDir = Util.fixEmptyAndTrim((String)computer.getNode().tmpDir) != null ? computer.getNode().tmpDir : "/tmp";
            this.logInfo(computer, listener, "Creating tmp directory (" + tmpDir + ") if it does not exist");
            conn.exec("mkdir -p " + tmpDir, (OutputStream)logger);
            if (initScript != null && initScript.trim().length() > 0 && conn.exec("test -e ~/.hudson-run-init", (OutputStream)logger) != 0) {
                this.logInfo(computer, listener, "Executing init script");
                scp.put(initScript.getBytes("UTF-8"), "init.sh", tmpDir, "0700");
                Session sess = conn.openSession();
                sess.requestDumbPTY();
                sess.execCommand(this.buildUpCommand(computer, tmpDir + "/init.sh"));
                sess.getStdin().close();
                sess.getStderr().close();
                IOUtils.copy((InputStream)sess.getStdout(), (OutputStream)logger);
                int exitStatus = this.waitCompletion(sess);
                if (exitStatus != 0) {
                    this.logWarning(computer, listener, "init script failed: exit code=" + exitStatus);
                    return;
                }
                sess.close();
                sess = conn.openSession();
                sess.requestDumbPTY();
                sess.execCommand(this.buildUpCommand(computer, "touch ~/.hudson-run-init"));
                sess.close();
            }
            this.logInfo(computer, listener, "Verifying that java exists");
            if (conn.exec("java -fullversion", (OutputStream)logger) != 0) {
                this.logInfo(computer, listener, "Installing Java");
                String jdk = "java1.6.0_12";
                String path = "/hudson-ci/jdk/linux-i586/" + jdk + ".tgz";
                URL url = computer.getCloud().buildPresignedURL(path);
                if (conn.exec("wget -nv -O " + tmpDir + "/" + jdk + ".tgz '" + url + "'", (OutputStream)logger) != 0) {
                    this.logWarning(computer, listener, "Failed to download Java");
                    return;
                }
                if (conn.exec(this.buildUpCommand(computer, "tar xz -C /usr -f " + tmpDir + "/" + jdk + ".tgz"), (OutputStream)logger) != 0) {
                    this.logWarning(computer, listener, "Failed to install Java");
                    return;
                }
                if (conn.exec(this.buildUpCommand(computer, "ln -s /usr/" + jdk + "/bin/java /bin/java"), (OutputStream)logger) != 0) {
                    this.logWarning(computer, listener, "Failed to symlink Java");
                    return;
                }
            }
            this.logInfo(computer, listener, "Copying slave.jar");
            scp.put(Jenkins.getInstance().getJnlpJars("slave.jar").readFully(), "slave.jar", tmpDir);
            String jvmopts = computer.getNode().jvmopts;
            String prefix = computer.getSlaveCommandPrefix();
            String launchString = prefix + " java " + (jvmopts != null ? jvmopts : "") + " -jar " + tmpDir + "/slave.jar";
            SlaveTemplate slaveTemplate = computer.getSlaveTemplate();
            if (slaveTemplate != null && slaveTemplate.isConnectBySSHProcess()) {
                EC2AbstractSlave node = computer.getNode();
                File identityKeyFile = this.createIdentityKeyFile(computer);
                try {
                    String sshClientLaunchString = String.format("ssh -o StrictHostKeyChecking=no -i %s %s@%s -p %d %s", identityKeyFile.getAbsolutePath(), node.remoteAdmin, this.getEC2HostAddress(computer, inst), node.getSshPort(), launchString);
                    this.logInfo(computer, listener, "Launching slave agent (via SSH client process): " + sshClientLaunchString);
                    CommandLauncher commandLauncher = new CommandLauncher(sshClientLaunchString);
                    commandLauncher.launch((SlaveComputer)computer, listener);
                }
                finally {
                    identityKeyFile.delete();
                }
            } else {
                this.logInfo(computer, listener, "Launching slave agent (via Trilead SSH2 Connection): " + launchString);
                final Session sess = conn.openSession();
                sess.execCommand(launchString);
                computer.setChannel(sess.getStdout(), sess.getStdin(), logger, new Channel.Listener(){

                    public void onClosed(Channel channel, IOException cause) {
                        sess.close();
                        conn.close();
                    }
                });
            }
            successful = true;
        }
        finally {
            if (cleanupConn != null && !successful) {
                cleanupConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createIdentityKeyFile(EC2Computer computer) throws IOException {
        String privateKey = computer.getCloud().getPrivateKey().getPrivateKey();
        File tempFile = File.createTempFile("ec2_", ".pem");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
            try {
                writer.write(privateKey);
                writer.flush();
            }
            finally {
                writer.close();
                fileOutputStream.close();
            }
            FilePath filePath = new FilePath(tempFile);
            filePath.chmod(256);
            return tempFile;
        }
        catch (Exception e) {
            tempFile.delete();
            throw new IOException("Error creating temporary identity key file for connecting to EC2 slave.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bootstrap(EC2Computer computer, TaskListener listener) throws IOException, InterruptedException, AmazonClientException {
        this.logInfo(computer, listener, "bootstrap()");
        try (Connection bootstrapConn = null;){
            int tries = bootstrapAuthTries;
            boolean isAuthenticated = false;
            this.logInfo(computer, listener, "Getting keypair...");
            KeyPair key = computer.getCloud().getKeyPair();
            this.logInfo(computer, listener, "Using key: " + key.getKeyName() + "\n" + key.getKeyFingerprint() + "\n" + key.getKeyMaterial().substring(0, 160));
            while (tries-- > 0) {
                this.logInfo(computer, listener, "Authenticating as " + computer.getRemoteAdmin());
                try {
                    bootstrapConn = this.connectToSsh(computer, listener);
                    isAuthenticated = bootstrapConn.authenticateWithPublicKey(computer.getRemoteAdmin(), key.getKeyMaterial().toCharArray(), "");
                }
                catch (IOException e) {
                    this.logException(computer, listener, "Exception trying to authenticate", e);
                    bootstrapConn.close();
                }
                if (isAuthenticated) break;
                this.logWarning(computer, listener, "Authentication failed. Trying again...");
                Thread.sleep(bootstrapAuthSleepMs);
            }
            if (!isAuthenticated) {
                this.logWarning(computer, listener, "Authentication failed");
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private Connection connectToSsh(EC2Computer computer, TaskListener listener) throws AmazonClientException, InterruptedException {
        long timeout = computer.getNode().getLaunchTimeoutInMillis();
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                Proxy proxy;
                long waitTime = System.currentTimeMillis() - startTime;
                if (timeout > 0L && waitTime > timeout) {
                    throw new AmazonClientException("Timed out after " + waitTime / 1000L + " seconds of waiting for ssh to become available. (maximum timeout configured is " + timeout / 1000L + ")");
                }
                Instance instance = computer.updateInstanceDescription();
                String host = this.getEC2HostAddress(computer, instance);
                if ("0.0.0.0".equals(host)) {
                    this.logWarning(computer, listener, "Invalid host 0.0.0.0, your host is most likely waiting for an ip address.");
                    throw new IOException("goto sleep");
                }
                int port = computer.getSshPort();
                Integer slaveConnectTimeout = Integer.getInteger("jenkins.ec2.slaveConnectTimeout", 10000);
                this.logInfo(computer, listener, "Connecting to " + host + " on port " + port + ", with timeout " + slaveConnectTimeout + ".");
                Connection conn = new Connection(host, port);
                ProxyConfiguration proxyConfig = Jenkins.getInstance().proxy;
                Proxy proxy2 = proxy = proxyConfig == null ? Proxy.NO_PROXY : proxyConfig.createProxy(host);
                if (!proxy.equals(Proxy.NO_PROXY) && proxy.address() instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                    HTTPProxyData proxyData = null;
                    proxyData = null != proxyConfig.getUserName() ? new HTTPProxyData(address.getHostName(), address.getPort(), proxyConfig.getUserName(), proxyConfig.getPassword()) : new HTTPProxyData(address.getHostName(), address.getPort());
                    conn.setProxyData((ProxyData)proxyData);
                    this.logInfo(computer, listener, "Using HTTP Proxy Configuration");
                }
                conn.connect(new ServerHostKeyVerifier(){

                    public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
                        return true;
                    }
                }, slaveConnectTimeout.intValue(), slaveConnectTimeout.intValue());
                this.logInfo(computer, listener, "Connected via SSH.");
                return conn;
            }
            catch (IOException e) {
                this.logInfo(computer, listener, "Failed to connect via ssh: " + e.getMessage());
                this.logInfo(computer, listener, "Waiting for SSH to come up. Sleeping 5.");
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
    }

    private String getEC2HostAddress(EC2Computer computer, Instance inst) {
        if (computer.getNode().usePrivateDnsName) {
            return inst.getPrivateDnsName();
        }
        String host = inst.getPublicDnsName();
        if (host == null || host.equals("")) {
            SlaveTemplate slaveTemplate = computer.getSlaveTemplate();
            if (inst.getPublicIpAddress() != null && slaveTemplate.isConnectUsingPublicIp()) {
                host = inst.getPublicIpAddress();
            }
        }
        if (host == null || host.equals("")) {
            host = inst.getPrivateIpAddress();
        }
        return host;
    }

    private int waitCompletion(Session session) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            Integer r = session.getExitStatus();
            if (r != null) {
                return r;
            }
            Thread.sleep(100L);
        }
        return -1;
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }

    static {
        String prop = System.getProperty(BOOTSTRAP_AUTH_SLEEP_MS);
        if (prop != null) {
            bootstrapAuthSleepMs = Integer.parseInt(prop);
        }
        if ((prop = System.getProperty(BOOTSTRAP_AUTH_TRIES)) != null) {
            bootstrapAuthTries = Integer.parseInt(prop);
        }
    }
}

