/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.ec2.AMITypeData;
import hudson.util.Secret;
import java.util.concurrent.TimeUnit;
import org.kohsuke.stapler.DataBoundConstructor;

public class WindowsData
extends AMITypeData {
    private final Secret password;
    private final boolean useHTTPS;
    private final String bootDelay;

    @DataBoundConstructor
    public WindowsData(String password, boolean useHTTPS, String bootDelay) {
        this.password = Secret.fromString((String)password);
        this.useHTTPS = useHTTPS;
        this.bootDelay = bootDelay;
    }

    @Override
    public boolean isWindows() {
        return true;
    }

    @Override
    public boolean isUnix() {
        return false;
    }

    public Secret getPassword() {
        return this.password;
    }

    public boolean isUseHTTPS() {
        return this.useHTTPS;
    }

    public String getBootDelay() {
        return this.bootDelay;
    }

    public int getBootDelayInMillis() {
        try {
            return (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(this.bootDelay));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bootDelay == null ? 0 : this.bootDelay.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.useHTTPS ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WindowsData other = (WindowsData)((Object)obj);
        if (this.bootDelay == null ? other.bootDelay != null : !this.bootDelay.equals(other.bootDelay)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals((Object)other.password)) {
            return false;
        }
        return this.useHTTPS == other.useHTTPS;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AMITypeData> {
        public String getDisplayName() {
            return "windows";
        }
    }
}

