/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.UnrecoverableKeyException;
import jenkins.bouncycastle.api.PEMEncodable;

public class EC2PrivateKey {
    private final Secret privateKey;

    EC2PrivateKey(String privateKey) {
        this.privateKey = Secret.fromString((String)privateKey.trim());
    }

    public String getPrivateKey() {
        return this.privateKey.getPlainText();
    }

    public String getFingerprint() throws IOException {
        String pemData = this.privateKey.getPlainText();
        if (pemData == null || pemData.isEmpty()) {
            throw new IOException("This private key cannot be empty");
        }
        try {
            return PEMEncodable.decode((String)pemData).getPrivateKeyFingerprint();
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException("This private key is password protected, which isn't supported yet");
        }
    }

    public String getPublicFingerprint() throws IOException {
        try {
            return PEMEncodable.decode((String)this.privateKey.getPlainText()).getPublicKeyFingerprint();
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException("This private key is password protected, which isn't supported yet");
        }
    }

    public boolean isPrivateKey() throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new StringReader(this.privateKey.getPlainText()));
        while ((line = br.readLine()) != null) {
            if (!line.equals("-----BEGIN RSA PRIVATE KEY-----")) continue;
            return true;
        }
        return false;
    }

    public KeyPair find(AmazonEC2 ec2) throws IOException, AmazonClientException {
        String fp = this.getFingerprint();
        String pfp = this.getPublicFingerprint();
        for (KeyPairInfo kp : ec2.describeKeyPairs().getKeyPairs()) {
            if (kp.getKeyFingerprint().equalsIgnoreCase(fp)) {
                KeyPair keyPair = new KeyPair();
                keyPair.setKeyName(kp.getKeyName());
                keyPair.setKeyFingerprint(fp);
                keyPair.setKeyMaterial(Secret.toString((Secret)this.privateKey));
                return keyPair;
            }
            if (!kp.getKeyFingerprint().equalsIgnoreCase(pfp)) continue;
            KeyPair keyPair = new KeyPair();
            keyPair.setKeyName(kp.getKeyName());
            keyPair.setKeyFingerprint(pfp);
            keyPair.setKeyMaterial(Secret.toString((Secret)this.privateKey));
            return keyPair;
        }
        return null;
    }

    public int hashCode() {
        return this.privateKey.hashCode();
    }

    public boolean equals(Object that) {
        return this.getClass() == that.getClass() && this.privateKey.equals((Object)((EC2PrivateKey)that).privateKey);
    }

    public String toString() {
        return this.privateKey.getPlainText();
    }
}

