/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class EC2ComputerLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(EC2ComputerLauncher.class.getName());

    public void launch(SlaveComputer slaveComputer, TaskListener listener) {
        block18: {
            try {
                String instanceId;
                EC2Computer computer = (EC2Computer)slaveComputer;
                while ((instanceId = computer.getInstanceId()) == null || instanceId.equals("")) {
                    EC2SpotSlave ec2Slave = (EC2SpotSlave)computer.getNode();
                    if (ec2Slave.isSpotRequestDead()) {
                        return;
                    }
                    String msg = "Node " + computer.getName() + "(SpotRequest " + computer.getSpotInstanceRequestId() + ") still requesting the instance, waiting 10s";
                    ((EC2Computer)slaveComputer).getCloud();
                    EC2Cloud.log(LOGGER, Level.FINEST, listener, msg);
                    Thread.sleep(10000L);
                }
                String baseMsg = "Node " + computer.getName() + "(" + computer.getInstanceId() + ")";
                block12: while (true) {
                    String msg;
                    switch (computer.getState()) {
                        case PENDING: {
                            msg = baseMsg + " is still pending/launching, waiting 5s";
                            break;
                        }
                        case STOPPING: {
                            msg = baseMsg + " is still stopping, waiting 5s";
                            break;
                        }
                        case RUNNING: {
                            msg = baseMsg + " is ready";
                            ((EC2Computer)slaveComputer).getCloud();
                            EC2Cloud.log(LOGGER, Level.FINER, listener, msg);
                            break block12;
                        }
                        case STOPPED: {
                            msg = baseMsg + " is stopped, sending start request";
                            ((EC2Computer)slaveComputer).getCloud();
                            EC2Cloud.log(LOGGER, Level.INFO, listener, msg);
                            AmazonEC2 ec2 = computer.getCloud().connect();
                            ArrayList<String> instances = new ArrayList<String>();
                            instances.add(computer.getInstanceId());
                            StartInstancesRequest siRequest = new StartInstancesRequest(instances);
                            StartInstancesResult siResult = ec2.startInstances(siRequest);
                            msg = baseMsg + ": sent start request, result: " + siResult;
                            ((EC2Computer)slaveComputer).getCloud();
                            EC2Cloud.log(LOGGER, Level.INFO, listener, msg);
                            continue block12;
                        }
                        case SHUTTING_DOWN: 
                        case TERMINATED: {
                            msg = baseMsg + " is terminated or terminating, aborting launch";
                            ((EC2Computer)slaveComputer).getCloud();
                            EC2Cloud.log(LOGGER, Level.INFO, listener, msg);
                            return;
                        }
                        default: {
                            msg = baseMsg + " is in an unknown state, retrying in 5s";
                        }
                    }
                    ((EC2Computer)slaveComputer).getCloud();
                    EC2Cloud.log(LOGGER, Level.FINEST, listener, msg);
                    Thread.sleep(5000L);
                }
                this.launch(computer, listener, computer.describeInstance());
            }
            catch (AmazonClientException e) {
                e.printStackTrace(listener.error(e.getMessage()));
                if (slaveComputer.getNode() instanceof EC2AbstractSlave) {
                    LOGGER.log(Level.FINE, String.format("Terminating the ec2 agent %s due a problem launching or connecting to it", slaveComputer.getName()), e);
                    EC2AbstractSlave ec2AbstractSlave = (EC2AbstractSlave)slaveComputer.getNode();
                    if (ec2AbstractSlave != null) {
                        ec2AbstractSlave.terminate();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace(listener.error(e.getMessage()));
                if (slaveComputer.getNode() instanceof EC2AbstractSlave) {
                    LOGGER.log(Level.FINE, String.format("Terminating the ec2 agent %s due a problem launching or connecting to it", slaveComputer.getName()), e);
                    EC2AbstractSlave ec2AbstractSlave = (EC2AbstractSlave)slaveComputer.getNode();
                    if (ec2AbstractSlave != null) {
                        ec2AbstractSlave.terminate();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace(listener.error(e.getMessage()));
                if (!(slaveComputer.getNode() instanceof EC2AbstractSlave)) break block18;
                LOGGER.log(Level.FINE, String.format("Terminating the ec2 agent %s due a problem launching or connecting to it", slaveComputer.getName()), e);
                EC2AbstractSlave ec2AbstractSlave = (EC2AbstractSlave)slaveComputer.getNode();
                if (ec2AbstractSlave == null) break block18;
                ec2AbstractSlave.terminate();
            }
        }
    }

    protected abstract void launch(EC2Computer var1, TaskListener var2, Instance var3) throws AmazonClientException, IOException, InterruptedException;
}

