/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.UnixData;
import hudson.plugins.ec2.WindowsData;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public abstract class EC2AbstractSlave
extends Slave {
    private static final Logger LOGGER = Logger.getLogger(EC2AbstractSlave.class.getName());
    protected String instanceId;
    public final String initScript;
    public final String tmpDir;
    public final String remoteAdmin;
    public final String templateDescription;
    public final String jvmopts;
    public final boolean stopOnTerminate;
    public final String idleTerminationMinutes;
    public final boolean usePrivateDnsName;
    public final boolean useDedicatedTenancy;
    public boolean isConnected = false;
    public List<EC2Tag> tags;
    public final String cloudName;
    public AMITypeData amiType;
    public transient String publicDNS;
    public transient String privateDNS;
    protected transient Instance lastFetchInstance = null;
    protected transient long lastFetchTime;
    protected static final long MIN_FETCH_TIME = 20000L;
    protected final int launchTimeout;
    @Deprecated
    protected transient int sshPort;
    @Deprecated
    public transient String rootCommandPrefix;
    public transient String slaveCommandPrefix;
    private transient long createdTime;
    public static final String TEST_ZONE = "testZone";

    public EC2AbstractSlave(String name, String instanceId, String description, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, boolean usePrivateDnsName, boolean useDedicatedTenancy, int launchTimeout, AMITypeData amiType) throws Descriptor.FormException, IOException {
        super(name, "", remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, nodeProperties);
        this.instanceId = instanceId;
        this.templateDescription = description;
        this.initScript = initScript;
        this.tmpDir = tmpDir;
        this.remoteAdmin = remoteAdmin;
        this.jvmopts = jvmopts;
        this.stopOnTerminate = stopOnTerminate;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.tags = tags;
        this.usePrivateDnsName = usePrivateDnsName;
        this.useDedicatedTenancy = useDedicatedTenancy;
        this.cloudName = cloudName;
        this.launchTimeout = launchTimeout;
        this.amiType = amiType;
        this.readResolve();
    }

    protected Object readResolve() {
        if (this.instanceId == null) {
            this.instanceId = this.getNodeName();
        }
        if (this.amiType == null) {
            this.amiType = new UnixData(this.rootCommandPrefix, this.slaveCommandPrefix, Integer.toString(this.sshPort));
        }
        return this;
    }

    public EC2Cloud getCloud() {
        return (EC2Cloud)Jenkins.getInstance().getCloud(this.cloudName);
    }

    static int toNumExecutors(InstanceType it) {
        switch (it) {
            case T1Micro: {
                return 1;
            }
            case M1Small: {
                return 1;
            }
            case M1Medium: {
                return 2;
            }
            case M3Medium: {
                return 2;
            }
            case M1Large: {
                return 4;
            }
            case M3Large: {
                return 4;
            }
            case M4Large: {
                return 4;
            }
            case C1Medium: {
                return 5;
            }
            case M2Xlarge: {
                return 6;
            }
            case C3Large: {
                return 7;
            }
            case C4Large: {
                return 7;
            }
            case M1Xlarge: {
                return 8;
            }
            case M22xlarge: {
                return 13;
            }
            case M3Xlarge: {
                return 13;
            }
            case M4Xlarge: {
                return 13;
            }
            case C3Xlarge: {
                return 14;
            }
            case C4Xlarge: {
                return 14;
            }
            case C1Xlarge: {
                return 20;
            }
            case M24xlarge: {
                return 26;
            }
            case M32xlarge: {
                return 26;
            }
            case M42xlarge: {
                return 26;
            }
            case G22xlarge: {
                return 26;
            }
            case C32xlarge: {
                return 28;
            }
            case C42xlarge: {
                return 28;
            }
            case Cc14xlarge: {
                return 33;
            }
            case Cg14xlarge: {
                return 33;
            }
            case Hi14xlarge: {
                return 35;
            }
            case Hs18xlarge: {
                return 35;
            }
            case C34xlarge: {
                return 55;
            }
            case C44xlarge: {
                return 55;
            }
            case M44xlarge: {
                return 55;
            }
            case Cc28xlarge: {
                return 88;
            }
            case Cr18xlarge: {
                return 88;
            }
            case C38xlarge: {
                return 108;
            }
            case C48xlarge: {
                return 108;
            }
            case M410xlarge: {
                return 120;
            }
        }
        return 1;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Computer createComputer() {
        return new EC2Computer(this);
    }

    public static Instance getInstance(String instanceId, EC2Cloud cloud) {
        if (instanceId == null || instanceId == "" || cloud == null) {
            return null;
        }
        Instance i = null;
        try {
            List instances;
            DescribeInstancesRequest request = new DescribeInstancesRequest();
            request.setInstanceIds(Collections.singletonList(instanceId));
            AmazonEC2 ec2 = cloud.connect();
            List reservations = ec2.describeInstances(request).getReservations();
            if (!reservations.isEmpty() && !(instances = ((Reservation)reservations.get(0)).getInstances()).isEmpty()) {
                i = (Instance)instances.get(0);
            }
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, "Failed to fetch EC2 instance: " + instanceId, e);
        }
        return i;
    }

    public abstract void terminate();

    void stop() {
        try {
            AmazonEC2 ec2 = this.getCloud().connect();
            StopInstancesRequest request = new StopInstancesRequest(Collections.singletonList(this.getInstanceId()));
            LOGGER.fine("Sending stop request for " + this.getInstanceId());
            ec2.stopInstances(request);
            LOGGER.info("EC2 instance stop request sent for " + this.getInstanceId());
            this.toComputer().disconnect(null);
        }
        catch (AmazonClientException e) {
            Instance i = EC2AbstractSlave.getInstance(this.getInstanceId(), this.getCloud());
            LOGGER.log(Level.WARNING, "Failed to stop EC2 instance: " + this.getInstanceId() + " info: " + (i != null ? i : ""), e);
        }
    }

    boolean terminateInstance() {
        try {
            AmazonEC2 ec2 = this.getCloud().connect();
            TerminateInstancesRequest request = new TerminateInstancesRequest(Collections.singletonList(this.getInstanceId()));
            LOGGER.fine("Sending terminate request for " + this.getInstanceId());
            ec2.terminateInstances(request);
            LOGGER.info("EC2 instance terminate request sent for " + this.getInstanceId());
            return true;
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, "Failed to terminate EC2 instance: " + this.getInstanceId(), e);
            return false;
        }
    }

    public Node reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        if (form == null) {
            return null;
        }
        EC2AbstractSlave result = (EC2AbstractSlave)super.reconfigure(req, form);
        this.clearLiveInstancedata();
        result.pushLiveInstancedata();
        return result;
    }

    void idleTimeout() {
        LOGGER.info("EC2 instance idle time expired: " + this.getInstanceId());
        if (!this.stopOnTerminate) {
            this.terminate();
        } else {
            this.stop();
        }
    }

    public long getLaunchTimeoutInMillis() {
        return (long)this.launchTimeout * 1000L;
    }

    String getRemoteAdmin() {
        if (this.remoteAdmin == null || this.remoteAdmin.length() == 0) {
            return this.amiType.isWindows() ? "Administrator" : "root";
        }
        return this.remoteAdmin;
    }

    String getRootCommandPrefix() {
        String commandPrefix;
        String string = commandPrefix = this.amiType.isUnix() ? ((UnixData)this.amiType).getRootCommandPrefix() : "";
        if (commandPrefix == null || commandPrefix.length() == 0) {
            return "";
        }
        return commandPrefix + " ";
    }

    String getSlaveCommandPrefix() {
        String commandPrefix;
        String string = commandPrefix = this.amiType.isUnix() ? ((UnixData)this.amiType).getSlaveCommandPrefix() : "";
        if (commandPrefix == null || commandPrefix.length() == 0) {
            return "";
        }
        return commandPrefix + " ";
    }

    String getJvmopts() {
        return Util.fixNull((String)this.jvmopts);
    }

    public int getSshPort() {
        String sshPort;
        String string = sshPort = this.amiType.isUnix() ? ((UnixData)this.amiType).getSshPort() : "22";
        if (sshPort == null || sshPort.length() == 0) {
            return 22;
        }
        int port = 0;
        try {
            port = Integer.parseInt(sshPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port != 0 ? port : 22;
    }

    public boolean getStopOnTerminate() {
        return this.stopOnTerminate;
    }

    public void onConnected() {
        this.isConnected = true;
    }

    protected boolean isAlive(boolean force) {
        this.fetchLiveInstanceData(force);
        if (this.lastFetchInstance == null) {
            return false;
        }
        return !this.lastFetchInstance.getState().getName().equals(InstanceStateName.Terminated.toString());
    }

    protected void fetchLiveInstanceData(boolean force) throws AmazonClientException {
        long now = System.currentTimeMillis();
        if (this.lastFetchTime > 0L && now - this.lastFetchTime < 20000L && !force) {
            return;
        }
        if (this.getInstanceId() == null || this.getInstanceId() == "") {
            return;
        }
        Instance i = EC2AbstractSlave.getInstance(this.getInstanceId(), this.getCloud());
        this.lastFetchTime = now;
        this.lastFetchInstance = i;
        if (i == null) {
            return;
        }
        this.publicDNS = i.getPublicDnsName();
        this.privateDNS = i.getPrivateIpAddress();
        this.createdTime = i.getLaunchTime().getTime();
        this.tags = new LinkedList<EC2Tag>();
        for (Tag t : i.getTags()) {
            this.tags.add(new EC2Tag(t.getKey(), t.getValue()));
        }
    }

    protected void clearLiveInstancedata() throws AmazonClientException {
        Instance inst = EC2AbstractSlave.getInstance(this.getInstanceId(), this.getCloud());
        if (!this.tags.isEmpty()) {
            HashSet<Tag> instTags = new HashSet<Tag>();
            for (EC2Tag t : this.tags) {
                instTags.add(new Tag(t.getName(), t.getValue()));
            }
            DeleteTagsRequest tagRequest = new DeleteTagsRequest();
            tagRequest.withResources(new String[]{inst.getInstanceId()}).setTags(instTags);
            this.getCloud().connect().deleteTags(tagRequest);
        }
    }

    protected void pushLiveInstancedata() throws AmazonClientException {
        Instance inst = EC2AbstractSlave.getInstance(this.getInstanceId(), this.getCloud());
        if (inst != null && this.tags != null && !this.tags.isEmpty()) {
            HashSet<Tag> instTags = new HashSet<Tag>();
            for (EC2Tag t : this.tags) {
                instTags.add(new Tag(t.getName(), t.getValue()));
            }
            CreateTagsRequest tagRequest = new CreateTagsRequest();
            tagRequest.withResources(new String[]{inst.getInstanceId()}).setTags(instTags);
            this.getCloud().connect().createTags(tagRequest);
        }
    }

    public String getPublicDNS() {
        this.fetchLiveInstanceData(false);
        return this.publicDNS;
    }

    public String getPrivateDNS() {
        this.fetchLiveInstanceData(false);
        return this.privateDNS;
    }

    public List<EC2Tag> getTags() {
        this.fetchLiveInstanceData(false);
        return Collections.unmodifiableList(this.tags);
    }

    public long getCreatedTime() {
        this.fetchLiveInstanceData(false);
        return this.createdTime;
    }

    public boolean getUsePrivateDnsName() {
        return this.usePrivateDnsName;
    }

    public Secret getAdminPassword() {
        return this.amiType.isWindows() ? ((WindowsData)this.amiType).getPassword() : Secret.fromString((String)"");
    }

    public boolean isUseHTTPS() {
        return this.amiType.isWindows() && ((WindowsData)this.amiType).isUseHTTPS();
    }

    public int getBootDelay() {
        return this.amiType.isWindows() ? ((WindowsData)this.amiType).getBootDelayInMillis() : 0;
    }

    public static ListBoxModel fillZoneItems(AWSCredentialsProvider credentialsProvider, String region) {
        ListBoxModel model = new ListBoxModel();
        if (AmazonEC2Cloud.testMode) {
            model.add(TEST_ZONE);
            return model;
        }
        if (!StringUtils.isEmpty((String)region)) {
            AmazonEC2 client = EC2Cloud.connect(credentialsProvider, AmazonEC2Cloud.getEc2EndpointUrl(region));
            DescribeAvailabilityZonesResult zones = client.describeAvailabilityZones();
            List zoneList = zones.getAvailabilityZones();
            model.add("<not specified>", "");
            for (AvailabilityZone z : zoneList) {
                model.add(z.getZoneName(), z.getZoneName());
            }
        }
        return model;
    }

    public abstract String getEc2Type();

    public static abstract class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public abstract String getDisplayName();

        public boolean isInstantiable() {
            return false;
        }

        public ListBoxModel doFillZoneItems(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region) {
            AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
            return EC2AbstractSlave.fillZoneItems(credentialsProvider, region);
        }

        public List<Descriptor<AMITypeData>> getAMITypeDescriptors() {
            return Jenkins.getInstance().getDescriptorList(AMITypeData.class);
        }
    }
}

