/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard.impl.repositories.nexus;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import de.codecentric.jenkins.dashboard.api.repositories.Artifact;
import de.codecentric.jenkins.dashboard.api.repositories.RepositoryInterface;
import de.codecentric.jenkins.dashboard.impl.repositories.nexus.NexusArtifact;
import de.codecentric.jenkins.dashboard.impl.repositories.nexus.SearchResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusConnector
implements RepositoryInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(NexusConnector.class);
    private String username;
    private String password;
    private URI repositoryURI;

    public NexusConnector(String username, String password, URI repositoryURI) {
        this.username = username;
        this.password = password;
        this.repositoryURI = repositoryURI;
    }

    @Override
    public boolean canConnect() {
        LOGGER.info("Checking Nexus connection");
        Client client = this.buildClient();
        WebResource restResource = client.resource(this.repositoryURI);
        ClientResponse response = (ClientResponse)restResource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
        int status = response.getStatus();
        if (status == 200) {
            return true;
        }
        LOGGER.warn("Could not connect to {}. ResponseCode: {}", (Object)this.repositoryURI, (Object)status);
        return false;
    }

    @Override
    public List<Artifact> getArtefactList(String artifactId) {
        return this.getArtefactList("", artifactId);
    }

    @Override
    public List<Artifact> getArtefactList(String groupId, String artifactId) {
        LOGGER.info("Get artifact list for " + groupId + " " + artifactId);
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        Client client = this.buildClient();
        WebResource restResource = client.resource(this.repositoryURI);
        WebResource path = restResource.path("service").path("local").path("lucene").path("search");
        WebResource queryParam = path.queryParam("g", groupId).queryParam("a", artifactId);
        ClientResponse clientResponse = (ClientResponse)queryParam.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
        SearchResponse response = (SearchResponse)clientResponse.getEntity(SearchResponse.class);
        List<NexusArtifact> data = response.getData();
        for (NexusArtifact nexusArtifact : data) {
            Artifact a = new Artifact(nexusArtifact.getArtifactId(), nexusArtifact.getVersion(), "");
            list.add(a);
        }
        return list;
    }

    private Client buildClient() {
        DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
        config.getState().setCredentials(null, null, -1, this.username, this.password);
        config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        ApacheHttpClient restClient = ApacheHttpClient.create((ClientConfig)config);
        restClient.setFollowRedirects(Boolean.valueOf(true));
        return restClient;
    }
}

