/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard.ec2;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import de.codecentric.jenkins.dashboard.Messages;
import de.codecentric.jenkins.dashboard.impl.environments.ec2.EC2Connector;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.util.StringUtils;

@NameWith(value=StandardCredentials.NameProvider.class, priority=-16)
public class AwsKeyCredentials
extends BaseStandardCredentials {
    private static final Logger LOGGER = Logger.getLogger(AwsKeyCredentials.class.getName());
    private static final long serialVersionUID = 7732948788576624160L;
    public String key;
    public Secret secret;

    @DataBoundConstructor
    public AwsKeyCredentials(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @Nonnull String key, @Nonnull Secret secret) {
        super(scope, id != null ? id : key, description);
        this.key = key;
        this.secret = secret;
    }

    public AWSCredentials getAwsAuthCredentials() {
        return new BasicAWSCredentials(this.key, this.secret.getPlainText());
    }

    @Extension
    public static class AwsKeyCredentialsDescriptor
    extends CredentialsDescriptor {
        public AwsKeyCredentialsDescriptor(Class<? extends Credentials> clazz) {
            super(clazz);
        }

        public AwsKeyCredentialsDescriptor() {
        }

        public String getDisplayName() {
            return Messages.AwsKeyCredentials_name();
        }

        public FormValidation doTestAwsConnection(@QueryParameter(value="key") String accessKey, @QueryParameter(value="secret") Secret secretKey) {
            FormValidation validationResult;
            LOGGER.info("Verify AWS connection key " + accessKey);
            try {
                AWSCredentials awsCredentials = this.createCredentials(accessKey, secretKey.getPlainText());
                EC2Connector conn = new EC2Connector((AmazonEC2)new AmazonEC2Client(awsCredentials));
                validationResult = conn.areAwsCredentialsValid() ? FormValidation.ok((String)Messages.AwsKeyCredentials_awsConnectionSuccessful()) : FormValidation.warning((String)Messages.AwsKeyCredentials_awsConnectionFailed());
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
                validationResult = FormValidation.error((String)(Messages.AwsKeyCredentials_awsConnectionCritical() + e.getMessage()));
            }
            return validationResult;
        }

        protected AWSCredentials createCredentials(String accessKey, String secretKey) {
            BasicAWSCredentials result = null;
            if (StringUtils.hasText((String)accessKey) && StringUtils.hasText((String)secretKey)) {
                result = new BasicAWSCredentials(accessKey, secretKey);
            }
            return result;
        }
    }
}

