/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard.api.environments;

import com.amazonaws.services.ec2.model.InstanceState;
import de.codecentric.jenkins.dashboard.Messages;
import de.codecentric.jenkins.dashboard.api.environments.EnvironmentTag;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ServerEnvironment {
    private String instanceId;
    private String environmentTag;
    private String instanceType;
    private String version;
    private String publicIpAddress;
    private String privateIpAddress;
    private String urlPrefix;
    private String urlPostfix;
    private Date launchTime;
    private InstanceState state;
    private List<EnvironmentTag> tags;
    private ENVIRONMENT_TYPES type;

    public ServerEnvironment(String instanceId, String instanceType) {
        this.instanceId = instanceId;
        this.instanceType = instanceType;
        this.type = ENVIRONMENT_TYPES.DEFAULT;
    }

    public String getEnvironmentTag() {
        return this.environmentTag;
    }

    public void setEnvironmentTag(String environmentTag) {
        this.environmentTag = environmentTag;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<EnvironmentTag> getTags() {
        return this.tags;
    }

    public void setTags(List<EnvironmentTag> tags) {
        this.tags = tags;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ENVIRONMENT_TYPES getType() {
        return this.type;
    }

    public void setType(ENVIRONMENT_TYPES type) {
        this.type = type;
    }

    public InstanceState getState() {
        return this.state;
    }

    public void setState(InstanceState state) {
        this.state = state;
    }

    public Date getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(Date launchTime) {
        this.launchTime = launchTime;
    }

    public String getPublicIpAddress() {
        if (this.state.getName().equalsIgnoreCase("running")) {
            return this.publicIpAddress;
        }
        return Messages.ServerEnvironment_serverNotRunning();
    }

    public String getWebAppLink() {
        if (this.state.getName().equalsIgnoreCase("running")) {
            if (this.publicIpAddress == null) {
                return this.urlPrefix + this.privateIpAddress + this.urlPostfix;
            }
            return this.urlPrefix + this.publicIpAddress + this.urlPostfix;
        }
        return Messages.ServerEnvironment_serverNotRunning();
    }

    public String displayWebAppLink() {
        if (this.state.getName().equalsIgnoreCase("running")) {
            return "true";
        }
        return "false";
    }

    public void setPublicIpAddress(String publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public String getUrlPostfix() {
        return this.urlPostfix;
    }

    public void setUrlPostfix(String urlPostfix) {
        this.urlPostfix = urlPostfix;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static enum ENVIRONMENT_TYPES {
        DEFAULT,
        TEST,
        PRODUCTION,
        STAGING,
        JENKINS;


        public static ENVIRONMENT_TYPES getType(String type) {
            if (type != null) {
                for (ENVIRONMENT_TYPES t : ENVIRONMENT_TYPES.values()) {
                    if (!type.contains(t.toString())) continue;
                    return t;
                }
            }
            return DEFAULT;
        }
    }
}

