/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard;

import de.codecentric.jenkins.dashboard.DashboardView;
import de.codecentric.jenkins.dashboard.Environment;
import de.codecentric.jenkins.dashboard.Messages;
import de.codecentric.jenkins.dashboard.impl.repositories.RepositoryTypes;
import de.codecentric.jenkins.dashboard.impl.repositories.artifactory.ArtifactoryConnector;
import hudson.model.Descriptor;
import hudson.model.ViewDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.util.StringUtils;

public final class DashboardViewDescriptor
extends ViewDescriptor {
    private static final Logger LOGGER = Logger.getLogger(DashboardViewDescriptor.class.getName());
    private String repositoryType;
    private String repositoryRestUri = "";
    private String username = "";
    private String password = "";

    public DashboardViewDescriptor() {
        super(DashboardView.class);
        this.load();
    }

    public String getDisplayName() {
        return Messages.DashboardView_DisplayName();
    }

    public List<Environment.EnvironmentDescriptor> getEnvironmentDescriptors() {
        return Jenkins.getInstance().getDescriptorList(Environment.class);
    }

    public String getHelpFile() {
        return "/plugin/jenkins-deployment-dashboard-plugin/help.html";
    }

    public ListBoxModel doFillRepositoryTypeItems() {
        ListBoxModel model = new ListBoxModel();
        for (RepositoryTypes value : RepositoryTypes.values()) {
            model.add(value.getDescription(), value.getid());
        }
        return model;
    }

    public FormValidation doCheckArtifactoryRestUri(@QueryParameter String artifactoryRestUri) {
        return FormValidation.ok();
    }

    public FormValidation doCheckUsername(@QueryParameter String username) {
        if (StringUtils.hasText((String)username)) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)Messages.DashboardView_artifactoryUsername());
    }

    public FormValidation doCheckPassword(@QueryParameter String password) {
        if (StringUtils.hasText((String)password)) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)Messages.DashboardView_artifactoryPassword());
    }

    public FormValidation doTestRepositoryConnection(@QueryParameter(value="repositoryRestUri") String repositoryRestUri, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
        FormValidation validationResult;
        LOGGER.info("Verify Repository connection for URI " + repositoryRestUri);
        try {
            URI repositoryURI = new URI(repositoryRestUri);
            ArtifactoryConnector repository = new ArtifactoryConnector(username, password, repositoryURI);
            LOGGER.info("Artifactory config valid? " + repository.canConnect());
            validationResult = repository.canConnect() ? FormValidation.ok((String)Messages.DashboardView_artifactoryConnectionSuccessful()) : FormValidation.warning((String)(Messages.DashboardView_artifactoryConnectionFailed() + repositoryRestUri));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            validationResult = FormValidation.error((String)(Messages.DashboardView_artifactoryConnectionCritical() + e.getMessage()));
        }
        return validationResult;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json.getJSONObject("deployment-dashboard"));
        this.save();
        return true;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    public String getRepositoryRestUri() {
        return this.repositoryRestUri;
    }

    public void setRepositoryRestUri(String repositoryRestUri) {
        this.repositoryRestUri = repositoryRestUri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

