/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import com.google.common.io.Files;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Platform;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Shell;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public final class BourneShellScript
extends FileMonitoringTask {
    private static final Logger LOGGER = Logger.getLogger(BourneShellScript.class.getName());
    private static final String SYSTEM_DEFAULT_CHARSET = "SYSTEM_DEFAULT";
    private static final String LAUNCH_DIAGNOSTICS_PROP = BourneShellScript.class.getName() + ".LAUNCH_DIAGNOSTICS";
    private static boolean LAUNCH_DIAGNOSTICS = Boolean.getBoolean(LAUNCH_DIAGNOSTICS_PROP);
    static int HEARTBEAT_CHECK_INTERVAL = Integer.getInteger(BourneShellScript.class.getName() + ".HEARTBEAT_CHECK_INTERVAL", 300);
    private static int HEARTBEAT_MINIMUM_DELTA = Integer.getInteger(BourneShellScript.class.getName() + ".HEARTBEAT_MINIMUM_DELTA", 2);
    @Nonnull
    private final String script;
    private boolean capturingOutput;

    @DataBoundConstructor
    public BourneShellScript(String script) {
        this.script = Util.fixNull((String)script);
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    @Override
    protected FileMonitoringTask.FileMonitoringController launchWithCookie(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars, String cookieVariable, String cookieValue) throws IOException, InterruptedException {
        if (this.script.isEmpty()) {
            listener.getLogger().println("Warning: was asked to run an empty script");
        }
        OsType os = (OsType)((Object)ws.act((Callable)new getOsType()));
        String scriptEncodingCharset = "UTF-8";
        if (os == OsType.ZOS) {
            Charset zOSSystemEncodingCharset = Charset.forName((String)ws.act((Callable)new getIBMzOsEncoding()));
            if (SYSTEM_DEFAULT_CHARSET.equals(this.getCharset())) {
                this.charset(zOSSystemEncodingCharset);
            }
            scriptEncodingCharset = zOSSystemEncodingCharset.name();
        }
        ShellController c = new ShellController(ws, os == OsType.ZOS);
        FilePath shf = c.getScriptFile(ws);
        shf.write(this.script, scriptEncodingCharset);
        Jenkins jenkins = Jenkins.getInstance();
        String interpreter = "";
        if (!this.script.startsWith("#!")) {
            String shell = ((Shell.DescriptorImpl)jenkins.getDescriptorByType(Shell.DescriptorImpl.class)).getShell();
            if (shell == null) {
                shell = "sh";
            }
            interpreter = "'" + shell + "' -xe ";
        } else {
            shf.chmod(493);
        }
        String scriptPath = shf.getRemote();
        ArrayList<String> args = new ArrayList<String>();
        if (os != OsType.DARWIN) {
            args.add("nohup");
        }
        if (os == OsType.WINDOWS) {
            scriptPath = scriptPath.replace("\\", "/");
        }
        envVars.put(cookieVariable, "please-do-not-kill-me");
        FilePath logFile = c.getLogFile(ws);
        FilePath resultFile = c.getResultFile(ws);
        FilePath controlDir = c.controlDir(ws);
        String cmd = this.capturingOutput ? String.format("pid=$$; { while [ \\( -d /proc/$pid -o \\! -d /proc/$$ \\) -a -d '%s' -a \\! -f '%s' ]; do touch '%s'; sleep 3; done } & jsc=%s; %s=$jsc %s '%s' > '%s' 2> '%s'; echo $? > '%s.tmp'; mv '%s.tmp' '%s'; wait", controlDir, resultFile, logFile, cookieValue, cookieVariable, interpreter, scriptPath, c.getOutputFile(ws), logFile, resultFile, resultFile, resultFile) : String.format("pid=$$; { while [ \\( -d /proc/$pid -o \\! -d /proc/$$ \\) -a -d '%s' -a \\! -f '%s' ]; do touch '%s'; sleep 3; done } & jsc=%s; %s=$jsc %s '%s' > '%s' 2>&1; echo $? > '%s.tmp'; mv '%s.tmp' '%s'; wait", controlDir, resultFile, logFile, cookieValue, cookieVariable, interpreter, scriptPath, logFile, resultFile, resultFile, resultFile);
        cmd = cmd.replace("$", "$$");
        if (LAUNCH_DIAGNOSTICS) {
            args.addAll(Arrays.asList("sh", "-c", cmd));
        } else {
            args.addAll(Arrays.asList("sh", "-c", "(" + cmd + ") >&- 2>&- &"));
        }
        LOGGER.log(Level.FINE, "launching {0}", args);
        Launcher.ProcStarter ps = launcher.launch().cmds(args).envs(BourneShellScript.escape(envVars)).pwd(ws).quiet(true);
        if (LAUNCH_DIAGNOSTICS) {
            ps.stdout(listener);
        } else {
            ps.readStdout().readStderr();
        }
        ps.start();
        return c;
    }

    static class StatusCheckWithEncoding
    extends MasterToSlaveFileCallable<Integer> {
        private final String charset;

        StatusCheckWithEncoding(String charset) {
            this.charset = charset;
        }

        @CheckForNull
        public Integer invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            if (f.exists() && f.length() > 0L) {
                try {
                    String fileString = Files.readFirstLine((File)f, (Charset)Charset.forName(this.charset));
                    if (fileString == null || fileString.isEmpty()) {
                        return null;
                    }
                    if ((fileString = fileString.trim()).isEmpty()) {
                        return null;
                    }
                    return Integer.parseInt(fileString);
                }
                catch (NumberFormatException x) {
                    throw new IOException("corrupted content in " + f + ": " + x, x);
                }
            }
            return null;
        }
    }

    private static final class getIBMzOsEncoding
    extends MasterToSlaveCallable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private getIBMzOsEncoding() {
        }

        public String call() throws RuntimeException {
            return System.getProperty("ibm.system.encoding");
        }
    }

    private static final class getOsType
    extends MasterToSlaveCallable<OsType, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private getOsType() {
        }

        public OsType call() throws RuntimeException {
            if (Platform.isDarwin()) {
                return OsType.DARWIN;
            }
            if (Platform.current() == Platform.WINDOWS) {
                return OsType.WINDOWS;
            }
            if (Platform.current() == Platform.UNIX && System.getProperty("os.name").equals("z/OS")) {
                return OsType.ZOS;
            }
            return OsType.UNIX;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.BourneShellScript_bourne_shell();
        }
    }

    static final class ShellController
    extends FileMonitoringTask.FileMonitoringController {
        private transient long lastCheck;
        private transient long checkedTimestamp;
        private final boolean isZos;
        private static final long serialVersionUID = 1L;

        private ShellController(FilePath ws, boolean zOsFlag) throws IOException, InterruptedException {
            super(ws);
            this.isZos = zOsFlag;
        }

        public FilePath getScriptFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("script.sh");
        }

        private FilePath pidFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("pid");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected Integer exitStatus(FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
            long currentTimestamp;
            block10: {
                block9: {
                    Integer status;
                    if (this.isZos) {
                        FilePath statusFile = this.getResultFile(workspace);
                        status = (Integer)statusFile.act((FilePath.FileCallable)new StatusCheckWithEncoding(this.getCharset()));
                    } else {
                        status = super.exitStatus(workspace, listener);
                    }
                    if (status != null) {
                        LOGGER.log(Level.FINE, "found exit code {0} in {1}", new Object[]{status, this.controlDir});
                        return status;
                    }
                    long now = System.nanoTime();
                    if (this.lastCheck == 0L) {
                        LOGGER.log(Level.FINE, "starting check in {0}", this.controlDir);
                        this.lastCheck = now;
                        return null;
                    }
                    if (now <= this.lastCheck + TimeUnit.SECONDS.toNanos(HEARTBEAT_CHECK_INTERVAL)) return null;
                    this.lastCheck = now;
                    currentTimestamp = this.getLogFile(workspace).lastModified();
                    if (currentTimestamp == 0L) {
                        listener.getLogger().println("process apparently never started in " + this.controlDir);
                        if (LAUNCH_DIAGNOSTICS) return this.recordExitStatus(workspace, -2);
                        listener.getLogger().println("(running Jenkins temporarily with -D" + LAUNCH_DIAGNOSTICS_PROP + "=true might make the problem clearer)");
                        return this.recordExitStatus(workspace, -2);
                    }
                    if (this.checkedTimestamp <= 0L) break block9;
                    if (currentTimestamp < this.checkedTimestamp) {
                        listener.getLogger().println("apparent clock skew in " + this.controlDir);
                        break block10;
                    } else if (currentTimestamp < this.checkedTimestamp + TimeUnit.SECONDS.toMillis(HEARTBEAT_MINIMUM_DELTA)) {
                        FilePath pidFile = this.pidFile(workspace);
                        if (!pidFile.exists()) {
                            listener.getLogger().println("wrapper script does not seem to be touching the log file in " + this.controlDir);
                            listener.getLogger().println("(JENKINS-48300: if on an extremely laggy filesystem, consider -Dorg.jenkinsci.plugins.durabletask.BourneShellScript.HEARTBEAT_CHECK_INTERVAL=86400)");
                            return this.recordExitStatus(workspace, -1);
                        }
                        listener.getLogger().println("still have " + pidFile + " so heartbeat checks unreliable; process may or may not be alive");
                    }
                    break block10;
                }
                LOGGER.log(Level.FINE, "seeing recent log file modifications in {0}", this.controlDir);
            }
            this.checkedTimestamp = currentTimestamp;
            return null;
        }

        private int recordExitStatus(FilePath workspace, int code) throws IOException, InterruptedException {
            this.getResultFile(workspace).write(Integer.toString(code), null);
            return code;
        }
    }

    private static enum OsType {
        DARWIN,
        UNIX,
        WINDOWS,
        ZOS;

    }
}

