/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask.executors;

import hudson.Extension;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.durabletask.executors.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public interface ContinuedTask
extends Queue.Task {
    public boolean isContinued();

    @Extension
    @Restricted(value={DoNotUse.class})
    public static class Scheduler
    extends QueueTaskDispatcher {
        private static boolean isContinued(Queue.Task task) {
            return task instanceof ContinuedTask && ((ContinuedTask)task).isContinued();
        }

        public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
            if (Scheduler.isContinued(item.task)) {
                return null;
            }
            for (Queue.BuildableItem other : Queue.getInstance().getBuildableItems()) {
                Label label;
                if (!Scheduler.isContinued(other.task) || (label = other.task.getAssignedLabel()) != null && !label.matches(node)) continue;
                Logger.getLogger(ContinuedTask.class.getName()).log(Level.FINE, "blocking {0} in favor of {1}", new Object[]{item.task, other.task});
                return new HoldOnPlease(other.task);
            }
            return null;
        }

        private static final class HoldOnPlease
        extends CauseOfBlockage {
            private final Queue.Task task;

            HoldOnPlease(Queue.Task task) {
                this.task = task;
            }

            public String getShortDescription() {
                return Messages.ContinuedTask__should_be_allowed_to_run_first(this.task.getFullDisplayName());
            }
        }
    }
}

