/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public final class PowershellScript
extends FileMonitoringTask {
    private final String script;
    private boolean capturingOutput;

    @DataBoundConstructor
    public PowershellScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    @Override
    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="%n from master might be \\n")
    protected FileMonitoringTask.FileMonitoringController doLaunch(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        PowershellController c = new PowershellController(ws);
        String cmd = this.capturingOutput ? String.format("$(& \"%s\" | Out-File -FilePath \"%s\" -Encoding UTF8) 2>&1 3>&1 4>&1 5>&1 | Out-File -FilePath \"%s\" -Encoding UTF8; $LastExitCode | Out-File -FilePath \"%s\" -Encoding ASCII; $outputWithBom = Get-Content \"%s\"; [IO.File]::WriteAllLines(\"%s\", $outputWithBom);", PowershellScript.quote(c.getPowershellMainFile(ws)), PowershellScript.quote(c.getTemporaryOutputFile(ws)), PowershellScript.quote(c.getLogFile(ws)), PowershellScript.quote(c.getResultFile(ws)), PowershellScript.quote(c.getTemporaryOutputFile(ws)), PowershellScript.quote(c.getOutputFile(ws))) : String.format("& \"%s\" *>&1 | Out-File -FilePath \"%s\" -Encoding UTF8; $LastExitCode | Out-File -FilePath \"%s\" -Encoding ASCII;", PowershellScript.quote(c.getPowershellMainFile(ws)), PowershellScript.quote(c.getLogFile(ws)), PowershellScript.quote(c.getResultFile(ws)));
        c.getPowershellScriptFile(ws).write(this.script, "UTF-8");
        c.getPowershellMainFile(ws).write("try {\r\n& '" + PowershellScript.quote(c.getPowershellScriptFile(ws)) + "'\r\n} catch {\r\nWrite-Error $_; exit 1;\r\n}\r\nfinally {\r\nif ($LastExitCode -ne $null) {\r\nexit $LastExitCode;\r\n} elseif ($error.Count -gt 0 -or !$?) {\r\nexit 1;\r\n} else {\r\nexit 0;\r\n}\r\n}", "UTF-8");
        c.getPowershellWrapperFile(ws).write(cmd, "UTF-8");
        if (launcher.isUnix()) {
            args.addAll(Arrays.asList("powershell", "-NonInteractive", "-File", c.getPowershellWrapperFile(ws).getRemote()));
        } else {
            args.addAll(Arrays.asList("powershell.exe", "-NonInteractive", "-ExecutionPolicy", "Bypass", "-File", c.getPowershellWrapperFile(ws).getRemote()));
        }
        Launcher.ProcStarter ps = launcher.launch().cmds(args).envs(PowershellScript.escape(envVars)).pwd(ws).quiet(true);
        listener.getLogger().println("[" + ws.getRemote().replaceFirst("^.+(\\\\|/)", "") + "] Running PowerShell script");
        ps.readStdout().readStderr();
        ps.start();
        return c;
    }

    private static String quote(FilePath f) {
        return f.getRemote().replace("$", "`$");
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.PowershellScript_powershell();
        }
    }

    private static final class PowershellController
    extends FileMonitoringTask.FileMonitoringController {
        private static final long serialVersionUID = 1L;

        private PowershellController(FilePath ws) throws IOException, InterruptedException {
            super(ws);
        }

        public FilePath getPowershellMainFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("powershellMain.ps1");
        }

        public FilePath getPowershellScriptFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("powershellScript.ps1");
        }

        public FilePath getPowershellWrapperFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("powershellWrapper.ps1");
        }

        public FilePath getTemporaryOutputFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("temporaryOutput.txt");
        }
    }
}

