/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.slaves.WorkspaceList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.DurableTask;

public abstract class FileMonitoringTask
extends DurableTask {
    private static final Logger LOGGER = Logger.getLogger(FileMonitoringTask.class.getName());
    private static final String COOKIE = "JENKINS_SERVER_COOKIE";

    private static String cookieFor(FilePath workspace) {
        return "durable-" + Util.getDigestOf((String)workspace.getRemote());
    }

    @Override
    public final Controller launch(EnvVars env, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return this.launchWithCookie(workspace, launcher, listener, env, COOKIE, FileMonitoringTask.cookieFor(workspace));
    }

    protected FileMonitoringController launchWithCookie(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars, String cookieVariable, String cookieValue) throws IOException, InterruptedException {
        envVars.put(cookieVariable, cookieValue);
        return this.doLaunch(workspace, launcher, listener, envVars);
    }

    protected FileMonitoringController doLaunch(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        throw new AbstractMethodError("override either doLaunch or launchWithCookie");
    }

    protected static class FileMonitoringController
    extends Controller {
        private String controlDir;
        private String id;
        private long lastLocation;
        private static final long serialVersionUID = 1L;

        protected FileMonitoringController(FilePath ws) throws IOException, InterruptedException {
            ws.mkdirs();
            FilePath cd = FileMonitoringController.tempDir(ws).child("durable-" + Util.getDigestOf((String)UUID.randomUUID().toString()).substring(0, 8));
            cd.mkdirs();
            this.controlDir = cd.getRemote();
        }

        @Override
        public final boolean writeLog(FilePath workspace, OutputStream sink) throws IOException, InterruptedException {
            FilePath log = this.getLogFile(workspace);
            Long newLocation = (Long)log.act((FilePath.FileCallable)new WriteLog(this.lastLocation, (OutputStream)new RemoteOutputStream(sink)));
            if (newLocation != null) {
                LOGGER.log(Level.FINE, "copied {0} bytes from {1}", new Object[]{newLocation - this.lastLocation, log});
                this.lastLocation = newLocation;
                return true;
            }
            return false;
        }

        @Override
        public Integer exitStatus(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            FilePath status = this.getResultFile(workspace);
            if (status.exists()) {
                try {
                    return Integer.parseInt(status.readToString().trim());
                }
                catch (NumberFormatException x) {
                    throw new IOException("corrupted content in " + status + ": " + x, x);
                }
            }
            return null;
        }

        @Override
        public byte[] getOutput(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            return IOUtils.toByteArray((InputStream)this.getOutputFile(workspace).read());
        }

        @Override
        public final void stop(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            launcher.kill(Collections.singletonMap(FileMonitoringTask.COOKIE, FileMonitoringTask.cookieFor(workspace)));
        }

        @Override
        public void cleanup(FilePath workspace) throws IOException, InterruptedException {
            this.controlDir(workspace).deleteRecursive();
        }

        public FilePath controlDir(FilePath ws) throws IOException, InterruptedException {
            if (this.controlDir != null) {
                return ws.child(this.controlDir);
            }
            assert (this.id != null);
            FilePath cd = ws.child("." + this.id);
            if (!cd.isDirectory()) {
                cd = ws.child(".jenkins-" + this.id);
            }
            this.controlDir = cd.getRemote();
            this.id = null;
            LOGGER.info("using migrated control directory " + this.controlDir + " for remainder of this task");
            return cd;
        }

        private static FilePath tempDir(FilePath ws) {
            return ws.sibling(ws.getName() + System.getProperty(WorkspaceList.class.getName(), "@") + "tmp");
        }

        public FilePath getResultFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("jenkins-result.txt");
        }

        public FilePath getLogFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("jenkins-log.txt");
        }

        public FilePath getOutputFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("output.txt");
        }

        @Override
        public String getDiagnostics(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            FilePath cd = this.controlDir(workspace);
            VirtualChannel channel = cd.getChannel();
            String node = channel instanceof Channel ? ((Channel)channel).getName() : null;
            String location = node != null ? cd.getRemote() + " on " + node : cd.getRemote();
            Integer code = this.exitStatus(workspace, launcher);
            if (code != null) {
                return "completed process (code " + code + ") in " + location;
            }
            return "awaiting process completion in " + location;
        }

        private static class WriteLog
        extends MasterToSlaveFileCallable<Long> {
            private final long lastLocation;
            private final OutputStream sink;

            WriteLog(long lastLocation, OutputStream sink) {
                this.lastLocation = lastLocation;
                this.sink = sink;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                long len = f.length();
                if (len > this.lastLocation) {
                    RandomAccessFile raf = new RandomAccessFile(f, "r");
                    try {
                        raf.seek(this.lastLocation);
                        long toRead = len - this.lastLocation;
                        if (toRead > Integer.MAX_VALUE) {
                            throw new IOException("large reads not yet implemented");
                        }
                        byte[] buf = new byte[(int)toRead];
                        raf.readFully(buf);
                        this.sink.write(buf);
                    }
                    finally {
                        raf.close();
                    }
                    return len;
                }
                return null;
            }
        }
    }
}

