/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Platform;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.jenkinsci.plugins.durabletask.ProcessLiveness;
import org.kohsuke.stapler.DataBoundConstructor;

public final class BourneShellScript
extends FileMonitoringTask {
    private static int NOVEL_WORKSPACE_DIAGNOSTICS_COUNT = Integer.getInteger(BourneShellScript.class.getName() + ".NOVEL_WORKSPACE_DIAGNOSTICS_COUNT", 10);
    private static int LAUNCH_FAILURE_TIMEOUT = Integer.getInteger(BourneShellScript.class.getName() + ".LAUNCH_FAILURE_TIMEOUT", 15);
    @Nonnull
    private final String script;
    private boolean capturingOutput;
    private static final Map<FilePath, Integer> encounteredPaths = new WeakHashMap<FilePath, Integer>();

    @DataBoundConstructor
    public BourneShellScript(String script) {
        this.script = Util.fixNull((String)script);
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileMonitoringTask.FileMonitoringController launchWithCookie(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars, String cookieVariable, String cookieValue) throws IOException, InterruptedException {
        boolean novel;
        if (this.script.isEmpty()) {
            listener.getLogger().println("Warning: was asked to run an empty script");
        }
        ShellController c = new ShellController(ws);
        FilePath shf = c.getScriptFile(ws);
        String s = this.script;
        Jenkins jenkins = Jenkins.getInstance();
        if (!s.startsWith("#!") && jenkins != null) {
            String defaultShell = ((Shell.DescriptorImpl)jenkins.getInjector().getInstance(Shell.DescriptorImpl.class)).getShellOrDefault(ws.getChannel());
            s = "#!" + defaultShell + " -xe\n" + s;
        }
        shf.write(s, "UTF-8");
        shf.chmod(493);
        envVars.put(cookieVariable, "please-do-not-kill-me");
        String cmd = this.capturingOutput ? String.format("echo $$ > '%s'; jsc=%s; %s=$jsc '%s' > '%s' 2> '%s'; echo $? > '%s'", c.pidFile(ws), cookieValue, cookieVariable, shf, c.getOutputFile(ws), c.getLogFile(ws), c.getResultFile(ws)) : String.format("echo $$ > '%s'; jsc=%s; %s=$jsc '%s' > '%s' 2>&1; echo $? > '%s'", c.pidFile(ws), cookieValue, cookieVariable, shf, c.getLogFile(ws), c.getResultFile(ws));
        cmd = cmd.replace("$", "$$");
        ArrayList<String> args = new ArrayList<String>();
        if (!((Boolean)ws.act((Callable)new DarwinCheck())).booleanValue()) {
            args.add("nohup");
        }
        args.addAll(Arrays.asList("sh", "-c", cmd));
        Launcher.ProcStarter ps = launcher.launch().cmds(args).envs((Map)envVars).pwd(ws).quiet(true);
        listener.getLogger().println("[" + ws.getRemote().replaceFirst("^.+/", "") + "] Running shell script");
        Map<FilePath, Integer> map = encounteredPaths;
        synchronized (map) {
            Integer cnt = encounteredPaths.get(ws);
            if (cnt == null) {
                cnt = 0;
            }
            novel = cnt < NOVEL_WORKSPACE_DIAGNOSTICS_COUNT;
            encounteredPaths.put(ws, cnt + 1);
        }
        if (novel) {
            ps.stdout(listener);
        } else {
            ps.readStdout().readStderr();
        }
        ps.start();
        return c;
    }

    private static final class DarwinCheck
    extends MasterToSlaveCallable<Boolean, RuntimeException> {
        private DarwinCheck() {
        }

        public Boolean call() throws RuntimeException {
            return Platform.isDarwin();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.BourneShellScript_bourne_shell();
        }
    }

    static final class ShellController
    extends FileMonitoringTask.FileMonitoringController {
        private int pid;
        private final long startTime = System.currentTimeMillis();
        private static final long serialVersionUID = 1L;

        private ShellController(FilePath ws) throws IOException, InterruptedException {
            super(ws);
        }

        public FilePath getScriptFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("script.sh");
        }

        FilePath pidFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("pid");
        }

        private synchronized int pid(FilePath ws) throws IOException, InterruptedException {
            FilePath pidFile;
            if (this.pid == 0 && (pidFile = this.pidFile(ws)).exists()) {
                try {
                    this.pid = Integer.parseInt(pidFile.readToString().trim());
                }
                catch (NumberFormatException x) {
                    throw new IOException("corrupted content in " + pidFile + ": " + x, x);
                }
            }
            return this.pid;
        }

        @Override
        public Integer exitStatus(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            Integer status = super.exitStatus(workspace, launcher);
            if (status != null) {
                return status;
            }
            int _pid = this.pid(workspace);
            if (_pid > 0 && !ProcessLiveness.isAlive(workspace.getChannel(), _pid, launcher)) {
                status = super.exitStatus(workspace, launcher);
                if (status == null) {
                    status = -1;
                }
                return status;
            }
            if (_pid == 0 && this.startTime > 0L && System.currentTimeMillis() - this.startTime > (long)(1000 * LAUNCH_FAILURE_TIMEOUT)) {
                return -2;
            }
            return null;
        }

        @Override
        public String getDiagnostics(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            return super.getDiagnostics(workspace, launcher) + " (pid: " + this.pid + ")";
        }
    }
}

