/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook.dockerregistry;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Cause;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;
import org.jenkinsci.plugins.registry.notification.webhook.dockerregistry.DockerRegistryWebHookCause;
import org.jenkinsci.plugins.registry.notification.webhook.dockerregistry.DockerRegistryWebHookPayload;

public class DockerRegistryPushNotification
extends PushNotification {
    private static final long serialVersionUID = 207798312860576090L;
    private static final Logger logger = Logger.getLogger(DockerRegistryPushNotification.class.getName());
    public static final String KEY_REPO_NAME = "DOCKER_TRIGGER_REPO_NAME";
    public static final String KEY_TAG = "DOCKER_TRIGGER_TAG";
    public static final String KEY_DOCKER_REGISTRY_HOST = "DOCKER_TRIGGER_DOCKER_REGISTRY_HOST";
    private String registryHost;
    private String tag;

    public DockerRegistryPushNotification(DockerRegistryWebHookPayload webHookPayload, String repoName) {
        super(webHookPayload);
        this.repoName = repoName;
    }

    @CheckForNull
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    @CheckForNull
    public String getRegistryHost() {
        return this.registryHost;
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }

    @Override
    public Cause getCause() {
        return new DockerRegistryWebHookCause(this);
    }

    @Override
    public Set<ParameterValue> getRunParameters() {
        String host;
        HashSet<ParameterValue> parameters = new HashSet<ParameterValue>();
        parameters.add((ParameterValue)new StringParameterValue(KEY_REPO_NAME, this.getRepoName()));
        String tag = this.getTag();
        if (!StringUtils.isBlank((String)tag)) {
            parameters.add((ParameterValue)new StringParameterValue(KEY_TAG, tag));
        }
        if (!StringUtils.isBlank((String)(host = this.getRegistryHost()))) {
            parameters.add((ParameterValue)new StringParameterValue(KEY_DOCKER_REGISTRY_HOST, host));
        }
        return parameters;
    }

    @Override
    public String getCauseMessage() {
        return "Docker image " + this.getRepoName() + " has been rebuilt by DockerRegistry@" + this.getRegistryHost();
    }

    @Override
    public String sha() {
        return Util.getDigestOf((String)("dockerRegistryNotification:" + this.repoName + Long.toBinaryString(this.getReceived())));
    }

    @Override
    public String getShortDescription() {
        return String.format("push of %s to DockerRegistry@%s", this.getRepoName(), this.getRegistryHost());
    }
}

