/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook.dockerhub;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Result;
import hudson.model.Run;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.registry.notification.TriggerStore;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;

public class DockerHubCallbackPayload
implements Serializable {
    private static final Logger logger = Logger.getLogger(DockerHubCallbackPayload.class.getName());
    private static final long serialVersionUID = 7820793734732971287L;
    private final States state;
    private final String description;
    private final String context;
    private final String targetUrl;

    public DockerHubCallbackPayload(States state, String description, String context, String targetUrl) {
        this.state = state;
        this.description = description;
        this.context = context;
        this.targetUrl = targetUrl;
    }

    public static DockerHubCallbackPayload from(@NonNull TriggerStore.TriggerEntry from) {
        Result finalRes = null;
        for (TriggerStore.TriggerEntry.RunEntry entry : from.getEntries()) {
            Run<?, ?> run = entry.getRun();
            if (run == null) continue;
            Result res = run.getResult();
            if (finalRes == null) {
                finalRes = res;
                continue;
            }
            if (!res.isWorseThan(finalRes)) continue;
            finalRes = res;
        }
        if (finalRes != null) {
            return new DockerHubCallbackPayload(States.from(finalRes), "Build result " + finalRes.toString(), "Jenkins", DockerHubCallbackPayload.constructUrl(from.getEntries(), from.getPushNotification()));
        }
        return null;
    }

    private static String constructUrl(@NonNull List<TriggerStore.TriggerEntry.RunEntry> entries, @NonNull PushNotification pushNotification) {
        Jenkins jenkins = Jenkins.getInstance();
        StringBuilder str = new StringBuilder();
        if (jenkins != null) {
            String rootUrl = jenkins.getRootUrl();
            if (rootUrl != null) {
                str.append(rootUrl);
            } else {
                logger.warning("Jenkins root URL is not configured!");
            }
        }
        return str.append("dockerhub-webhook").append("/details/").append(pushNotification.sha()).toString();
    }

    public JSONObject toJSON() {
        JSONObject j = new JSONObject();
        j.put("state", (Object)this.state.name());
        j.put("description", (Object)this.description);
        j.put("context", (Object)this.context);
        j.put("target_url", (Object)this.targetUrl);
        return j;
    }

    public States getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContext() {
        return this.context;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public String toString() {
        return "DockerHubCallbackPayload{state=" + (Object)((Object)this.state) + ", description='" + this.description + '\'' + ", context='" + this.context + '\'' + ", targetUrl='" + this.targetUrl + '\'' + '}';
    }

    public static enum States {
        success,
        failure,
        error;


        public static States from(@NonNull Result result) {
            if (result == Result.SUCCESS) {
                return success;
            }
            if (result == Result.FAILURE) {
                return error;
            }
            if (result == Result.UNSTABLE) {
                return failure;
            }
            return error;
        }
    }
}

